/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workflow;

import java.util.List;
import org.opencms.ade.publish.shared.CmsWorkflow;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;

public class CmsWorkflowResources {
    private CmsWorkflow m_overrideWorkflow;
    private List<CmsResource> m_workflowResources;
    private Integer m_tooManyCount;

    public CmsWorkflowResources(List<CmsResource> workflowResources, CmsWorkflow overrideWorkflow, Integer tooManyCount) {
        this.m_workflowResources = workflowResources;
        this.m_overrideWorkflow = overrideWorkflow;
        this.m_tooManyCount = tooManyCount;
    }

    public int getLowerBoundForSize() {
        if (this.m_tooManyCount != null) {
            return this.m_tooManyCount;
        }
        return this.m_workflowResources.size();
    }

    public CmsWorkflow getOverrideWorkflow() {
        return this.m_overrideWorkflow;
    }

    public Integer getTooManyCount() {
        return this.m_tooManyCount;
    }

    public List<CmsResource> getWorkflowResources() {
        return this.m_workflowResources;
    }

    public boolean isTooMany() {
        return this.m_tooManyCount != null || this.m_workflowResources != null && this.m_workflowResources.size() > OpenCms.getWorkflowManager().getResourceLimit();
    }
}

