/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.CmsEditorBase;
import org.opencms.workplace.editors.CmsEditorDisplayOptions;
import org.opencms.workplace.editors.CmsEditorSessionInfo;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public abstract class CmsEditor
extends CmsEditorBase {
    public static final int ACTION_CHANGE_BODY = 124;
    public static final int ACTION_DELETELOCALE = 140;
    public static final int ACTION_EXIT = 122;
    public static final int ACTION_PREVIEW = 126;
    public static final int ACTION_SAVE = 121;
    public static final int ACTION_SAVEACTION = 130;
    public static final int ACTION_SAVEEXIT = 123;
    public static final int ACTION_SHOW = 125;
    public static final int ACTION_SHOW_ERRORMESSAGE = 127;
    public static final String EDITOR_CHANGE_ELEMENT = "changeelement";
    public static final String EDITOR_CLEANUP = "cleanup";
    public static final String EDITOR_CLOSEBROWSER = "closebrowser";
    public static final String EDITOR_DELETELOCALE = "deletelocale";
    public static final String EDITOR_EXIT = "exit";
    public static final String EDITOR_PREVIEW = "preview";
    public static final String EDITOR_SAVE = "save";
    public static final String EDITOR_SAVEACTION = "saveaction";
    public static final String EDITOR_SAVEEXIT = "saveexit";
    public static final String EDITOR_SHOW = "show";
    public static final String EDITOR_SHOW_ERRORMESSAGE = "error";
    public static final String EMPTY_LOCALE = " [-]";
    public static final String PARAM_BACKLINK = "backlink";
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_DIRECTEDIT = "directedit";
    public static final String PARAM_EDITASTEXT = "editastext";
    public static final String PARAM_EDITORMODE = "editormode";
    public static final String PARAM_ELEMENTLANGUAGE = "elementlanguage";
    public static final String PARAM_LOADDEFAULT = "loaddefault";
    public static final String PARAM_MODIFIED = "modified";
    public static final String PARAM_OLDELEMENTLANGUAGE = "oldelementlanguage";
    public static final String PARAM_TEMPFILE = "tempfile";
    public static final String PATH_EDITORS = "/system/workplace/editors/";
    private static final Log LOG = CmsLog.getLog(CmsEditor.class);
    private CmsEditorSessionInfo m_editorSessionInfo;
    private String m_fileEncoding;
    private String m_paramBackLink;
    private String m_paramContent;
    private String m_paramDirectedit;
    private String m_paramEditAsText;
    private String m_paramEditormode;
    private String m_paramElementlanguage;
    private String m_paramLoadDefault;
    private String m_paramModified;
    private String m_paramOldelementlanguage;
    private String m_paramTempFile;
    private String m_picsUri;

    public CmsEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    public abstract void actionClear(boolean var1);

    public abstract void actionExit() throws CmsException, IOException, ServletException, JspException;

    public abstract void actionSave() throws IOException, JspException;

    public String buildSelectElementLanguage(String attributes, String resourceName, Locale selectedLocale) {
        List<Object> contentLocales;
        int currentIndex;
        ArrayList<String> selectList;
        ArrayList<String> options;
        List<Locale> locales;
        block6: {
            locales = OpenCms.getLocaleManager().getAvailableLocales(this.getCms(), resourceName);
            options = new ArrayList<String>(locales.size());
            selectList = new ArrayList<String>(locales.size());
            currentIndex = -1;
            contentLocales = new ArrayList();
            try {
                CmsResource res = this.getCms().readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION);
                String temporaryFilename = CmsWorkplace.getTemporaryFileName(resourceName);
                if (this.getCms().existsResource(temporaryFilename, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    res = this.getCms().readResource(temporaryFilename, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                CmsFile file = this.getCms().readFile(res);
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.getCms(), file);
                contentLocales = xmlContent.getLocales();
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)Messages.get().getBundle().key("LOG_GET_LOCALES_1", resourceName), (Throwable)e);
            }
        }
        for (int counter = 0; counter < locales.size(); ++counter) {
            Locale curLocale = locales.get(counter);
            selectList.add(curLocale.toString());
            StringBuffer buf = new StringBuffer();
            buf.append(curLocale.getDisplayName(this.getLocale()));
            if (!contentLocales.contains(curLocale)) {
                buf.append(EMPTY_LOCALE);
            }
            options.add(buf.toString());
            if (!curLocale.equals(selectedLocale)) continue;
            currentIndex = counter;
        }
        if (currentIndex == -1 && selectList.size() > 0) {
            currentIndex = 0;
            this.setParamElementlanguage((String)selectList.get(0));
        }
        return CmsEditor.buildSelect(attributes, options, selectList, currentIndex, false);
    }

    public String button(String href, String target, String image, String label, int type, boolean useCustomImage) {
        if (useCustomImage) {
            return this.button(href, target, image, label, type, this.getPicsUri());
        }
        return this.button(href, target, image, label, type);
    }

    public String buttonActionCancel() {
        String target = null;
        target = Boolean.valueOf(this.getParamDirectedit()).booleanValue() ? (CmsStringUtil.isNotEmpty(this.getParamBacklink()) ? this.getParamBacklink() : this.getParamResource()) : CmsVaadinUtils.getWorkplaceLink();
        return "onclick=\"top.location.href='" + this.getJsp().link(target) + "';\"";
    }

    public String buttonActionDirectEdit(String jsFunction, int type) {
        String name;
        Object url;
        I_CmsEditorActionHandler actionClass = OpenCms.getWorkplaceManager().getEditorActionHandler();
        boolean active = false;
        if (actionClass != null) {
            url = actionClass.getButtonUrl(this.getJsp(), this.getParamResource());
            name = actionClass.getButtonName();
            active = actionClass.isButtonActive(this.getJsp(), this.getParamResource());
        } else {
            url = CmsEditor.getSkinUri() + "buttons/publish_in.png";
            name = "GUI_EXPLORER_CONTEXT_PUBLISH_0";
        }
        String image = ((String)url).substring(((String)url).lastIndexOf("/") + 1);
        if (((String)url).endsWith(".gif")) {
            image = image.substring(0, image.length() - 4);
        }
        if (active) {
            return this.button("javascript:" + jsFunction, null, image, name, type, ((String)url).substring(0, ((String)url).lastIndexOf("/") + 1));
        }
        return this.button(null, null, image, name, type, ((String)url).substring(0, ((String)url).lastIndexOf("/") + 1));
    }

    @Override
    public void checkLock(String resource, CmsLockType type) throws CmsException {
        CmsResource res = this.getCms().readResource(resource, CmsResourceFilter.ALL);
        CmsLock lock = this.getCms().getLock(res);
        if (!lock.isNullLock()) {
            this.setParamModified(Boolean.TRUE.toString());
        }
        if (res.getSiblingCount() > 1 && lock.isInherited()) {
            super.checkLock(resource, CmsLockType.TEMPORARY);
        } else {
            super.checkLock(resource, type);
        }
    }

    public String deleteLocaleButton(String href, String target, String image, String label, int type) {
        block4: {
            String filename = this.getParamResource();
            try {
                CmsResource res = this.getCms().readResource(filename, CmsResourceFilter.IGNORE_EXPIRATION);
                String temporaryFilename = CmsWorkplace.getTemporaryFileName(filename);
                if (this.getCms().existsResource(temporaryFilename, CmsResourceFilter.IGNORE_EXPIRATION)) {
                    res = this.getCms().readResource(temporaryFilename, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                CmsFile file = this.getCms().readFile(res);
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.getCms(), file);
                int locales = xmlContent.getLocales().size();
                if (locales < 2) {
                    href = null;
                    target = null;
                    image = (String)image + "_in";
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)Messages.get().getBundle().key("LOG_GET_LOCALES_1", filename), (Throwable)e);
            }
        }
        return this.button(href, target, (String)image, label, type, CmsEditor.getSkinUri() + "buttons/");
    }

    public CmsEditorDisplayOptions getEditorDisplayOptions() {
        return OpenCms.getWorkplaceManager().getEditorDisplayOptions();
    }

    public abstract String getEditorResourceUri();

    public String getOpenCmsContext() {
        return OpenCms.getSystemInfo().getOpenCmsContext();
    }

    public String getParamBacklink() {
        if (this.m_editorSessionInfo != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_editorSessionInfo.getBackLink())) {
            this.m_paramBackLink = this.m_editorSessionInfo.getBackLink();
        }
        if (this.m_paramBackLink == null) {
            this.m_paramBackLink = "";
        }
        return this.m_paramBackLink;
    }

    public String getParamContent() {
        if (this.m_paramContent == null) {
            this.m_paramContent = "";
        }
        return this.m_paramContent;
    }

    public String getParamDirectedit() {
        if (this.m_editorSessionInfo != null) {
            return String.valueOf(this.m_editorSessionInfo.isDirectEdit());
        }
        return this.m_paramDirectedit;
    }

    public String getParamEditastext() {
        return this.m_paramEditAsText;
    }

    public String getParamEditormode() {
        return this.m_paramEditormode;
    }

    public String getParamElementlanguage() {
        if (this.m_paramElementlanguage == null && this.m_editorSessionInfo != null && this.m_editorSessionInfo.getElementLocale() != null) {
            this.m_paramElementlanguage = this.m_editorSessionInfo.getElementLocale().toString();
        }
        return this.m_paramElementlanguage;
    }

    public String getParamLoaddefault() {
        return this.m_paramLoadDefault;
    }

    public String getParamModified() {
        return this.m_paramModified;
    }

    public String getParamOldelementlanguage() {
        return this.m_paramOldelementlanguage;
    }

    public String getParamTempfile() {
        return this.m_paramTempFile;
    }

    public String getPicsUri() {
        if (this.m_picsUri == null) {
            this.m_picsUri = this.getEditorResourceUri() + "pics/";
        }
        return this.m_picsUri;
    }

    public void setParamBacklink(String backLink) {
        this.m_paramBackLink = backLink;
    }

    public void setParamContent(String content) {
        if (content == null) {
            content = "";
        }
        this.m_paramContent = content;
    }

    public void setParamDirectedit(String direct) {
        this.m_paramDirectedit = direct;
    }

    public void setParamEditastext(String editAsText) {
        this.m_paramEditAsText = editAsText;
    }

    public void setParamEditormode(String mode) {
        this.m_paramEditormode = mode;
    }

    public void setParamElementlanguage(String elementLanguage) {
        this.m_paramElementlanguage = elementLanguage;
    }

    public void setParamLoaddefault(String loadDefault) {
        this.m_paramLoadDefault = loadDefault;
    }

    public void setParamModified(String modified) {
        this.m_paramModified = modified;
    }

    public void setParamOldelementlanguage(String oldElementLanguage) {
        this.m_paramOldelementlanguage = oldElementLanguage;
    }

    public void setParamTempfile(String fileName) {
        this.m_paramTempFile = fileName;
    }

    protected void actionClose() throws IOException, JspException, ServletException {
        try {
            if (Boolean.valueOf(this.getParamDirectedit()).booleanValue()) {
                if (CmsStringUtil.isNotEmpty(this.getParamBacklink())) {
                    this.setParamCloseLink(this.getJsp().link(this.getParamBacklink()));
                } else {
                    this.setParamCloseLink(this.getJsp().link(this.getParamResource()));
                }
                this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
                this.getJsp().include("/system/workplace/commons/includes/closedialog.jsp");
            } else if (CmsStringUtil.isNotEmpty(this.getParamBacklink())) {
                this.setParamCloseLink(this.getJsp().link(this.getParamBacklink()));
                this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
                this.getJsp().include("/system/workplace/commons/includes/closedialog.jsp");
            } else {
                this.sendForward(CmsVaadinUtils.getWorkplaceLink(), new HashMap<String, String[]>());
            }
        }
        finally {
            this.clearEditorSessionInfo();
        }
    }

    protected void clearEditorSessionInfo() {
        if (this.m_editorSessionInfo != null) {
            this.getSession().removeAttribute(this.m_editorSessionInfo.getEditorSessionInfoKey());
        }
        this.m_editorSessionInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitTempFile() throws CmsException {
        CmsFile orgFile;
        List<CmsProperty> properties;
        CmsFile tempFile;
        CmsObject cms = this.getCms();
        try {
            this.switchToTempProject();
            tempFile = cms.readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
            properties = cms.readPropertyObjects(this.getParamTempfile(), false);
        }
        finally {
            this.switchToCurrentProject();
        }
        if (cms.existsResource(this.getParamResource(), CmsResourceFilter.ALL)) {
            cms.writePropertyObjects(this.getParamResource(), properties);
            orgFile = cms.readFile(this.getParamResource(), CmsResourceFilter.ALL);
            orgFile.setContents(tempFile.getContents());
            this.getCloneCms().writeFile(orgFile);
        } else {
            try {
                this.switchToTempProject();
                cms.changeLock(this.getParamTempfile());
                if (cms.hasPermissions(tempFile, CmsPermissionSet.ACCESS_CONTROL)) {
                    cms.rmacc(this.getParamTempfile(), "GROUP", OpenCms.getDefaultUsers().getGroupUsers());
                }
            }
            finally {
                this.switchToCurrentProject();
            }
            cms.copyResource(this.getParamTempfile(), this.getParamResource(), CmsResource.COPY_AS_NEW);
            orgFile = cms.readFile(this.getParamResource(), CmsResourceFilter.ALL);
            this.getCloneCms().writeFile(orgFile);
        }
        int flags = cms.readResource(this.getParamResource(), CmsResourceFilter.ALL).getFlags();
        if ((flags & 0x400) == 1024) {
            cms.chflags(this.getParamResource(), flags ^= 0x400);
        }
    }

    protected String createTempFile() throws CmsException {
        return OpenCms.getWorkplaceManager().createTempFile(this.getCms(), this.getParamResource(), this.getSettings().getProject());
    }

    protected String decodeContent(String content) {
        return CmsEncoder.unescape(content, "UTF-8");
    }

    @Override
    protected String decodeParamValue(String paramName, String paramValue) {
        if (paramName != null && paramValue != null) {
            if (PARAM_CONTENT.equals(paramName)) {
                return CmsEncoder.decode(paramValue, "UTF-8");
            }
            if ("resource".equals(paramName) || PARAM_TEMPFILE.equals(paramName)) {
                String filename = CmsEncoder.decode(paramValue, this.getCms().getRequestContext().getEncoding());
                if (PARAM_TEMPFILE.equals(paramName) || CmsStringUtil.isEmpty(this.getParamTempfile())) {
                    this.setFileEncoding(this.getFileEncoding(this.getCms(), filename));
                }
                return filename;
            }
            return CmsEncoder.decode(paramValue, this.getCms().getRequestContext().getEncoding());
        }
        return null;
    }

    protected void deleteTempFile() {
        try {
            this.switchToTempProject();
            this.getCms().deleteResource(this.getParamTempfile(), CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            block13: {
                try {
                    this.switchToCurrentProject();
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block13;
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    protected String encodeContent(String content) {
        return CmsEncoder.escapeWBlanks(content, "UTF-8");
    }

    protected CmsObject getCloneCms() throws CmsException {
        CmsObject cloneCms = OpenCms.initCmsObject(this.getCms());
        cloneCms.getRequestContext().setRequestTime(Long.MIN_VALUE);
        return cloneCms;
    }

    protected CmsEditorSessionInfo getEditorSessionInfo() {
        return this.m_editorSessionInfo;
    }

    protected String getFileEncoding() {
        return this.m_fileEncoding;
    }

    protected String getFileEncoding(CmsObject cms, String filename) {
        try {
            return cms.readPropertyObject(filename, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (CmsException e) {
            return OpenCms.getSystemInfo().getDefaultEncoding();
        }
    }

    protected abstract void initContent();

    @Override
    protected void initMessages() {
        this.initSessionInfo();
        super.initMessages();
    }

    protected void initSessionInfo() {
        CmsResource editedResource = null;
        try {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamResource())) {
                editedResource = this.getCms().readResource(this.getParamResource());
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        CmsEditorSessionInfo info = null;
        if (editedResource != null) {
            HttpSession session = this.getSession();
            info = (CmsEditorSessionInfo)session.getAttribute(CmsEditorSessionInfo.getEditorSessionInfoKey(editedResource));
            if (info == null) {
                info = new CmsEditorSessionInfo(editedResource.getStructureId());
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_paramBackLink)) {
                info.setBackLink(this.m_paramBackLink);
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_paramElementlanguage)) {
                info.setElementLocale(CmsLocaleManager.getLocale(this.m_paramElementlanguage));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_paramDirectedit)) {
                info.setDirectEdit(Boolean.parseBoolean(this.m_paramDirectedit));
            }
            session.setAttribute(info.getEditorSessionInfoKey(), (Object)info);
        }
        this.m_editorSessionInfo = info;
    }

    protected void setFileEncoding(String value) {
        this.m_fileEncoding = CmsEncoder.lookupEncoding(value, value);
    }

    protected void showErrorPage(Exception exception) throws JspException {
        this.setParamAction("");
        this.showErrorPage(this, exception);
        this.setAction(4);
    }

    protected void showErrorPage(Object editor, Exception exception) throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", editor);
        this.setAction(127);
        this.setParamTitle(this.key("GUI_TITLE_EDIT_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        if (exception != null) {
            this.getJsp().getRequest().setAttribute("throwable", (Object)exception);
            if (CmsLog.getLog(editor).isWarnEnabled()) {
                CmsLog.getLog(editor).warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.getJsp().include("/system/workplace/commons/includes/errorpage.jsp");
    }
}

