/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.workplace.CmsDialog;

public class CmsEditorBase
extends CmsDialog {
    private static final Log LOG = CmsLog.getLog(CmsEditorBase.class);

    public CmsEditorBase(CmsJspActionElement jsp) {
        super(jsp);
    }

    @Override
    protected boolean checkResourcePermissions(CmsPermissionSet required, boolean neededForFolder, CmsMessageContainer errorMessage) {
        boolean hasPermissions;
        block3: {
            hasPermissions = false;
            try {
                CmsResource res = neededForFolder ? this.getCms().readResource(CmsResource.getParentFolder(this.getParamResource()), CmsResourceFilter.ALL) : this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
                hasPermissions = this.getCms().hasPermissions(res, required, false, CmsResourceFilter.ALL) && (OpenCms.getRoleManager().hasRoleForResource(this.getCms(), CmsRole.ELEMENT_AUTHOR, this.getCms().getSitePath(res)) || OpenCms.getRoleManager().hasRoleForResource(this.getCms(), CmsRole.PROJECT_MANAGER, this.getCms().getSitePath(res)) || OpenCms.getRoleManager().hasRoleForResource(this.getCms(), CmsRole.ACCOUNT_MANAGER, this.getCms().getSitePath(res)));
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!hasPermissions) {
            this.getSettings().setErrorMessage(errorMessage);
        }
        return hasPermissions;
    }

    @Override
    protected void checkRole() throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.EDITOR);
    }

    @Override
    protected void initTimeWarp(CmsUserSettings settings, HttpSession session) {
    }
}

