/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.Locale;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsUUID;

public class CmsEditorSessionInfo {
    public static final String PREFIX_EDITOR_SESSION_INFO = "editorSessionInfo";
    private String m_backLink;
    private boolean m_directEdit;
    private CmsUUID m_editedStructureId;
    private Locale m_elementLocale;

    public CmsEditorSessionInfo(CmsUUID editedStructureId) {
        this.m_editedStructureId = editedStructureId;
    }

    protected static String getEditorSessionInfoKey(CmsResource editedResource) {
        return PREFIX_EDITOR_SESSION_INFO + editedResource.getStructureId().getStringValue();
    }

    public String getBackLink() {
        return this.m_backLink;
    }

    public CmsUUID getEditedStructureId() {
        return this.m_editedStructureId;
    }

    public String getEditorSessionInfoKey() {
        return PREFIX_EDITOR_SESSION_INFO + this.m_editedStructureId.getStringValue();
    }

    public Locale getElementLocale() {
        return this.m_elementLocale;
    }

    public boolean isDirectEdit() {
        return this.m_directEdit;
    }

    public void setBackLink(String backLink) {
        this.m_backLink = backLink;
    }

    public void setDirectEdit(boolean directEdit) {
        this.m_directEdit = directEdit;
    }

    public void setEditedStructureId(CmsUUID editedStructureId) {
        this.m_editedStructureId = editedStructureId;
    }

    public void setElementLocale(Locale elementLocale) {
        this.m_elementLocale = elementLocale;
    }
}

