/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsWorkplaceEditorConfiguration;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsWorkplaceEditorManager {
    public static final String EDITOR_CONFIGURATION_FILENAME = "editor_configuration.xml";
    public static final String EDITOR_FILENAME = "editor.jsp";
    private static final Log LOG = CmsLog.getLog(CmsWorkplaceEditorManager.class);
    private List<CmsWorkplaceEditorConfiguration> m_editorConfigurations;
    private Map<String, CmsWorkplaceEditorConfiguration> m_preferredEditors;

    public CmsWorkplaceEditorManager(CmsObject cms) {
        List<CmsResource> editorFolders;
        try {
            editorFolders = cms.getSubFolders("/system/workplace/editors/");
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_EDITIR_FOLDER_FAILED_1", "/system/workplace/editors/"));
            editorFolders = new ArrayList<CmsResource>();
        }
        this.m_editorConfigurations = new ArrayList<CmsWorkplaceEditorConfiguration>(editorFolders.size());
        for (CmsResource currentFolder : editorFolders) {
            String folderName = "/system/workplace/editors/" + currentFolder.getName();
            if (!folderName.endsWith("/")) {
                folderName = folderName + "/";
            }
            CmsFile configFile = null;
            try {
                configFile = cms.readFile(folderName + EDITOR_CONFIGURATION_FILENAME, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            byte[] xmlData = configFile.getContents();
            CmsWorkplaceEditorConfiguration editorConfig = new CmsWorkplaceEditorConfiguration(xmlData, folderName + EDITOR_FILENAME, currentFolder.getName());
            if (!editorConfig.isValidConfiguration()) continue;
            this.m_editorConfigurations.add(editorConfig);
        }
        this.m_preferredEditors = new HashMap<String, CmsWorkplaceEditorConfiguration>(this.m_editorConfigurations.size());
    }

    public static boolean checkAcaciaEditorAvailable(CmsObject cms, CmsResource resource) {
        boolean result;
        block6: {
            result = false;
            if (resource == null) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    LOG.error((Object)"Can't check widget availability because resource is null!", (Throwable)e);
                    break block6;
                }
            }
            try {
                CmsXmlContent content;
                CmsFile file;
                CmsFile cmsFile = file = resource instanceof CmsFile ? (CmsFile)resource : cms.readFile(resource);
                if (file.getContents().length > 0 && !(content = CmsXmlContentFactory.unmarshal(cms, file)).getContentDefinition().getContentHandler().isAcaciaEditorDisabled()) {
                    result = true;
                }
            }
            catch (CmsException e) {
                LOG.info((Object)("error thrown in checkAcaciaEditorAvailable for " + resource + " : " + e.getLocalizedMessage()), (Throwable)e);
                result = true;
            }
        }
        return result;
    }

    public Map<String, SortedMap<Float, CmsWorkplaceEditorConfiguration>> getConfigurableEditors() {
        HashMap<String, SortedMap<Float, CmsWorkplaceEditorConfiguration>> configurableEditors = new HashMap<String, SortedMap<Float, CmsWorkplaceEditorConfiguration>>();
        for (CmsWorkplaceEditorConfiguration currentConfig : this.m_editorConfigurations) {
            for (String key : currentConfig.getResourceTypes().keySet()) {
                CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(key);
                if (settings == null || CmsStringUtil.isNotEmpty(settings.getReference()) || currentConfig.getMappingForResourceType(key) != null && !currentConfig.getMappingForResourceType(key).equals(key)) continue;
                TreeMap<Float, CmsWorkplaceEditorConfiguration> editorConfigs = (TreeMap<Float, CmsWorkplaceEditorConfiguration>)configurableEditors.get(key);
                if (editorConfigs == null) {
                    editorConfigs = new TreeMap<Float, CmsWorkplaceEditorConfiguration>();
                }
                editorConfigs.put(Float.valueOf(currentConfig.getRankingForResourceType(key)), currentConfig);
                configurableEditors.put(key, editorConfigs);
            }
        }
        return configurableEditors;
    }

    public CmsWorkplaceEditorConfiguration getEditorConfiguration(String name) {
        for (CmsWorkplaceEditorConfiguration config : this.m_editorConfigurations) {
            if (!name.equals(config.getName())) continue;
            return config;
        }
        return null;
    }

    public String getEditorParameter(CmsObject cms, String editor, String param) {
        String path = OpenCms.getSystemInfo().getConfigFilePath(cms, "editors/" + editor + ".properties");
        CmsVfsMemoryObjectCache cache = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache();
        CmsParameterConfiguration config = (CmsParameterConfiguration)cache.getCachedObject(cms, path);
        if (config == null) {
            try {
                CmsFile file = cms.readFile(path);
                try (ByteArrayInputStream input = new ByteArrayInputStream(file.getContents());){
                    config = new CmsParameterConfiguration(input);
                    cache.putCachedObject(cms, path, config);
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                return null;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return config.getString(param, null);
    }

    public String getWidgetEditor(CmsRequestContext context, String userAgent) {
        CmsWorkplaceEditorConfiguration preferredConf;
        String resourceType;
        CmsUserSettings settings = new CmsUserSettings(context.getCurrentUser());
        String preferredEditorSetting = settings.getPreferredEditor(resourceType = CmsResourceTypeXmlPage.getStaticTypeName());
        if (preferredEditorSetting == null) {
            for (CmsWorkplaceEditorConfiguration currentConfig : this.m_editorConfigurations) {
                String mapping = currentConfig.getMappingForResourceType(resourceType);
                if (mapping != null) {
                    preferredEditorSetting = settings.getPreferredEditor(mapping);
                }
                if (preferredEditorSetting == null) continue;
                break;
            }
        }
        if (preferredEditorSetting != null && (preferredConf = this.filterPreferredEditor(preferredEditorSetting)) != null && preferredConf.isWidgetEditor() && preferredConf.matchesBrowser(userAgent)) {
            return preferredConf.getWidgetEditor();
        }
        SortedMap<Float, CmsWorkplaceEditorConfiguration> filteredEditors = this.filterEditorsForResourceType(resourceType);
        while (filteredEditors.size() > 0) {
            Float key = filteredEditors.lastKey();
            CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)filteredEditors.get(key);
            if (conf.isWidgetEditor() && conf.matchesBrowser(userAgent)) {
                return conf.getWidgetEditor();
            }
            filteredEditors.remove(key);
        }
        return null;
    }

    public boolean isEditorAvailableForResource(CmsResource res) {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res);
        String typeName = type.getTypeName();
        for (CmsWorkplaceEditorConfiguration editorConfig : this.m_editorConfigurations) {
            if (!editorConfig.matchesResourceType(typeName)) continue;
            return true;
        }
        return false;
    }

    protected String getDefaultEditorUri(CmsRequestContext context, String resourceType, String userAgent) {
        SortedMap<Float, CmsWorkplaceEditorConfiguration> filteredEditors = this.filterEditorsForResourceType(resourceType);
        while (filteredEditors.size() > 0) {
            Float key = filteredEditors.firstKey();
            CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)filteredEditors.get(key);
            if (conf.matchesBrowser(userAgent)) {
                return conf.getEditorUri();
            }
            filteredEditors.remove(key);
        }
        if (context == null) {
            return null;
        }
        return null;
    }

    protected List<CmsWorkplaceEditorConfiguration> getEditorConfigurations() {
        return this.m_editorConfigurations;
    }

    protected String getEditorUri(CmsRequestContext context, String resourceType, String userAgent) {
        CmsWorkplaceEditorConfiguration preferredConf;
        CmsUserSettings settings = new CmsUserSettings(context.getCurrentUser());
        String preferredEditorSetting = settings.getPreferredEditor(resourceType);
        if (preferredEditorSetting == null) {
            for (CmsWorkplaceEditorConfiguration currentConfig : this.m_editorConfigurations) {
                String mapping = currentConfig.getMappingForResourceType(resourceType);
                if (mapping != null) {
                    preferredEditorSetting = settings.getPreferredEditor(mapping);
                }
                if (preferredEditorSetting == null) continue;
                break;
            }
        }
        if (preferredEditorSetting != null && (preferredConf = this.filterPreferredEditor(preferredEditorSetting)) != null && preferredConf.matchesBrowser(userAgent)) {
            return preferredConf.getEditorUri();
        }
        SortedMap<Float, CmsWorkplaceEditorConfiguration> filteredEditors = this.filterEditorsForResourceType(resourceType);
        while (filteredEditors.size() > 0) {
            Float key = filteredEditors.lastKey();
            CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)filteredEditors.get(key);
            if (conf.matchesBrowser(userAgent)) {
                return conf.getEditorUri();
            }
            filteredEditors.remove(key);
        }
        return null;
    }

    private SortedMap<Float, CmsWorkplaceEditorConfiguration> filterEditorsForResourceType(String resourceType) {
        TreeMap<Float, CmsWorkplaceEditorConfiguration> filteredEditors = new TreeMap<Float, CmsWorkplaceEditorConfiguration>();
        for (CmsWorkplaceEditorConfiguration currentConfig : this.m_editorConfigurations) {
            float key;
            if (!currentConfig.matchesResourceType(resourceType) || !((key = currentConfig.getRankingForResourceType(resourceType)) >= 0.0f)) continue;
            filteredEditors.put(Float.valueOf(key), currentConfig);
        }
        return filteredEditors;
    }

    private CmsWorkplaceEditorConfiguration filterPreferredEditor(String preferredEditor) {
        if (this.m_preferredEditors.size() == 0) {
            for (CmsWorkplaceEditorConfiguration currentConfig : this.m_editorConfigurations) {
                this.m_preferredEditors.put(currentConfig.getEditorUri(), currentConfig);
            }
        }
        return this.m_preferredEditors.get(preferredEditor);
    }
}

