/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.galleries.Messages;

public class CmsOpenGallery
extends CmsDialog {
    public static final String DIALOG_TYPE = "opengallery";
    private static final Log LOG = CmsLog.getLog(CmsOpenGallery.class);

    public CmsOpenGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsOpenGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String openGallery() {
        StringBuffer jsOpener;
        block5: {
            jsOpener = new StringBuffer(32);
            String galleryType = null;
            try {
                CmsResource res = this.getCms().readResource(this.getParamResource());
                if (res == null) break block5;
                Object galleryPath = this.getParamResource();
                if (!((String)galleryPath).endsWith("/")) {
                    galleryPath = (String)galleryPath + "/";
                }
                galleryType = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
                StringBuffer galleryUri = new StringBuffer(256);
                galleryUri.append("/system/workplace/galleries/");
                String width = "650";
                String height = "700";
                galleryUri.append(galleryType);
                galleryUri.append("/index.jsp?");
                galleryUri.append("dialogmode");
                galleryUri.append("=");
                galleryUri.append("view");
                galleryUri.append("&");
                galleryUri.append("params");
                galleryUri.append("=");
                JSONObject jsonObj = new JSONObject();
                try {
                    jsonObj.putOpt("startupfolder", galleryPath);
                    jsonObj.putOpt("startuptype", "gallery");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                galleryUri.append(jsonObj.toString());
                jsOpener.append("window.open('");
                jsOpener.append(this.getJsp().link(galleryUri.toString()));
                jsOpener.append("', '");
                jsOpener.append(galleryType);
                jsOpener.append("','width=");
                jsOpener.append(width);
                jsOpener.append(", height=");
                jsOpener.append(height);
                jsOpener.append(", resizable=yes, top=100, left=270, status=yes');");
            }
            catch (CmsException e) {
                CmsMessageContainer message = Messages.get().container("ERR_OPEN_GALLERY_1", galleryType);
                LOG.error((Object)message.key(), (Throwable)e);
                throw new CmsRuntimeException(message, (Throwable)e);
            }
        }
        return jsOpener.toString();
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
    }
}

