/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.threads.Messages;

public class CmsDatabaseImportThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsDatabaseImportThread.class);
    private String m_importFile;
    private boolean m_keepPermissions;

    public CmsDatabaseImportThread(CmsObject cms, String importFile, boolean keepPermissions) {
        super(cms, Messages.get().getBundle().key("GUI_DB_IMPORT_THREAD_NAME_1", importFile));
        this.m_importFile = importFile;
        this.m_keepPermissions = keepPermissions;
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CmsImportParameters parameters = new CmsImportParameters(this.m_importFile, "/", this.m_keepPermissions);
        CmsUUID pauseId = OpenCms.getSearchManager().pauseOfflineIndexing();
        try {
            OpenCms.getImportExportManager().importData(this.getCms(), this.getReport(), parameters);
        }
        catch (Throwable e) {
            this.getReport().println(e);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_DB_IMPORT_0"), e);
            }
        }
        finally {
            OpenCms.getSearchManager().resumeOfflineIndexing(pauseId);
        }
    }
}

