/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.Messages;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentTypeManager {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentTypeManager.class);
    private Map<String, I_CmsXmlContentHandler> m_contentHandlers;
    private Map<String, I_CmsWidget> m_defaultWidgets;
    private Map<String, I_CmsXmlSchemaType> m_registeredTypes = new HashMap<String, I_CmsXmlSchemaType>();
    private Map<String, I_CmsWidget> m_registeredWidgets;
    private Map<String, String> m_widgetAliases;
    private Map<String, String> m_widgetDefaultConfigurations;

    public CmsXmlContentTypeManager() {
        this.m_defaultWidgets = new HashMap<String, I_CmsWidget>();
        this.m_registeredWidgets = new LinkedHashMap<String, I_CmsWidget>();
        this.m_widgetAliases = new LinkedHashMap<String, String>();
        this.m_widgetDefaultConfigurations = new HashMap<String, String>();
        FastHashMap fastMap = new FastHashMap();
        fastMap.setFast(true);
        this.m_contentHandlers = fastMap;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_CONTENT_CONFIG_0"));
        }
    }

    public static CmsXmlContentTypeManager createTypeManagerForTestCases() {
        CmsXmlContentTypeManager typeManager = new CmsXmlContentTypeManager();
        typeManager.addWidget("org.opencms.widgets.CmsCalendarWidget", null, null);
        typeManager.addWidget("org.opencms.widgets.CmsHtmlWidget", null, null);
        typeManager.addWidget("org.opencms.widgets.CmsInputWidget", null, null);
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlDateTimeValue", "org.opencms.widgets.CmsCalendarWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlHtmlValue", "org.opencms.widgets.CmsHtmlWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlLocaleValue", "org.opencms.widgets.CmsInputWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlStringValue", "org.opencms.widgets.CmsInputWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlPlainTextStringValue", "org.opencms.widgets.CmsInputWidget");
        try {
            typeManager.initialize(null);
        }
        catch (CmsRoleViolationException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_INIT_TYPE_MANAGER_0"));
        }
        return typeManager;
    }

    public I_CmsXmlSchemaType addContentType(Class<?> clazz) throws CmsXmlException {
        I_CmsXmlSchemaType type;
        try {
            type = (I_CmsXmlSchemaType)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_XCC_TYPE_REGISTERED_0"));
        }
        catch (IllegalAccessException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_XCC_TYPE_REGISTERED_0"));
        }
        catch (ClassCastException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_XCC_TYPE_REGISTERED_0"));
        }
        this.m_registeredTypes.put(type.getTypeName(), type);
        return type;
    }

    public void addSchemaType(String className, String defaultWidget) {
        I_CmsXmlSchemaType type;
        Class<?> classClazz;
        try {
            classClazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_XML_CONTENT_SCHEMA_TYPE_CLASS_NOT_FOUND_1", className), (Throwable)e);
            return;
        }
        try {
            type = this.addContentType(classClazz);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_XML_CONTENT_SCHEMA_TYPE_CLASS_ERROR_1", classClazz.getName()), (Throwable)e);
            return;
        }
        I_CmsWidget widget = this.getWidget(defaultWidget);
        if (widget == null) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_DEFAULT_WIDGET_FOR_CONTENT_TYPE_2", defaultWidget, type.getTypeName()));
            return;
        }
        this.m_defaultWidgets.put(type.getTypeName(), widget);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_ST_USING_WIDGET_2", type.getTypeName(), widget.getClass().getName()));
        }
    }

    public void addWidget(String className, List<String> aliases, String defaultConfiguration) {
        I_CmsWidget widget;
        Class<?> widgetClazz;
        if (aliases == null) {
            aliases = Collections.emptyList();
        }
        try {
            widgetClazz = Class.forName(className);
            widget = (I_CmsWidget)widgetClazz.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_XML_WIDGET_INITIALIZING_ERROR_1", className), (Throwable)e);
            return;
        }
        this.m_registeredWidgets.put(widgetClazz.getName(), widget);
        for (String alias : aliases) {
            String prev = this.m_widgetAliases.get(alias);
            if (prev != null) {
                LOG.warn((Object)("Duplicate widget alias " + alias + " for " + prev + ", " + widgetClazz.getName()));
            }
            this.m_widgetAliases.put(alias, widgetClazz.getName());
        }
        if (CmsStringUtil.isNotEmpty(defaultConfiguration)) {
            this.m_widgetDefaultConfigurations.put(className, defaultConfiguration);
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            if (CmsStringUtil.isEmpty(defaultConfiguration)) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_WIDGET_1", widgetClazz.getName()));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_WIDGET_CONFIG_2", widgetClazz.getName(), defaultConfiguration));
            }
        }
    }

    public I_CmsXmlContentHandler getContentHandler(String className, String schemaLocation) throws CmsXmlException {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(schemaLocation);
        buffer.append('#');
        buffer.append(className);
        String key = buffer.toString();
        I_CmsXmlContentHandler contentHandler = this.m_contentHandlers.get(key);
        if (contentHandler != null) {
            return contentHandler;
        }
        try {
            contentHandler = (I_CmsXmlContentHandler)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        catch (IllegalAccessException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        catch (ClassCastException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        catch (ClassNotFoundException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        this.m_contentHandlers.put(key, contentHandler);
        return contentHandler;
    }

    public I_CmsXmlSchemaType getContentType(Element typeElement, Set<CmsXmlContentDefinition> nestedDefinitions) throws CmsXmlException {
        if (!CmsXmlContentDefinition.XSD_NODE_ELEMENT.equals((Object)typeElement.getQName())) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CD_SCHEMA_STRUCTURE_0"));
        }
        if (typeElement.elements().size() > 0) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CD_SCHEMA_STRUCTURE_0"));
        }
        String elementName = typeElement.attributeValue("name");
        String typeName = typeElement.attributeValue("type");
        String defaultValue = typeElement.attributeValue("default");
        String maxOccrs = typeElement.attributeValue("maxOccurs");
        String minOccrs = typeElement.attributeValue("minOccurs");
        if (CmsStringUtil.isEmpty(elementName)) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_MISSING_ATTRIBUTE_2", typeElement.getName(), "name"));
        }
        if (CmsStringUtil.isEmpty(typeName)) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_MISSING_ATTRIBUTE_2", typeElement.getName(), "type"));
        }
        boolean simpleType = true;
        I_CmsXmlSchemaType schemaType = this.m_registeredTypes.get(typeName);
        if (schemaType == null) {
            for (CmsXmlContentDefinition cd : nestedDefinitions) {
                if (!typeName.equals(cd.getTypeName())) continue;
                simpleType = false;
                return new CmsXmlNestedContentDefinition(cd, elementName, minOccrs, maxOccrs);
            }
            if (simpleType) {
                throw new CmsXmlException(Messages.get().container("ERR_UNKNOWN_SCHEMA_1", typeName));
            }
        }
        if (simpleType && schemaType != null) {
            schemaType = schemaType.newInstance(elementName, minOccrs, maxOccrs);
            if (CmsStringUtil.isNotEmpty(defaultValue)) {
                schemaType.setDefault(defaultValue);
            }
        }
        return schemaType;
    }

    public I_CmsXmlSchemaType getContentType(String typeName) {
        return this.m_registeredTypes.get(typeName);
    }

    public I_CmsXmlContentHandler getFreshContentHandler(String className) throws CmsXmlException {
        I_CmsXmlContentHandler contentHandler;
        try {
            contentHandler = (I_CmsXmlContentHandler)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", className));
        }
        catch (IllegalAccessException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", className));
        }
        catch (ClassCastException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", className));
        }
        catch (ClassNotFoundException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", className));
        }
        return contentHandler;
    }

    public List<I_CmsXmlSchemaType> getRegisteredSchemaTypes() {
        ArrayList<I_CmsXmlSchemaType> result = new ArrayList<I_CmsXmlSchemaType>(this.m_registeredTypes.values());
        Collections.sort(result);
        return result;
    }

    public List<String> getRegisteredWidgetAliases(String className) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.m_widgetAliases.entrySet()) {
            if (!e.getValue().equals(className)) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public List<String> getRegisteredWidgetNames() {
        ArrayList<String> result = new ArrayList<String>(this.m_registeredWidgets.keySet());
        return result;
    }

    public I_CmsWidget getWidget(String name) {
        String className;
        I_CmsWidget result = this.m_registeredWidgets.get(name);
        if (result == null && (className = this.m_widgetAliases.get(name)) != null) {
            result = this.m_registeredWidgets.get(className);
        }
        if (result != null) {
            result = result.newInstance();
        }
        return result;
    }

    public I_CmsWidget getWidgetDefault(String typeName) {
        I_CmsWidget result = this.m_defaultWidgets.get(typeName);
        if (result != null) {
            result = result.newInstance();
        }
        return result;
    }

    public String getWidgetDefaultConfiguration(I_CmsWidget widget) {
        return this.m_widgetDefaultConfigurations.get(widget.getClass().getName());
    }

    public String getWidgetDefaultConfiguration(String name) {
        if (this.m_registeredWidgets.containsKey(name)) {
            return this.m_widgetDefaultConfigurations.get(name);
        }
        String className = this.m_widgetAliases.get(name);
        if (className != null) {
            return this.m_widgetDefaultConfigurations.get(className);
        }
        return null;
    }

    public synchronized void initialize(CmsObject cms) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        }
        CmsXmlEntityResolver.initialize(cms, this.getSchemaBytes());
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_ST_INITIALIZED_1", this.m_registeredTypes.size()));
        }
    }

    private byte[] getSchemaBytes() {
        StringBuffer schema = new StringBuffer(512);
        schema.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        schema.append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">");
        for (I_CmsXmlSchemaType type : this.m_registeredTypes.values()) {
            schema.append(type.getSchemaDefinition());
        }
        schema.append("</xsd:schema>");
        String schemaStr = schema.toString();
        try {
            Document doc = CmsXmlUtils.unmarshalHelper(schemaStr, null);
            schemaStr = CmsXmlUtils.marshal(doc, "UTF-8");
        }
        catch (CmsXmlException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PRETTY_PRINT_SCHEMA_BYTES_ERROR_0"), (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_XML_TYPE_DEFINITION_XSD_2", "opencms://opencms-xmlcontent.xsd", schemaStr));
        }
        try {
            return schemaStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CONVERTING_SCHEMA_BYTES_ERROR_0"), (Throwable)e);
            return null;
        }
    }
}

