/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsNullIgnoringConcurrentMap;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsContainerElementBean
implements Cloneable {
    private boolean m_doNotCache;
    private final boolean m_createNew;
    private transient String m_editorHash;
    private CmsUUID m_elementId;
    private CmsUUID m_formatterId;
    private Map<String, String> m_individualSettings;
    private CmsInheritanceInfo m_inheritanceInfo;
    private boolean m_inMemoryOnly;
    private boolean m_isHistory;
    private boolean m_releasedAndNotExpired;
    private transient CmsResource m_resource;
    private transient Map<String, String> m_settings;
    private String m_sitePath;
    private boolean m_temporaryContent;

    public CmsContainerElementBean(CmsFile file, CmsUUID formatterId, Map<String, String> individualSettings, boolean inMemoryOnly, String editorHash, boolean createNew) {
        this(file.getStructureId(), formatterId, individualSettings, createNew);
        this.m_inMemoryOnly = inMemoryOnly;
        this.m_editorHash = editorHash;
        this.m_resource = file;
    }

    public CmsContainerElementBean(CmsUUID elementId, CmsUUID formatterId, Map<String, String> individualSettings, boolean createNew) {
        HashMap<String, String> newSettings;
        this.m_elementId = elementId;
        this.m_formatterId = formatterId;
        HashMap<String, String> hashMap = newSettings = individualSettings == null ? new HashMap<String, String>() : new HashMap<String, String>(individualSettings);
        if (!newSettings.containsKey("element_instance_id")) {
            newSettings.put("element_instance_id", new CmsUUID().toString());
        }
        newSettings.values().removeAll(Collections.singletonList(null));
        this.m_individualSettings = Collections.unmodifiableMap(newSettings);
        this.m_editorHash = this.m_elementId.toString() + this.getSettingsHash();
        this.m_createNew = createNew;
    }

    protected CmsContainerElementBean() {
        this.m_elementId = null;
        this.m_createNew = false;
    }

    private CmsContainerElementBean(boolean createNew, CmsUUID elementId, CmsUUID formatterId, Map<String, String> individualSettings, CmsInheritanceInfo inheritanceInfo, boolean inMemoryOnly, boolean temporaryContent, boolean releasedAndNotExpired, CmsResource resource, Map<String, String> settings, String sitePath) {
        this.m_createNew = createNew;
        this.m_elementId = elementId;
        this.m_formatterId = formatterId;
        this.m_individualSettings = Collections.unmodifiableMap(individualSettings);
        this.m_inheritanceInfo = inheritanceInfo;
        this.m_inMemoryOnly = inMemoryOnly;
        this.m_releasedAndNotExpired = releasedAndNotExpired;
        this.m_resource = resource;
        this.setSettings(settings);
        this.m_sitePath = sitePath;
        this.m_temporaryContent = temporaryContent;
    }

    public static CmsContainerElementBean cloneWithFormatter(CmsContainerElementBean source, CmsUUID formatterId) {
        CmsContainerElementBean result = source.clone();
        result.m_formatterId = formatterId;
        return result;
    }

    public static CmsContainerElementBean cloneWithSettings(CmsContainerElementBean source, Map<String, String> settings) {
        boolean createNew = source.m_createNew;
        if (settings.containsKey("create_as_new")) {
            createNew = Boolean.valueOf(settings.get("create_as_new"));
            settings = new HashMap<String, String>(settings);
            settings.remove("create_as_new");
        }
        CmsContainerElementBean result = new CmsContainerElementBean(source.m_elementId, source.m_formatterId, settings, createNew);
        result.m_resource = source.m_resource;
        result.m_sitePath = source.m_sitePath;
        result.m_inMemoryOnly = source.m_inMemoryOnly;
        result.m_inheritanceInfo = source.m_inheritanceInfo;
        if (result.m_inMemoryOnly) {
            Object editorHash = source.m_editorHash;
            if (((String)editorHash).contains("#")) {
                editorHash = ((String)editorHash).substring(0, ((String)editorHash).indexOf("#"));
            }
            result.m_editorHash = editorHash = (String)editorHash + result.getSettingsHash();
        }
        return result;
    }

    public static CmsContainerElementBean createElementForResourceType(CmsObject cms, I_CmsResourceType resourceType, String targetFolder, Map<String, String> individualSettings, boolean isCopyModels, Locale locale) throws CmsException {
        if (!(resourceType instanceof CmsResourceTypeXmlContent)) {
            throw new IllegalArgumentException();
        }
        byte[] content = new byte[]{};
        String schema = ((CmsResourceTypeXmlContent)resourceType).getSchema();
        if (schema != null) {
            CmsObject newCms = OpenCms.initCmsObject(cms);
            newCms.getRequestContext().setUri(targetFolder);
            CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
            CmsXmlContent xmlContent = CmsXmlContentFactory.createDocument(newCms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
            for (Locale otherLocale : OpenCms.getLocaleManager().getAvailableLocales()) {
                if (locale.equals(otherLocale)) continue;
                xmlContent.addLocale(newCms, otherLocale);
            }
            content = xmlContent.marshal();
        }
        CmsFile file = new CmsFile(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), targetFolder + "~", resourceType.getTypeId(), 0, cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, 0L, cms.getRequestContext().getCurrentUser().getId(), 0L, cms.getRequestContext().getCurrentUser().getId(), 0L, Long.MAX_VALUE, 1, content.length, 0L, 0, content);
        CmsContainerElementBean elementBean = new CmsContainerElementBean(file, null, individualSettings, true, resourceType.getTypeName() + CmsContainerElementBean.getSettingsHash(individualSettings, isCopyModels), isCopyModels);
        return elementBean;
    }

    private static String getSettingsHash(Map<String, String> individualSettings, boolean createNew) {
        if (!individualSettings.isEmpty() || createNew) {
            int hash = (individualSettings.toString() + createNew).hashCode();
            return "#" + hash;
        }
        return "";
    }

    public void addFormatterSetting(String containerName, String formatterId) {
        HashMap<String, String> newSettings = new HashMap<String, String>(this.m_individualSettings);
        newSettings.put(CmsFormatterConfig.getSettingsKeyForContainer(containerName), formatterId);
        this.m_individualSettings = Collections.unmodifiableMap(newSettings);
        if (this.m_inMemoryOnly) {
            Object editorHash = this.m_editorHash;
            if (((String)editorHash).contains("#")) {
                editorHash = ((String)editorHash).substring(0, ((String)editorHash).indexOf("#"));
            }
            this.m_editorHash = editorHash = (String)editorHash + this.getSettingsHash();
        } else {
            this.m_editorHash = this.m_elementId.toString() + this.getSettingsHash();
        }
    }

    public CmsContainerElementBean clone() {
        return new CmsContainerElementBean(this.m_createNew, this.m_elementId, this.m_formatterId, this.m_individualSettings, this.m_inheritanceInfo, this.m_inMemoryOnly, this.m_temporaryContent, this.m_releasedAndNotExpired, this.m_resource, this.m_settings, this.m_sitePath);
    }

    public String editorHash() {
        if (this.m_editorHash == null) {
            this.m_editorHash = this.m_elementId.toString() + this.getSettingsHash();
        }
        return this.m_editorHash;
    }

    public void ensureNewInstanceId() {
        HashMap<String, String> newSettings = new HashMap<String, String>(this.m_individualSettings);
        newSettings.put("element_instance_id", new CmsUUID().toString());
        this.m_individualSettings = Collections.unmodifiableMap(newSettings);
        this.m_editorHash = this.m_elementId.toString() + this.getSettingsHash();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsContainerElementBean)) {
            return false;
        }
        return this.editorHash().equals(((CmsContainerElementBean)obj).editorHash());
    }

    public CmsUUID getFormatterId() {
        return this.m_formatterId;
    }

    public CmsUUID getId() {
        return this.m_elementId;
    }

    public Map<String, String> getIndividualSettings() {
        return this.m_individualSettings;
    }

    public CmsInheritanceInfo getInheritanceInfo() {
        return this.m_inheritanceInfo;
    }

    public String getInstanceId() {
        return this.getIndividualSettings().get("element_instance_id");
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public Map<String, String> getSettings() {
        return this.m_settings;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public String getTypeName() {
        if (this.getResource() != null) {
            return OpenCms.getResourceManager().getResourceType(this.getResource()).getTypeName();
        }
        return "unknown";
    }

    public int hashCode() {
        return this.m_editorHash.hashCode();
    }

    public void initResource(CmsObject cms) throws CmsException {
        if (this.m_resource == null) {
            this.m_resource = cms.readResource(this.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_releasedAndNotExpired = this.m_resource.isReleasedAndNotExpired(cms.getRequestContext().getRequestTime());
        } else if (!this.isInMemoryOnly()) {
            CmsUUID id = this.m_resource.getStructureId();
            if (id == null) {
                id = this.getId();
            }
            if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                this.m_resource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
                this.m_releasedAndNotExpired = this.m_resource.isReleasedAndNotExpired(cms.getRequestContext().getRequestTime());
            } else {
                if (!this.isTemporaryContent()) {
                    this.m_resource = cms.readResource(this.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                }
                this.m_releasedAndNotExpired = this.m_resource.isReleasedAndNotExpired(cms.getRequestContext().getRequestTime());
            }
        }
        if (this.m_settings == null) {
            this.setSettings(new HashMap<String, String>(this.getIndividualSettings()));
        }
        this.m_sitePath = cms.getSitePath(this.m_resource);
    }

    public void initSettings(CmsObject cms, CmsADEConfigData config, I_CmsFormatterBean formatterBean, Locale locale, ServletRequest request, Map<String, String> presets) {
        Map<String, String> mergedSettings = formatterBean == null ? CmsXmlContentPropertyHelper.mergeDefaults(cms, config, this.m_resource, this.getIndividualSettings(), locale, request) : CmsXmlContentPropertyHelper.mergeDefaults(cms, OpenCms.getADEManager().getFormatterSettings(cms, config, formatterBean, this.getResource(), locale, request), this.getIndividualSettings());
        if (presets != null && presets.size() > 0) {
            mergedSettings.putAll(presets);
        }
        if (this.m_settings == null) {
            this.setSettings(mergedSettings);
        } else {
            this.m_settings.putAll(mergedSettings);
        }
    }

    public boolean isCopyModel() {
        return Boolean.valueOf(this.getIndividualSettings().get("use_as_copy_model"));
    }

    public boolean isCreateNew() {
        return this.m_createNew;
    }

    public boolean isDoNotCache() {
        return this.m_doNotCache;
    }

    public boolean isGroupContainer(CmsObject cms) throws CmsException {
        if (this.m_resource == null) {
            this.initResource(cms);
        }
        return "groupcontainer".equals(OpenCms.getResourceManager().getResourceType(this.m_resource).getTypeName());
    }

    public boolean isHistoryContent() {
        return this.m_isHistory;
    }

    public boolean isInheritedContainer(CmsObject cms) throws CmsException {
        if (this.m_resource == null) {
            this.initResource(cms);
        }
        return OpenCms.getResourceManager().getResourceType("inheritance_group").getTypeId() == this.m_resource.getTypeId();
    }

    public boolean isInMemoryOnly() {
        return this.m_inMemoryOnly;
    }

    public boolean isModelGroup() {
        CmsContainerElement.ModelGroupState state = CmsContainerElement.ModelGroupState.evaluate(this.getIndividualSettings().get("model_group_state"));
        return state == CmsContainerElement.ModelGroupState.isModelGroup;
    }

    public boolean isModelGroupAlwaysReplace() {
        return Boolean.parseBoolean(this.getIndividualSettings().get("is_model_group_always_replace"));
    }

    public boolean isReleasedAndNotExpired() {
        return this.isInMemoryOnly() || this.m_releasedAndNotExpired;
    }

    public boolean isTemporaryContent() {
        return this.m_temporaryContent;
    }

    public void setDoNotCache(boolean doNotCache) {
        this.m_doNotCache = doNotCache;
    }

    public void setFormatterId(CmsUUID formatterId) {
        this.m_formatterId = formatterId;
    }

    public void setHistoryFile(CmsFile file) {
        this.m_resource = file;
        this.m_inMemoryOnly = true;
        this.m_isHistory = true;
    }

    public void setInheritanceInfo(CmsInheritanceInfo inheritanceInfo) {
        this.m_inheritanceInfo = inheritanceInfo;
    }

    public void setTemporaryFile(CmsFile elementFile) {
        this.m_resource = elementFile;
        this.m_temporaryContent = true;
    }

    public String toString() {
        return this.editorHash();
    }

    public void updateIndividualSettings(Map<String, String> newSettings) {
        this.m_individualSettings = Collections.unmodifiableMap(newSettings);
        this.setSettings(this.getIndividualSettings());
    }

    private String getSettingsHash() {
        String instanceId = this.getInstanceId();
        if (instanceId == null) {
            throw new RuntimeException("Missing instance id");
        }
        return "#" + this.getInstanceId() + "_" + this.getIndividualSettings().get("SYSTEM::pageId");
    }

    private void setSettings(Map<String, String> settings) {
        this.m_settings = settings == null ? null : new CmsNullIgnoringConcurrentMap<String, String>(settings);
    }
}

