/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage.mutable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsMutableContainer {
    private List<CmsContainerElementBean> m_elements = new ArrayList<CmsContainerElementBean>();
    private String m_name;
    private String m_type;
    private String m_parentInstanceId;
    private boolean m_isRootContainer;

    public CmsMutableContainer(String name, String type, String parentInstanceId, boolean isRootContainer, List<CmsContainerElementBean> elements) {
        this.m_name = name;
        this.m_type = type;
        this.m_parentInstanceId = parentInstanceId;
        this.m_isRootContainer = isRootContainer;
        this.m_elements = elements.stream().map(elem -> elem.clone()).collect(Collectors.toList());
    }

    public static CmsMutableContainer fromImmutable(CmsContainerBean container) {
        return new CmsMutableContainer(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), container.getElements());
    }

    public List<CmsContainerElementBean> elements() {
        return this.m_elements;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParentInstanceId() {
        return this.m_parentInstanceId;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isRootContainer() {
        return this.m_isRootContainer;
    }

    public boolean matches(String name) {
        return this.m_name.equals(name) || this.m_name.endsWith("-" + name);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setParentInstanceId(String parentInstanceId) {
        this.m_parentInstanceId = parentInstanceId;
    }

    public void setRootContainer(boolean isRootContainer) {
        this.m_isRootContainer = isRootContainer;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public CmsContainerBean toImmutable() {
        return new CmsContainerBean(this.m_name, this.m_type, this.m_parentInstanceId, this.m_isRootContainer, new ArrayList<CmsContainerElementBean>(this.m_elements));
    }
}

