/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletRequest;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.commons.logging.Log;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.ade.contenteditor.CmsAccessRestrictionInfo;
import org.opencms.ade.contenteditor.CmsWidgetUtil;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsListResourceBundle;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.jsp.util.CmsKeyDummyMacroResolver;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.CmsStaticResourceHandler;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.search.fields.CmsGeoCoordinateFieldMapping;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsDefaultSet;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsCategoryWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsComplexWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.CmsXmlContentWidgetVisitor;
import org.opencms.workplace.editors.directedit.I_CmsEditHandler;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsSchemaFormatterBeanWrapper;
import org.opencms.xml.content.CmsChangeHandlerConfig;
import org.opencms.xml.content.CmsGeoMappingConfiguration;
import org.opencms.xml.content.CmsMappingResolutionContext;
import org.opencms.xml.content.CmsSynchronizationSpec;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.I_CmsXmlContentEditorChangeHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.content.I_CmsXmlContentVisibilityHandler;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlAccessRestrictionValue;
import org.opencms.xml.types.CmsXmlCategoryValue;
import org.opencms.xml.types.CmsXmlDisplayFormatterValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlStringValue;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.opencms.xml.types.I_CmsXmlValidateWithMessage;

public class CmsDefaultXmlContentHandler
implements I_CmsXmlContentHandler,
I_CmsXmlContentVisibilityHandler {
    public static final String A_CONFIGURATION = "configuration";
    public static final String APPINFO_APPINFO = "appinfo";
    public static final String APPINFO_ATTR_ADD_TO = "addto";
    public static final String APPINFO_ATTR_BOOST = "boost";
    public static final String APPINFO_ATTR_CLASS = "class";
    public static final String APPINFO_ATTR_COLLAPSE = "collapse";
    public static final String APPINFO_ATTR_CONFIGURATION = "configuration";
    public static final String APPINFO_ATTR_CONTAINER_PAGE_ONLY = "containerPageOnly";
    public static final String APPINFO_ATTR_COPY_FIELDS = "copyfields";
    public static final String APPINFO_ATTR_DEFAULT = "default";
    public static final String APPINFO_ATTR_DESCRIPTION = "description";
    public static final String APPINFO_ATTR_DISPLAY = "display";
    public static final String APPINFO_ATTR_ELEMENT = "element";
    public static final String APPINFO_ATTR_ERROR = "error";
    public static final String APPINFO_ATTR_INVALIDATE = "invalidate";
    public static final String APPINFO_ATTR_KEY = "key";
    public static final String APPINFO_ATTR_LOCALE = "locale";
    public static final String APPINFO_ATTR_MAPPING = "mapping";
    public static final String APPINFO_ATTR_MAPTO = "mapto";
    public static final String APPINFO_ATTR_MAXWIDTH = "maxwidth";
    public static final String APPINFO_ATTR_MESSAGE = "message";
    public static final String APPINFO_ATTR_MINWIDTH = "minwidth";
    public static final String APPINFO_ATTR_NAME = "name";
    public static final String APPINFO_ATTR_NICE_NAME = "nice-name";
    public static final String APPINFO_ATTR_PARAMS = "params";
    public static final String APPINFO_ATTR_PREVIEW = "preview";
    public static final String APPINFO_ATTR_REGEX = "regex";
    public static final String APPINFO_ATTR_RESOLVE_MACROS = "resolveMacros";
    public static final String APPINFO_ATTR_RULE_REGEX = "rule-regex";
    public static final String APPINFO_ATTR_RULE_TYPE = "rule-type";
    public static final String APPINFO_ATTR_SCOPE = "scope";
    public static final String APPINFO_ATTR_SEARCHCONTENT = "searchcontent";
    public static final String APPINFO_ATTR_SELECT_INHERIT = "select-inherit";
    public static final String APPINFO_ATTR_SOURCE_FIELD = "sourcefield";
    public static final String APPINFO_ATTR_TARGET_FIELD = "targetfield";
    public static final String APPINFO_ATTR_TYPE = "type";
    public static final String APPINFO_ATTR_TYPE_NODE = "node";
    public static final String APPINFO_ATTR_TYPE_PARENT = "parent";
    public static final String APPINFO_ATTR_TYPE_WARNING = "warning";
    public static final String APPINFO_ATTR_URI = "uri";
    public static final String APPINFO_ATTR_USEALL = "useall";
    public static final String APPINFO_ATTR_VALUE = "value";
    public static final String APPINFO_ATTR_WIDGET = "widget";
    public static final String APPINFO_ATTR_WIDGET_CONFIG = "widget-config";
    public static final String APPINFO_ATTRIBUTE_TYPE_CSS = "css";
    public static final String APPINFO_ATTRIBUTE_TYPE_JAVASCRIPT = "javascript";
    public static final String APPINFO_BUNDLE = "bundle";
    public static final String APPINFO_DEFAULT = "default";
    public static final String APPINFO_DEFAULTS = "defaults";
    public static final String APPINFO_EDIT_HANDLER = "edithandler";
    public static final String APPINFO_EDITOR_CHANGE_HANDLER = "editorchangehandler";
    public static final String APPINFO_EDITOR_CHANGE_HANDLERS = "editorchangehandlers";
    public static final String APPINFO_FORBIDDEN_CONTEXTS = "forbidden-contexts";
    public static final String APPINFO_FORMATTER = "formatter";
    public static final String APPINFO_FORMATTERS = "formatters";
    public static final String APPINFO_GEOMAPPING = "geomapping";
    public static final String APPINFO_HEAD_INCLUDE = "headinclude";
    public static final String APPINFO_HEAD_INCLUDES = "headincludes";
    public static final String APPINFO_LAYOUT = "layout";
    public static final String APPINFO_LAYOUTS = "layouts";
    public static final String APPINFO_MAPPING = "mapping";
    public static final String APPINFO_MAPPINGS = "mappings";
    public static final String APPINFO_MESSAGEKEYHANDLER = "messagekeyhandler";
    public static final String APPINFO_MODELFOLDER = "modelfolder";
    public static final String APPINFO_NESTED_FORMATTER = "nestedformatter";
    public static final String APPINFO_NESTED_FORMATTERS = "nestedformatters";
    public static final String APPINFO_PARAM = "param";
    public static final String APPINFO_PARAMETERS = "parameters";
    public static final String APPINFO_PREVIEW = "preview";
    public static final String APPINFO_PROPERTYBUNDLE = "propertybundle";
    public static final String APPINFO_RELATION = "relation";
    public static final String APPINFO_RELATIONS = "relations";
    public static final String APPINFO_RESOURCE = "resource";
    public static final String APPINFO_RESOURCEBUNDLE = "resourcebundle";
    public static final String APPINFO_RESOURCEBUNDLES = "resourcebundles";
    public static final String APPINFO_REVERSE_MAPPING_ENABLED = "reverse-mapping-enabled";
    public static final String APPINFO_RULE = "rule";
    public static final String APPINFO_SCHEMA_FILE = "org/opencms/xml/content/DefaultAppinfo.xsd";
    public static final String APPINFO_SCHEMA_FILE_TYPES = "org/opencms/xml/content/DefaultAppinfoTypes.xsd";
    public static final String APPINFO_SCHEMA_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/org/opencms/xml/content/DefaultAppinfo.xsd";
    public static final String APPINFO_SCHEMA_TYPES_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/org/opencms/xml/content/DefaultAppinfoTypes.xsd";
    public static final String APPINFO_SEARCHSETTING = "searchsetting";
    public static final String APPINFO_SEARCHSETTINGS = "searchsettings";
    public static final String APPINFO_SETTING = "setting";
    public static final String APPINFO_SETTINGS = "settings";
    public static final String APPINFO_SOLR_FIELD = "solrfield";
    public static final String APPINFO_SYNCHRONIZATION = "synchronization";
    public static final String APPINFO_SYNCHRONIZATIONS = "synchronizations";
    public static final String APPINFO_TAB = "tab";
    public static final String APPINFO_TABS = "tabs";
    public static final String APPINFO_TEMPLATE = "template";
    public static final String APPINFO_TEMPLATES = "templates";
    public static final String APPINFO_VALIDATIONRULE = "validationrule";
    public static final String APPINFO_VALIDATIONRULES = "validationrules";
    public static final String APPINFO_VALUE_ADD_TO_CONTENT = "element";
    public static final String APPINFO_VALUE_ADD_TO_PAGE = "page";
    public static final String APPINFO_VERSION_TRANSFORMATION = "versiontransformation";
    public static final String APPINFO_VISIBILITIES = "visibilities";
    public static final String APPINFO_VISIBILITY = "visibility";
    public static final String APPINFO_XMLBUNDLE = "xmlbundle";
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_ENABLED_BY_DEFAULT = "enabledByDefault";
    public static final String ATTR_USE_ACACIA = "useAcacia";
    public static final String ATTRIBUTE_INCLUDE_TYPE_CSS = "css";
    public static final String ATTRIBUTE_INCLUDE_TYPE_JAVASCRIPT = "javascript";
    public static final String GEOMAPPING_FIELD = "geocoords_loc";
    public static final String MACRO_PREVIEW_TEMPFILE = "previewtempfile";
    public static final String N_CHANGEHANDLER = "ChangeHandler";
    public static final String N_SETTING = "Setting";
    protected static final String MESSAGE_VALIDATION_DEFAULT_ERROR = "${validation.path}: ${key.GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_2|${validation.value}|[${validation.regex}]}";
    protected static final String MESSAGE_VALIDATION_DEFAULT_WARNING = "${validation.path}: ${key.GUI_EDITOR_XMLCONTENT_VALIDATION_WARNING_2|${validation.value}|[${validation.regex}]}";
    static Set<String> indexesNotSetOrOne;
    private static final String APPINFO_ATTR_PREFERFOLDER = "PreferFolder";
    private static final String APPINFO_ATTR_USE_DEFAULT = "useDefault";
    private static final Object APPINFO_DEFAULTWIDGET;
    private static final Object APPINFO_FIELD_SETTINGS;
    private static final Object APPINFO_JSON_RENDERER;
    private static final String ATTR_MAPPING_RESOLUTION_CONTEXT = "MAPPING_RESOLUTION_CONTEXT";
    private static final Log LOG;
    private static final String PRINCIPAL_LIST_SEPARATOR = ",";
    private static final String TITLE_PROPERTY_INDIVIDUAL_MAPPING = "property:individual:Title";
    private static final String TITLE_PROPERTY_MAPPING = "property:Title";
    private static final String TITLE_PROPERTY_SHARED_MAPPING = "property:shared:Title";
    protected CmsDefaultSet<String> m_allowedTemplates = new CmsDefaultSet();
    protected LinkedHashMap<String, I_CmsXmlContentHandler.SynchronizationMode> m_combinedSynchronizations;
    protected Map<String, String> m_configurationValues;
    protected Set<String> m_cssHeadIncludes;
    protected Map<String, String> m_defaultValues;
    protected Map<String, List<String>> m_elementMappings;
    protected CmsFormatterConfiguration m_formatterConfiguration;
    protected List<CmsFormatterBean> m_formatters;
    protected List<CmsGeoMappingConfiguration.Entry> m_geomappingEntries = new ArrayList<CmsGeoMappingConfiguration.Entry>();
    protected Map<String, InvalidRelationAction> m_invalidRelationActions = new HashMap<String, InvalidRelationAction>();
    protected Set<String> m_jsHeadIncludes;
    protected List<String> m_messageBundleNames;
    protected String m_modelFolder;
    protected String m_previewLocation;
    protected String m_primaryGeomappingField;
    protected Map<String, Boolean> m_relationChecks;
    protected Map<String, CmsRelationType> m_relations;
    protected Map<String, CmsSearchField> m_searchFields;
    protected Map<String, CmsSearchField> m_searchFieldsPage;
    protected Map<String, I_CmsXmlContentValue.SearchContentType> m_searchSettings;
    protected StringTemplateGroup m_searchTemplateGroup;
    protected Map<String, CmsXmlContentProperty> m_settings;
    protected LinkedHashMap<String, I_CmsXmlContentHandler.SynchronizationMode> m_synchronizations = new LinkedHashMap();
    protected List<CmsXmlContentTab> m_tabs;
    protected List<String> m_titleMappings;
    protected boolean m_useAcacia = true;
    protected Map<String, String> m_validationErrorMessages;
    protected Map<String, String> m_validationErrorRules;
    protected Map<String, String> m_validationWarningMessages;
    protected Map<String, String> m_validationWarningRules;
    protected String m_versionTransformation;
    private List<CmsChangeHandlerConfig> m_changeHandlerConfigs = new ArrayList<CmsChangeHandlerConfig>();
    private boolean m_containerPageOnly;
    private CmsXmlContentDefinition m_contentDefinition;
    private String m_defaultWidget;
    private String m_defaultWidgetConfig;
    private I_CmsComplexWidget m_defaultWidgetInstance;
    private HashMap<String, I_CmsXmlContentHandler.DisplayType> m_displayTypes;
    private I_CmsEditHandler m_editHandler;
    private List<I_CmsXmlContentEditorChangeHandler> m_editorChangeHandlers;
    private Map<String, String> m_fieldDescriptions = new HashMap<String, String>();
    private Map<String, String> m_fieldNiceNames = new HashMap<String, String>();
    private volatile Boolean m_hasCategoryWidget;
    private I_CmsXmlContentHandler.JsonRendererSettings m_jsonRendererSettings;
    private Set<String> m_mappingsUsingDefault = new HashSet<String>();
    private CmsMultiMessages.I_KeyFallbackHandler m_messageKeyHandler = new CmsMultiMessages.I_KeyFallbackHandler(){

        @Override
        public com.google.common.base.Optional<String> getFallbackKey(String key) {
            return com.google.common.base.Optional.absent();
        }
    };
    private Set<String> m_nestedFormatterElements;
    private Set<String> m_nonMacroResolvableDefaults = new HashSet<String>();
    private CmsParameterConfiguration m_parameters = new CmsParameterConfiguration();
    private boolean m_reverseMappingEnabled = true;
    private Map<String, VisibilityConfiguration> m_visibilityConfigurations = new HashMap<String, VisibilityConfiguration>();
    private Map<String, String> m_widgetNames = new HashMap<String, String>();

    public CmsDefaultXmlContentHandler() {
        this.init();
    }

    private static void collectNestedChangeHandlerConfigs(CmsXmlContentDefinition contentDef, String parentPath, Multimap<String, CmsChangeHandlerConfig> result) {
        I_CmsXmlContentHandler handler = contentDef.getContentHandler();
        List<CmsChangeHandlerConfig> handlerConfigs = handler.getChangeHandlerConfigs();
        for (CmsChangeHandlerConfig handlerConfig : handlerConfigs) {
            result.put((Object)parentPath, (Object)handlerConfig);
        }
        for (I_CmsXmlSchemaType schemaType : contentDef.getTypeSequence()) {
            String name = schemaType.getName();
            if (!(schemaType instanceof CmsXmlNestedContentDefinition)) continue;
            CmsXmlNestedContentDefinition nested = (CmsXmlNestedContentDefinition)schemaType;
            CmsDefaultXmlContentHandler.collectNestedChangeHandlerConfigs(nested.getNestedContentDefinition(), parentPath + "/" + name, result);
        }
    }

    private static InvalidRelationAction getInvalidRelationActionForValue(I_CmsXmlContentValue value) {
        try {
            String path = value.getPath();
            String simpleName = CmsXmlUtils.getLastXpathElement(path);
            return value.getContentDefinition().getContentHandler().getInvalidRelationAction(simpleName);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private static String normalizeChangeHandlerScope(String path) {
        ArrayList<String> normalizedKeyParts = new ArrayList<String>();
        for (String keyPart : path.split("/")) {
            Object normalizedKeyPart = null;
            normalizedKeyPart = keyPart.endsWith("*") || keyPart.endsWith("]") ? keyPart : keyPart + "*";
            normalizedKeyParts.add((String)normalizedKeyPart);
        }
        String normalizedKey = CmsStringUtil.listAsString(normalizedKeyParts, "/");
        return normalizedKey;
    }

    @Override
    public boolean applyReverseAvailabilityMapping(CmsObject cms, CmsXmlContent content, CmsMappingResolutionContext.AttributeType attr, List<Locale> resourceLocales, long valueToSet) {
        MappingInfo info = this.getAttributeMapping(attr);
        if (!info.canBeUsedForReverseAvailabilityMapping()) {
            return false;
        }
        long defaultValue = -1L;
        switch (attr) {
            case expiration: {
                defaultValue = Long.MAX_VALUE;
                break;
            }
            case release: {
                defaultValue = 0L;
                break;
            }
            default: {
                return false;
            }
        }
        String mappedElement = info.getSource();
        I_CmsXmlSchemaType type = this.m_contentDefinition.getSchemaType(mappedElement);
        List<Object> localesToProcess = Collections.emptyList();
        for (Locale locale : resourceLocales) {
            if (!content.hasLocale(locale)) continue;
            localesToProcess = Collections.singletonList(locale);
            break;
        }
        if (localesToProcess.size() > 0) {
            Locale locale = (Locale)localesToProcess.get(0);
            if (content.hasValue(mappedElement, locale)) {
                I_CmsXmlContentValue value = content.getValue(mappedElement, locale);
                String stringValue = value.getStringValue(cms);
                if (stringValue.contains("%")) {
                    LOG.debug((Object)(content.getFile().getRootPath() + ": Didn't apply reverse availability mapping because of macro value " + stringValue));
                    return false;
                }
                if (valueToSet == defaultValue) {
                    if (type.getMinOccurs() == 0) {
                        content.removeValue(mappedElement, locale, 0);
                    } else if (type instanceof CmsXmlStringValue) {
                        content.getValue(mappedElement, locale).setStringValue(cms, "");
                    } else {
                        LOG.warn((Object)(content.getFile().getRootPath() + ": Could not apply reverse availability mapping because the field " + mappedElement + " is neither optional nor of type OpenCmsString."));
                    }
                } else {
                    content.getValue(mappedElement, locale).setStringValue(cms, "" + valueToSet);
                }
            } else if (valueToSet != defaultValue) {
                HashSet<String> parentSet = new HashSet<String>();
                String currentPath = mappedElement;
                while (!parentSet.contains(currentPath)) {
                    parentSet.add(currentPath);
                    currentPath = CmsXmlUtils.removeLastXpathElement(currentPath);
                }
                ArrayList sortedParents = new ArrayList(parentSet);
                Collections.sort(sortedParents);
                for (String parent : sortedParents) {
                    if (content.hasValue(parent, locale)) continue;
                    content.addValue(cms, parent, locale, 0);
                }
                content.getValue(mappedElement, locale).setStringValue(cms, "" + valueToSet);
            }
        }
        return true;
    }

    @Override
    public boolean canUseReverseAvailabilityMapping(CmsMappingResolutionContext.AttributeType attr) {
        if (!this.m_reverseMappingEnabled) {
            return false;
        }
        MappingInfo info = this.getAttributeMapping(attr);
        return info.canBeUsedForReverseAvailabilityMapping();
    }

    public CmsObject createRootCms(CmsObject cms) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        Object logEntry = cms.getRequestContext().getAttribute("ATTR_LOG_ENTRY");
        if (logEntry != null) {
            rootCms.getRequestContext().setAttribute("ATTR_LOG_ENTRY", logEntry);
        }
        rootCms.getRequestContext().setSiteRoot("/");
        return rootCms;
    }

    @Override
    public CmsDefaultSet<String> getAllowedTemplates() {
        return this.m_allowedTemplates;
    }

    @Override
    public List<CmsChangeHandlerConfig> getChangeHandlerConfigs() {
        return Collections.unmodifiableList(this.m_changeHandlerConfigs);
    }

    @Override
    public I_CmsComplexWidget getComplexWidget(CmsObject cms, String path) {
        String widgetName = this.m_widgetNames.get(path);
        if (widgetName == null) {
            return null;
        }
        if (cms != null) {
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(cms);
            widgetName = resolver.resolveMacros(widgetName);
        }
        if (CmsStringUtil.isValidJavaClassName(widgetName)) {
            try {
                Class<?> cls = Class.forName(widgetName, false, this.getClass().getClassLoader());
                if (I_CmsComplexWidget.class.isAssignableFrom(cls)) {
                    return (I_CmsComplexWidget)cls.newInstance();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getConfiguration(I_CmsXmlSchemaType type) {
        String elementName = type.getName();
        return this.m_configurationValues.get(elementName);
    }

    @Override
    public String getConfiguration(String path) {
        return this.m_configurationValues.get(path);
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getConfiguredDisplayType(String path, I_CmsXmlContentHandler.DisplayType defaultValue) {
        I_CmsXmlContentHandler.DisplayType result = this.m_displayTypes.get(path);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Set<String> getCSSHeadIncludes() {
        return Collections.unmodifiableSet(this.m_cssHeadIncludes);
    }

    @Override
    public Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        return this.getCSSHeadIncludes();
    }

    @Override
    public String getDefault(CmsObject cms, CmsResource resource, I_CmsXmlSchemaType type, String path, Locale locale) {
        String defaultValue;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) {
            defaultValue = type.getDefault(locale);
        } else {
            defaultValue = this.m_defaultValues.get(path);
            if (defaultValue == null) {
                path = CmsXmlUtils.removeXpath(path);
                path = CmsXmlUtils.createXpath(path, 1);
                defaultValue = this.m_defaultValues.get(path);
            }
        }
        if (defaultValue != null) {
            CmsObject newCms = cms;
            if (resource != null) {
                try {
                    CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(resource.getRootPath());
                    if (site != null) {
                        newCms = OpenCms.initCmsObject(cms);
                        newCms.getRequestContext().setSiteRoot(site.getSiteRoot());
                        newCms.getRequestContext().setUri(newCms.getSitePath(resource));
                    }
                }
                catch (Exception site) {
                    // empty catch block
                }
            }
            String result = defaultValue;
            if (!this.m_nonMacroResolvableDefaults.contains(path)) {
                CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(newCms).setMessages(this.getMessages(locale));
                result = resolver.resolveMacros(defaultValue);
            }
            return result;
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(path) && CmsXmlUtils.isDeepXpath(path)) {
            I_CmsXmlContentHandler subHandler;
            CmsXmlContentDefinition nestedDef;
            String subPath = CmsXmlUtils.removeFirstXpathElement(path);
            I_CmsXmlSchemaType nestedType = this.m_contentDefinition.getSchemaType(CmsXmlUtils.removeXpath(CmsXmlUtils.getFirstXpathElement(path)));
            if (nestedType instanceof CmsXmlNestedContentDefinition && (nestedDef = ((CmsXmlNestedContentDefinition)nestedType).getNestedContentDefinition()) != null && (subHandler = nestedDef.getContentHandler()) != null) {
                return subHandler.getDefault(cms, resource, nestedType, subPath, locale);
            }
        }
        return null;
    }

    @Override
    public String getDefault(CmsObject cms, I_CmsXmlContentValue value, Locale locale) {
        String path = null;
        if (value.getElement() != null) {
            path = value.getPath();
        }
        return this.getDefault(cms, value.getDocument() != null ? value.getDocument().getFile() : null, value, path, locale);
    }

    @Override
    public I_CmsComplexWidget getDefaultComplexWidget() {
        return this.m_defaultWidgetInstance;
    }

    @Override
    public String getDefaultComplexWidgetClass() {
        return this.m_defaultWidget;
    }

    @Override
    public String getDefaultComplexWidgetConfiguration() {
        return this.m_defaultWidgetConfig;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDisplayType(I_CmsXmlSchemaType type) {
        if (this.m_displayTypes.containsKey(type.getName())) {
            return this.m_displayTypes.get(type.getName());
        }
        return I_CmsXmlContentHandler.DisplayType.none;
    }

    @Override
    public I_CmsEditHandler getEditHandler() {
        return this.m_editHandler;
    }

    @Override
    public List<I_CmsXmlContentEditorChangeHandler> getEditorChangeHandlers(boolean selfOnly) {
        if (selfOnly) {
            return Collections.unmodifiableList(this.m_editorChangeHandlers);
        }
        ArrayList<I_CmsXmlContentEditorChangeHandler> result = new ArrayList<I_CmsXmlContentEditorChangeHandler>(this.m_editorChangeHandlers);
        List<I_CmsXmlContentEditorChangeHandler> nestedHandlers = this.getNestedEditorChangeHandlers();
        result.addAll(nestedHandlers);
        return result;
    }

    public Map<String, String> getFieldHelp() {
        return Collections.unmodifiableMap(this.m_fieldDescriptions);
    }

    public Map<String, String> getFieldLabels() {
        return Collections.unmodifiableMap(this.m_fieldNiceNames);
    }

    @Override
    public CmsFormatterConfiguration getFormatterConfiguration(CmsObject cms, CmsResource resource) {
        ArrayList wrappers = Lists.newArrayList();
        for (CmsFormatterBean formatter : this.m_formatters) {
            CmsSchemaFormatterBeanWrapper wrapper = new CmsSchemaFormatterBeanWrapper(cms, formatter, this, resource);
            wrappers.add(wrapper);
        }
        return CmsFormatterConfiguration.create(cms, wrappers);
    }

    @Override
    public CmsGeoMappingConfiguration getGeoMappingConfiguration() {
        if (this.m_primaryGeomappingField == null && this.m_geomappingEntries.size() == 0) {
            return null;
        }
        ArrayList<CmsGeoMappingConfiguration.Entry> configEntries = new ArrayList<CmsGeoMappingConfiguration.Entry>();
        if (this.m_primaryGeomappingField != null) {
            configEntries.add(new CmsGeoMappingConfiguration.Entry(CmsGeoMappingConfiguration.EntryType.field, this.m_primaryGeomappingField));
        }
        configEntries.addAll(this.m_geomappingEntries);
        return new CmsGeoMappingConfiguration(configEntries);
    }

    @Override
    public InvalidRelationAction getInvalidRelationAction(String name) {
        return this.m_invalidRelationActions.get(name);
    }

    @Override
    public Set<String> getJSHeadIncludes() {
        return Collections.unmodifiableSet(this.m_jsHeadIncludes);
    }

    @Override
    public Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        return this.getJSHeadIncludes();
    }

    @Override
    public I_CmsXmlContentHandler.JsonRendererSettings getJsonRendererSettings() {
        return this.m_jsonRendererSettings;
    }

    @Override
    public Map<String, List<String>> getMappings() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.m_elementMappings.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return result;
    }

    @Override
    public List<String> getMappings(String elementName) {
        List<String> result = this.m_elementMappings.get(elementName);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public CmsMultiMessages.I_KeyFallbackHandler getMessageKeyHandler() {
        return this.m_messageKeyHandler;
    }

    @Override
    public CmsMessages getMessages(Locale locale) {
        CmsMultiMessages result = null;
        if (this.m_messageBundleNames == null || this.m_messageBundleNames.isEmpty()) {
            return new CmsMessages(Messages.get().getBundleName(), locale);
        }
        CmsMultiMessages multiMessages = new CmsMultiMessages(locale);
        for (String messageBundleName : this.m_messageBundleNames) {
            multiMessages.addMessages(new CmsMessages(messageBundleName, locale));
        }
        if (!this.m_messageBundleNames.contains(Messages.get().getBundleName())) {
            multiMessages.addMessages(new CmsMessages(Messages.get().getBundleName(), locale));
        }
        result = multiMessages;
        return result;
    }

    @Override
    public String getModelFolder() {
        return this.m_modelFolder;
    }

    @Override
    public List<String> getNestedFormatters(CmsObject cms, CmsResource res, Locale locale, ServletRequest req) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.hasNestedFormatters()) {
            try {
                CmsXmlContent content = req != null ? CmsXmlContentFactory.unmarshal(cms, res, req) : CmsXmlContentFactory.unmarshal(cms, cms.readFile(res));
                Locale matchingLocale = content.getBestMatchingLocale(locale);
                if (matchingLocale == null) {
                    matchingLocale = content.getLocales().get(0);
                }
                if (matchingLocale != null) {
                    for (String elementPath : this.m_nestedFormatterElements) {
                        List<I_CmsXmlContentValue> values = content.getValues(elementPath, matchingLocale);
                        for (I_CmsXmlContentValue value : values) {
                            CmsUUID formatterId;
                            CmsLink link;
                            if (value instanceof CmsXmlDisplayFormatterValue) {
                                String formatterId2 = ((CmsXmlDisplayFormatterValue)value).getFormatterId();
                                if (formatterId2 == null || CmsUUID.getNullUUID().toString().equals(formatterId2)) continue;
                                result.add(formatterId2);
                                continue;
                            }
                            if (value instanceof CmsXmlVarLinkValue) {
                                link = ((CmsXmlVarLinkValue)value).getLink(cms);
                                formatterId = link.getStructureId();
                                if (formatterId == null || formatterId.isNullUUID()) continue;
                                result.add(formatterId.toString());
                                continue;
                            }
                            if (!(value instanceof CmsXmlVfsFileValue) || (formatterId = (link = ((CmsXmlVfsFileValue)value).getLink(cms)).getStructureId()) == null || formatterId.isNullUUID()) continue;
                            result.add(formatterId.toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public CmsParameterConfiguration getParameters() {
        return this.m_parameters;
    }

    @Override
    public String getPreview(CmsObject cms, CmsXmlContent content, String resourcename) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        resolver.addMacro(MACRO_PREVIEW_TEMPFILE, resourcename);
        return resolver.resolveMacros(this.m_previewLocation);
    }

    @Override
    @Deprecated
    public CmsRelationType getRelationType(I_CmsXmlContentValue value) {
        if (value == null) {
            return CmsRelationType.XML_WEAK;
        }
        return this.getRelationType(value.getPath());
    }

    @Override
    public CmsRelationType getRelationType(String xpath) {
        return this.getRelationType(xpath, CmsRelationType.XML_WEAK);
    }

    @Override
    public CmsRelationType getRelationType(String xpath, CmsRelationType defaultType) {
        CmsRelationType relationType = null;
        if (xpath != null) {
            String path;
            relationType = this.m_relations.get(xpath);
            if (relationType == null) {
                path = CmsXmlUtils.removeAllXpathIndices(xpath);
                relationType = this.m_relations.get(path);
            }
            if (relationType == null) {
                path = CmsXmlUtils.getLastXpathElement(xpath);
                relationType = this.m_relations.get(path);
            }
        }
        if (relationType == null) {
            relationType = defaultType;
        }
        return relationType;
    }

    @Override
    public I_CmsXmlContentValue.SearchContentType getSearchContentType(I_CmsXmlContentValue value) {
        String path = CmsXmlUtils.removeXpath(value.getPath());
        I_CmsXmlContentValue.SearchContentType searchSetting = this.m_searchSettings.get(path);
        if (searchSetting == null) {
            String[] pathElements = path.split("/");
            I_CmsXmlSchemaType type = value.getDocument().getContentDefinition().getSchemaType(pathElements[0]);
            for (int i = 1; i < pathElements.length; ++i) {
                type = ((CmsXmlNestedContentDefinition)type).getNestedContentDefinition().getSchemaType(pathElements[i]);
                String subPath = this.getSubPath(pathElements, i);
                searchSetting = type.getContentDefinition().getContentHandler().getSearchSettings().get(subPath);
                if (searchSetting != null) break;
            }
        }
        return searchSetting == null ? value.getSearchContentType() : searchSetting;
    }

    @Override
    public Set<CmsSearchField> getSearchFields() {
        return Collections.unmodifiableSet(new HashSet<CmsSearchField>(this.m_searchFields.values()));
    }

    @Override
    public Set<CmsSearchField> getSearchFieldsForPage() {
        return Collections.unmodifiableSet(new HashSet<CmsSearchField>(this.m_searchFieldsPage.values()));
    }

    @Override
    public Map<String, I_CmsXmlContentValue.SearchContentType> getSearchSettings() {
        return this.m_searchSettings;
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings(CmsObject cms, CmsResource resource) {
        return Collections.unmodifiableMap(this.m_settings);
    }

    @Override
    public CmsSynchronizationSpec getSynchronizations(boolean recursive) {
        if (!recursive) {
            return new CmsSynchronizationSpec(this.m_synchronizations);
        }
        if (this.m_combinedSynchronizations == null) {
            LinkedHashMap<String, I_CmsXmlContentHandler.SynchronizationMode> combinedSynchronizations = new LinkedHashMap<String, I_CmsXmlContentHandler.SynchronizationMode>();
            this.combineSynchronizations(this.m_contentDefinition, "", combinedSynchronizations);
            this.m_combinedSynchronizations = combinedSynchronizations;
        }
        return new CmsSynchronizationSpec(this.m_combinedSynchronizations);
    }

    @Override
    public List<CmsXmlContentTab> getTabs() {
        return Collections.unmodifiableList(this.m_tabs);
    }

    @Override
    public String getTitleMapping(CmsObject cms, CmsXmlContent document, Locale locale) {
        String result = null;
        if (this.m_titleMappings.size() > 0) {
            String xpath = this.m_titleMappings.get(0);
            result = document.getStringValue(cms, xpath, locale);
            if (result == null && (this.isMappingUsingDefault(xpath, TITLE_PROPERTY_MAPPING) || this.isMappingUsingDefault(xpath, TITLE_PROPERTY_SHARED_MAPPING) || this.isMappingUsingDefault(xpath, TITLE_PROPERTY_INDIVIDUAL_MAPPING))) {
                result = this.getDefault(cms, document.getFile(), null, xpath, locale);
            }
            if (result != null) {
                try {
                    CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(this.createRootCms(cms), document, locale);
                    resolver.setKeepEmptyMacros(true);
                    result = resolver.resolveMacros(result);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public String getValidationError(String elementName) {
        return this.m_validationErrorMessages.get(elementName);
    }

    public String getValidationWarning(String elementName) {
        return this.m_validationWarningMessages.get(elementName);
    }

    public String getValidationWarningOrErrorMessage(CmsObject cms, Locale locale, String elementName, boolean isWarning, boolean keyOnly) {
        String rawValue = (isWarning ? this.m_validationWarningMessages : this.m_validationErrorMessages).get(elementName);
        if (rawValue == null) {
            return null;
        }
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setMessages(this.getMessages(locale));
        if (keyOnly) {
            resolver = new CmsKeyDummyMacroResolver(resolver);
        }
        String resolved = resolver.resolveMacros(rawValue);
        if (keyOnly) {
            return CmsKeyDummyMacroResolver.getKey(resolved);
        }
        return resolved;
    }

    @Override
    public String getVersionTransformation() {
        return this.m_versionTransformation;
    }

    public String getVisibilityConfigString(String field) {
        VisibilityConfiguration visConfig = this.m_visibilityConfigurations.get(field);
        if (visConfig == null) {
            return null;
        }
        if (visConfig.getHandler() == this) {
            return visConfig.getParams();
        }
        return null;
    }

    @Override
    public I_CmsWidget getWidget(CmsObject cms, String path) {
        String widgetName = this.m_widgetNames.get(path);
        if (widgetName == null) {
            return null;
        }
        if (cms != null) {
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(cms);
            widgetName = resolver.resolveMacros(widgetName);
        }
        I_CmsWidget result = null;
        result = OpenCms.getXmlContentTypeManager().getWidget(widgetName);
        if (result != null) {
            return result.newInstance();
        }
        if (CmsStringUtil.isValidJavaClassName(widgetName)) {
            try {
                Class<?> cls = Class.forName(widgetName, false, this.getClass().getClassLoader());
                if (I_CmsWidget.class.isAssignableFrom(cls)) {
                    return (I_CmsWidget)cls.newInstance();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public I_CmsWidget getWidget(I_CmsXmlSchemaType value) {
        I_CmsWidget result = this.getWidget(null, value.getName());
        result = result == null ? OpenCms.getXmlContentTypeManager().getWidgetDefault(value.getTypeName()) : result.newInstance();
        if (result != null) {
            String configuration = this.getConfiguration(value);
            if (configuration == null) {
                configuration = OpenCms.getXmlContentTypeManager().getWidgetDefaultConfiguration(result);
            }
            result.setConfiguration(configuration);
        }
        return result;
    }

    @Override
    public boolean hasModifiableFormatters() {
        return this.m_formatters != null && this.m_formatters.size() > 0;
    }

    @Override
    public boolean hasNestedFormatters() {
        return !this.m_nestedFormatterElements.isEmpty();
    }

    @Override
    public boolean hasSynchronizedElements() {
        return !this.m_synchronizations.isEmpty();
    }

    @Override
    public boolean hasVisibilityHandlers() {
        return this.m_visibilityConfigurations != null && !this.m_visibilityConfigurations.isEmpty();
    }

    @Override
    public synchronized void initialize(Element appInfoElement, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        if (appInfoElement != null) {
            this.validateAppinfoElement(appInfoElement);
            this.init();
            Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(appInfoElement);
            while (i.hasNext()) {
                Element element = i.next();
                String nodeName = element.getName();
                if (nodeName.equals(APPINFO_MAPPINGS)) {
                    this.initMappings(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_LAYOUTS)) {
                    this.initLayouts(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_VALIDATIONRULES)) {
                    this.initValidationRules(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_RELATIONS)) {
                    this.initRelations(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_DEFAULTS)) {
                    this.initDefaultValues(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_MODELFOLDER)) {
                    this.initModelFolder(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals("preview")) {
                    this.initPreview(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_RESOURCEBUNDLE)) {
                    this.initResourceBundle(element, contentDefinition, true);
                    continue;
                }
                if (nodeName.equals(APPINFO_RESOURCEBUNDLES)) {
                    this.initResourceBundle(element, contentDefinition, false);
                    continue;
                }
                if (nodeName.equals(APPINFO_SEARCHSETTINGS)) {
                    this.initSearchSettings(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_TABS)) {
                    this.initTabs(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_FORMATTERS)) {
                    this.initFormatters(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_HEAD_INCLUDES)) {
                    this.initHeadIncludes(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_SETTINGS)) {
                    this.initSettings(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_EDIT_HANDLER)) {
                    this.initEditHandler(element);
                    continue;
                }
                if (nodeName.equals(APPINFO_NESTED_FORMATTERS)) {
                    this.initNestedFormatters(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_TEMPLATES)) {
                    this.initTemplates(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_DEFAULTWIDGET)) {
                    this.initDefaultWidget(element);
                    continue;
                }
                if (nodeName.equals(APPINFO_VISIBILITIES)) {
                    this.initVisibilities(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_SYNCHRONIZATIONS)) {
                    this.initSynchronizations(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_EDITOR_CHANGE_HANDLERS)) {
                    this.initEditorChangeHandlers(element);
                    continue;
                }
                if (nodeName.equals(APPINFO_MESSAGEKEYHANDLER)) {
                    this.initMessageKeyHandler(element);
                    continue;
                }
                if (nodeName.equals(APPINFO_PARAMETERS)) {
                    this.initParameters(element);
                    continue;
                }
                if (nodeName.equals(APPINFO_FIELD_SETTINGS)) {
                    this.initFields(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_JSON_RENDERER)) {
                    this.initJsonRenderer(element);
                    continue;
                }
                if (nodeName.equals(APPINFO_REVERSE_MAPPING_ENABLED)) {
                    this.m_reverseMappingEnabled = Boolean.parseBoolean(element.getTextTrim());
                    continue;
                }
                if (nodeName.equals(APPINFO_GEOMAPPING)) {
                    this.initGeoMappingEntries(element);
                    continue;
                }
                if (!nodeName.equals(APPINFO_VERSION_TRANSFORMATION)) continue;
                this.m_versionTransformation = element.getTextTrim();
            }
        }
        this.m_contentDefinition = contentDefinition;
        this.addGeoMappingField();
        this.addDefaultCheckRules(contentDefinition, null, null);
    }

    @Override
    public void invalidateBrokenLinks(CmsObject cms, CmsXmlContent document) {
        if (cms == null || cms.getRequestContext().getRequestTime() == Long.MIN_VALUE) {
            return;
        }
        boolean needReinitialization = false;
        for (Locale locale : document.getLocales()) {
            ArrayList<String> removedNodes = new ArrayList<String>();
            HashMap valuesToRemove = Maps.newHashMap();
            for (I_CmsXmlContentValue value : document.getValues(locale)) {
                InvalidRelationAction invalidRelationAction = CmsDefaultXmlContentHandler.getInvalidRelationActionForValue(value);
                String path = value.getPath();
                boolean alreadyRemoved = false;
                for (String remNode : removedNodes) {
                    if (!path.startsWith(remNode)) continue;
                    alreadyRemoved = true;
                    break;
                }
                if (alreadyRemoved || this.m_relationChecks.get(path) == null && invalidRelationAction == null && this.m_relationChecks.get(CmsXmlUtils.removeXpath(path)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_RULE_MATCH_1", path));
                }
                if (!this.validateLink(cms, value, null)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_WARNING_2", path, value.getStringValue(cms)));
                }
                String parentPath = path;
                boolean firstIteration = true;
                while (this.isInvalidateParent(parentPath) || firstIteration && invalidRelationAction == InvalidRelationAction.removeParent) {
                    firstIteration = false;
                    parentPath = CmsXmlUtils.removeLastXpathElement(parentPath);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_PARENT_2", path, parentPath));
                }
                value = document.getValue(parentPath, locale);
                valuesToRemove.put(parentPath, value);
                removedNodes.add(parentPath);
            }
            for (I_CmsXmlContentValue valueToRemove : valuesToRemove.values()) {
                valueToRemove.getElement().detach();
                needReinitialization = true;
            }
        }
        if (needReinitialization) {
            document.m_hasInvalidatedBrokenLinks = true;
            document.initDocument();
        }
    }

    @Override
    public boolean isAcaciaEditorDisabled() {
        return !this.m_useAcacia;
    }

    @Override
    public boolean isContainerPageOnly() {
        return this.m_containerPageOnly;
    }

    @Override
    public boolean isValueVisible(CmsObject cms, I_CmsXmlSchemaType value, String elementName, String params, CmsResource resource, Locale contentLocale) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        boolean result = false;
        try {
            List<CmsRole> roles = OpenCms.getRoleManager().getRolesOfUser(cms, user.getName(), "", true, false, true);
            List<CmsGroup> groups = cms.getGroupsOfUser(user.getName(), false);
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(cms);
            Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(wpLocale));
            params = resolver.resolveMacros(params);
            if ("visible".equals(params.trim())) {
                return true;
            }
            String[] allowedPrincipals = params.split("\\|");
            ArrayList<String> groupNames = new ArrayList<String>();
            ArrayList<String> roleNames = new ArrayList<String>();
            for (CmsGroup group : groups) {
                groupNames.add(group.getName());
            }
            for (CmsRole role : roles) {
                roleNames.add(role.getRoleName());
            }
            for (Iterator<Object> iterator : allowedPrincipals) {
                if (CmsRole.hasPrefix(iterator)) {
                    String string = CmsRole.removePrefix(iterator);
                    if (!roleNames.contains(string)) continue;
                    result = true;
                } else {
                    String string = CmsGroup.removePrefix(iterator);
                    if (!groupNames.contains(string)) continue;
                    result = true;
                }
                break;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isVisible(CmsObject cms, I_CmsXmlSchemaType contentValue, String valuePath, CmsResource resource, Locale contentLocale) {
        CmsAccessRestrictionInfo restrictionInfo;
        if (contentValue instanceof CmsXmlAccessRestrictionValue && (restrictionInfo = CmsAccessRestrictionInfo.getRestrictionInfo(cms, this.m_contentDefinition)) == null) {
            return false;
        }
        if (this.hasVisibilityHandlers() && this.m_visibilityConfigurations.containsKey(valuePath)) {
            VisibilityConfiguration config = this.m_visibilityConfigurations.get(valuePath);
            return config.getHandler().isValueVisible(cms, contentValue, valuePath, config.getParams(), resource, contentLocale);
        }
        return true;
    }

    @Override
    public CmsXmlContent prepareForUse(CmsObject cms, CmsXmlContent content) {
        return content;
    }

    @Override
    public CmsFile prepareForWrite(CmsObject cms, CmsXmlContent content, CmsFile file) throws CmsException {
        String contentConversion;
        if (!content.isAutoCorrectionEnabled()) {
            Object attribute = cms.getRequestContext().getAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE);
            boolean autoCorrectionEnabled = attribute != null && (Boolean)attribute != false;
            content.setAutoCorrectionEnabled(autoCorrectionEnabled);
        }
        if (!content.isAutoCorrectionEnabled()) {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(contentConversion = CmsHtmlConverter.getConversionSettings(cms, file))) {
            contentConversion = "xhtml";
        }
        content.setConversion(contentConversion);
        file = content.correctXmlStructure(cms);
        content.setFile(file);
        boolean hasAttributeMappings = this.m_elementMappings.values().stream().flatMap(Collection::stream).filter(mapping -> mapping.startsWith("attribute:")).findAny().isPresent();
        CmsMappingResolutionContext mappingContext = new CmsMappingResolutionContext(content, hasAttributeMappings);
        mappingContext.setCmsObject(cms);
        cms.getRequestContext().setAttribute(ATTR_MAPPING_RESOLUTION_CONTEXT, mappingContext);
        content.resolveMappings(cms);
        this.removeEmptyMappings(cms, file, content);
        this.resolveDefaultMappings(cms, file, content);
        cms.getRequestContext().removeAttribute(ATTR_MAPPING_RESOLUTION_CONTEXT);
        mappingContext.finalizeMappings();
        file = this.writeCategories(cms, file, content);
        return file;
    }

    @Override
    public void resolveMapping(CmsObject cms, CmsXmlContent content, I_CmsXmlContentValue value) throws CmsException {
        if (content.getFile() == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_RESOLVE_FILE_NOT_FOUND_0"));
        }
        boolean valueIsSimple = value.isSimpleType();
        String valuePath = value.getPath();
        int valueIndex = value.getIndex();
        Locale valueLocale = value.getLocale();
        CmsObject rootCms1 = this.createRootCms(cms);
        String originalStringValue = null;
        if (valueIsSimple) {
            originalStringValue = value.getStringValue(rootCms1);
        }
        this.resolveMapping(cms, content, valuePath, valueIsSimple, valueIndex, valueLocale, originalStringValue);
    }

    @Override
    public CmsXmlContentErrorHandler resolveValidation(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = new CmsXmlContentErrorHandler();
        }
        if (!value.isSimpleType()) {
            return errorHandler;
        }
        errorHandler = this.validateValue(cms, value, errorHandler, this.m_validationErrorRules, false);
        errorHandler = this.validateValue(cms, value, errorHandler, this.m_validationWarningRules, true);
        errorHandler = this.validateCategories(cms, value, errorHandler);
        return errorHandler;
    }

    protected void addCheckRule(CmsXmlContentDefinition contentDefinition, String elementName, String invalidate, String type) throws CmsXmlException {
        I_CmsXmlSchemaType schemaType = contentDefinition.getSchemaType(elementName);
        if (schemaType == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_INVALID_ELEM_1", elementName));
        }
        if (!"OpenCmsVfsFile".equals(schemaType.getTypeName()) && !"OpenCmsVarLink".equals(schemaType.getTypeName())) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_INVALID_TYPE_1", elementName));
        }
        Boolean invalidateParent = null;
        if (invalidate == null || invalidate.equalsIgnoreCase(Boolean.TRUE.toString()) || invalidate.equalsIgnoreCase(APPINFO_ATTR_TYPE_NODE)) {
            invalidateParent = Boolean.FALSE;
        } else if (invalidate.equalsIgnoreCase(APPINFO_ATTR_TYPE_PARENT)) {
            invalidateParent = Boolean.TRUE;
        }
        if (invalidateParent != null) {
            this.m_relationChecks.put(elementName, invalidateParent);
        }
        CmsRelationType relationType = type == null ? CmsRelationType.XML_WEAK : CmsRelationType.valueOfXml(type);
        this.m_relations.put(elementName, relationType);
        if (invalidateParent != null) {
            String path = elementName;
            while (CmsStringUtil.isNotEmptyOrWhitespaceOnly(path)) {
                if (!this.isInvalidateParent(path)) {
                    if (contentDefinition.getSchemaType(path).getMinOccurs() <= 0) break;
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_NOT_OPTIONAL_1", path));
                }
                if (!CmsXmlUtils.isDeepXpath(path)) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_NOT_EMPTY_DOC_0"));
                }
                path = CmsXmlUtils.removeLastXpathElement(path);
            }
        }
    }

    protected void addConfiguration(CmsXmlContentDefinition contentDefinition, String elementName, String configurationValue) throws CmsXmlException {
        if (!elementName.contains("/") && contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CONFIG_ELEM_UNKNOWN_1", elementName));
        }
        this.m_configurationValues.put(elementName, configurationValue);
    }

    protected void addDefault(CmsXmlContentDefinition contentDefinition, String elementName, String defaultValue, String resolveMacrosValue) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(org.opencms.xml.types.Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1", elementName));
        }
        String xpath = CmsXmlUtils.createXpath(elementName, 1);
        this.m_defaultValues.put(xpath, defaultValue);
        if (resolveMacrosValue != null && !Boolean.parseBoolean(resolveMacrosValue)) {
            this.m_nonMacroResolvableDefaults.add(xpath);
        }
    }

    protected void addDefaultCheckRules(CmsXmlContentDefinition rootContentDefinition, I_CmsXmlSchemaType schemaType, String elementPath) throws CmsXmlException {
        if (schemaType != null && schemaType.isSimpleType()) {
            if (schemaType.getMinOccurs() == 0 && ("OpenCmsVfsFile".equals(schemaType.getTypeName()) || "OpenCmsVarLink".equals(schemaType.getTypeName())) && !this.m_relationChecks.containsKey(elementPath) && !this.m_relations.containsKey(elementPath)) {
                this.addCheckRule(rootContentDefinition, elementPath, null, null);
            }
        } else {
            CmsXmlContentDefinition nestedContentDefinition = rootContentDefinition;
            if (schemaType != null) {
                CmsXmlNestedContentDefinition nestedDefinition = (CmsXmlNestedContentDefinition)schemaType;
                nestedContentDefinition = nestedDefinition.getNestedContentDefinition();
            }
            for (String element : nestedContentDefinition.getSchemaTypes()) {
                String path = schemaType != null ? CmsXmlUtils.concatXpath(elementPath, element) : element;
                I_CmsXmlSchemaType nestedSchema = nestedContentDefinition.getSchemaType(element);
                if (schemaType != null && nestedSchema.equals(schemaType)) continue;
                this.addDefaultCheckRules(rootContentDefinition, nestedSchema, path);
            }
        }
    }

    protected void addDisplayType(CmsXmlContentDefinition contentDefinition, String elementName, I_CmsXmlContentHandler.DisplayType displayType) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CONFIG_ELEM_UNKNOWN_1", elementName));
        }
        this.m_displayTypes.put(elementName, displayType);
    }

    protected void addGeoMappingField() {
        CmsGeoMappingConfiguration mappingConfig = this.getGeoMappingConfiguration();
        if (mappingConfig != null) {
            CmsSolrField field = new CmsSolrField(GEOMAPPING_FIELD, Collections.emptyList(), CmsLocaleManager.getDefaultLocale(), "0.000000,0.000000");
            CmsGeoCoordinateFieldMapping mapping = new CmsGeoCoordinateFieldMapping(this.getGeoMappingConfiguration());
            field.addMapping(mapping);
            this.m_searchFields.put("__geocoord__", field);
        }
    }

    protected void addMapping(CmsXmlContentDefinition contentDefinition, String elementName, String mapping, String useDefault) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_MAPPING_1", elementName));
        }
        String xpath = CmsXmlUtils.createXpath(elementName, 1);
        List<String> values = this.m_elementMappings.get(xpath);
        if (values == null) {
            values = new ArrayList<String>(4);
            this.m_elementMappings.put(xpath, values);
        }
        if (Boolean.parseBoolean(useDefault)) {
            this.m_mappingsUsingDefault.add(xpath + ":" + mapping);
        }
        values.add(mapping);
        if (mapping.startsWith("property:") && mapping.endsWith(":Title")) {
            this.m_titleMappings.add(xpath);
        }
    }

    protected void addNestedFormatter(String elementName, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_MAPPING_1", elementName));
        }
        this.m_nestedFormatterElements.add(elementName);
    }

    @Deprecated
    protected void addSearchField(CmsXmlContentDefinition contentDefinition, CmsSearchField field) {
        this.addSearchField(contentDefinition, field, I_CmsXmlContentHandler.MappingType.ELEMENT);
    }

    protected void addSearchField(CmsXmlContentDefinition contentDefinition, CmsSearchField field, I_CmsXmlContentHandler.MappingType type) {
        Locale locale = null;
        if (field instanceof CmsSolrField) {
            locale = ((CmsSolrField)field).getLocale();
        }
        String key = CmsXmlUtils.concatXpath(locale != null ? locale.toString() : null, field.getName());
        switch (type) {
            case PAGE: {
                this.m_searchFieldsPage.put(key, field);
                break;
            }
            default: {
                this.m_searchFields.put(key, field);
            }
        }
    }

    protected void addSearchSetting(CmsXmlContentDefinition contentDefinition, String elementName, I_CmsXmlContentValue.SearchContentType value) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_SEARCHSETTINGS_1", elementName));
        }
        this.m_searchSettings.put(elementName, value);
    }

    protected void addSimpleSearchSetting(CmsXmlContentDefinition contentDef, String name, String value) throws CmsXmlException {
        I_CmsXmlContentValue.SearchContentType searchContentType = I_CmsXmlContentValue.SearchContentType.fromString(value);
        if (null != searchContentType) {
            this.addSearchSetting(contentDef, name, searchContentType);
        } else if ("geocoords".equals(value) || "listgeocoords".equals(value)) {
            this.m_primaryGeomappingField = name;
            this.m_searchSettings.put(CmsXmlUtils.removeXpath(name), I_CmsXmlContentValue.SearchContentType.FALSE);
        } else {
            StringTemplate template = this.m_searchTemplateGroup.getInstanceOf(value);
            if (template != null && template.getFormalArgument(APPINFO_ATTR_NAME) != null) {
                template.setAttribute(APPINFO_ATTR_NAME, (Object)CmsEncoder.escapeXml(name));
                String xml = template.toString();
                try {
                    Document doc = DocumentHelper.parseText((String)xml);
                    this.initSearchSettings(doc.getRootElement(), contentDef);
                }
                catch (DocumentException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void addValidationRule(CmsXmlContentDefinition contentDefinition, String elementName, String regex, String message, boolean isWarning) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_VALIDATION_1", elementName));
        }
        if (isWarning) {
            this.m_validationWarningRules.put(elementName, regex);
            if (message != null) {
                this.m_validationWarningMessages.put(elementName, message);
            }
        } else {
            this.m_validationErrorRules.put(elementName, regex);
            if (message != null) {
                this.m_validationErrorMessages.put(elementName, message);
            }
        }
    }

    protected void addWidget(CmsXmlContentDefinition contentDefinition, String elementName, String name) throws CmsXmlException {
        if (!elementName.contains("/") && contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_LAYOUTWIDGET_1", elementName));
        }
        if (name.indexOf(37) == -1 && OpenCms.getXmlContentTypeManager().getWidget(name) == null && CmsStringUtil.isValidJavaClassName(name)) {
            try {
                Class<?> cls = Class.forName(name, false, this.getClass().getClassLoader());
                if (!I_CmsWidget.class.isAssignableFrom(cls) && !I_CmsComplexWidget.class.isAssignableFrom(cls)) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_CUSTOM_CLASS_3", name, elementName, contentDefinition.getSchemaLocation()));
                }
            }
            catch (Exception e) {
                throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_CUSTOM_CLASS_3", name, elementName, contentDefinition.getSchemaLocation()), (Throwable)e);
            }
        }
        this.m_widgetNames.put(elementName, name);
    }

    protected VisibilityConfiguration createVisibilityConfiguration(String className, String params) {
        I_CmsXmlContentVisibilityHandler handler = this;
        if (className != null) {
            try {
                handler = (I_CmsXmlContentVisibilityHandler)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        VisibilityConfiguration result = new VisibilityConfiguration(handler, params);
        return result;
    }

    protected MappingInfo getAttributeMapping(CmsMappingResolutionContext.AttributeType attr) {
        String target = null;
        String source = null;
        switch (attr) {
            case expiration: {
                target = "attribute:dateexpired";
                break;
            }
            case release: {
                target = "attribute:datereleased";
                break;
            }
        }
        if (target != null) {
            source = this.getMappingSource(target);
        }
        return new MappingInfo(source, target);
    }

    protected List<Locale> getLocalesForResource(CmsObject cms, String resource) {
        List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        if (locales == null || locales.isEmpty()) {
            locales = OpenCms.getLocaleManager().getAvailableLocales();
        }
        return locales;
    }

    protected List<I_CmsXmlContentEditorChangeHandler> getNestedEditorChangeHandlers() {
        ArrayListMultimap configMap = ArrayListMultimap.create();
        CmsDefaultXmlContentHandler.collectNestedChangeHandlerConfigs(this.m_contentDefinition, "", (Multimap<String, CmsChangeHandlerConfig>)configMap);
        ArrayList<I_CmsXmlContentEditorChangeHandler> result = new ArrayList<I_CmsXmlContentEditorChangeHandler>();
        for (String key : configMap.keySet()) {
            for (CmsChangeHandlerConfig handlerConfig : configMap.get((Object)key)) {
                String path = CmsStringUtil.joinPaths(key, handlerConfig.getField());
                String scope = CmsDefaultXmlContentHandler.normalizeChangeHandlerScope(path = CmsFileUtil.removeLeadingSeparator(path));
                Optional<I_CmsXmlContentEditorChangeHandler> optHandler = handlerConfig.newHandler(scope);
                if (!optHandler.isPresent()) continue;
                result.add(optHandler.get());
            }
        }
        ArrayList<I_CmsXmlContentEditorChangeHandler> nestedHandlers = result;
        return nestedHandlers;
    }

    protected String getReferencePath(CmsObject cms, I_CmsXmlContentValue value) {
        CmsFile file;
        block7: {
            file = value.getDocument().getFile();
            String resourceName = cms.getSitePath(file);
            if (CmsWorkplace.isTemporaryFile(file)) {
                StringBuffer result = new StringBuffer(resourceName.length() + 2);
                result.append(CmsResource.getFolderPath(resourceName));
                result.append(CmsResource.getName(resourceName).substring(1));
                resourceName = result.toString();
            }
            try {
                List<CmsResource> listsib = cms.readSiblings(resourceName, CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = listsib.get(i);
                    List<Locale> locales = this.getLocalesForResource(cms, cms.getSitePath(resource));
                    for (Locale l : locales) {
                        if (!value.getLocale().equals(l)) continue;
                        return cms.getSitePath(resource);
                    }
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return cms.getSitePath(file);
    }

    protected String getValidationMessage(CmsObject cms, I_CmsXmlContentValue value, String regex, String valueStr, boolean matchResult, boolean isWarning) {
        String message = null;
        message = isWarning ? this.m_validationWarningMessages.get(value.getName()) : this.m_validationErrorMessages.get(value.getName());
        if (message == null) {
            message = isWarning ? MESSAGE_VALIDATION_DEFAULT_WARNING : MESSAGE_VALIDATION_DEFAULT_ERROR;
        }
        HashMap<String, String> additionalValues = new HashMap<String, String>();
        additionalValues.put("validation.value", valueStr);
        additionalValues.put("validation.regex", (!matchResult ? "!" : "") + regex);
        additionalValues.put("validation.path", value.getPath());
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setMessages(this.getMessages(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms))).setAdditionalMacros(additionalValues);
        return resolver.resolveMacros(message);
    }

    protected void init() {
        this.m_elementMappings = new HashMap<String, List<String>>();
        this.m_validationErrorRules = new HashMap<String, String>();
        this.m_validationErrorMessages = new HashMap<String, String>();
        this.m_validationWarningRules = new HashMap<String, String>();
        this.m_validationWarningMessages = new HashMap<String, String>();
        this.m_defaultValues = new HashMap<String, String>();
        this.m_configurationValues = new HashMap<String, String>();
        this.m_searchSettings = new HashMap<String, I_CmsXmlContentValue.SearchContentType>();
        this.m_relations = new HashMap<String, CmsRelationType>();
        this.m_relationChecks = new HashMap<String, Boolean>();
        this.m_previewLocation = null;
        this.m_modelFolder = null;
        this.m_tabs = new ArrayList<CmsXmlContentTab>();
        this.m_cssHeadIncludes = new LinkedHashSet<String>();
        this.m_jsHeadIncludes = new LinkedHashSet<String>();
        this.m_settings = new LinkedHashMap<String, CmsXmlContentProperty>();
        this.m_titleMappings = new ArrayList<String>(2);
        this.m_formatters = new ArrayList<CmsFormatterBean>();
        this.m_searchFields = new HashMap<String, CmsSearchField>();
        this.m_searchFieldsPage = new HashMap<String, CmsSearchField>();
        this.m_allowedTemplates = new CmsDefaultSet();
        this.m_allowedTemplates.setDefaultMembership(true);
        this.m_displayTypes = new HashMap();
        this.m_editorChangeHandlers = new ArrayList<I_CmsXmlContentEditorChangeHandler>();
        this.m_nestedFormatterElements = new HashSet<String>();
        try (InputStream stream = CmsDefaultXmlContentHandler.class.getResourceAsStream("simple-searchsetting-configs.st");){
            this.m_searchTemplateGroup = CmsStringUtil.readStringTemplateGroup(stream);
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void initDefaultValues(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, "default");
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue("element");
            String defaultValue = element.attributeValue(APPINFO_ATTR_VALUE);
            String resolveMacrosValue = element.attributeValue(APPINFO_ATTR_RESOLVE_MACROS);
            if (elementName == null || defaultValue == null) continue;
            this.addDefault(contentDefinition, elementName, defaultValue, resolveMacrosValue);
        }
    }

    protected void initDefaultWidget(Element element) {
        this.m_defaultWidget = element.attributeValue(APPINFO_ATTR_WIDGET);
        this.m_defaultWidgetConfig = element.attributeValue("configuration");
        try {
            this.m_defaultWidgetInstance = (I_CmsComplexWidget)Class.forName(this.m_defaultWidget).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void initEditHandler(Element handlerElement) {
        String editHandlerClass = handlerElement.attributeValue(APPINFO_ATTR_CLASS);
        HashMap params = Maps.newHashMap();
        Element paramsElement = handlerElement.element(APPINFO_PARAMETERS);
        if (paramsElement != null) {
            for (Element paramElement : paramsElement.elements(APPINFO_PARAM)) {
                String name = paramElement.attributeValue(APPINFO_ATTR_NAME);
                String value = paramElement.getText();
                params.put(name, value);
            }
        }
        try {
            this.m_editHandler = (I_CmsEditHandler)Class.forName(editHandlerClass).newInstance();
            this.m_editHandler.setParameters(params);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void initEditorChangeHandlers(Element element) {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(element, APPINFO_EDITOR_CHANGE_HANDLER);
        while (i.hasNext()) {
            Element handlerElement = i.next();
            String handlerClass = handlerElement.attributeValue(APPINFO_ATTR_CLASS);
            String configuration = handlerElement.attributeValue("configuration");
            String scope = handlerElement.attributeValue(APPINFO_ATTR_SCOPE);
            try {
                I_CmsXmlContentEditorChangeHandler handler = (I_CmsXmlContentEditorChangeHandler)Class.forName(handlerClass).newInstance();
                handler.setConfiguration(configuration);
                handler.setScope(scope);
                this.m_editorChangeHandlers.add(handler);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected void initField(Element elem, CmsXmlContentDefinition contentDef) throws CmsXmlException {
        String ifInvalidRelationStr;
        String search;
        String synchronization;
        String description;
        String niceName;
        String nameVal = elem.elementText("PropertyName");
        if (nameVal == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_BAD_FIELD_NAME_1", nameVal));
        }
        String name = nameVal.trim();
        String ruleRegex = elem.elementText("RuleRegex");
        String ruleType = elem.elementText("RuleType");
        String error = elem.elementText("Error");
        if (error == null) {
            error = "";
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(ruleRegex)) {
            this.addValidationRule(contentDef, name, ruleRegex, error, APPINFO_ATTR_TYPE_WARNING.equalsIgnoreCase(ruleType));
        } else if (!CmsStringUtil.isEmptyOrWhitespaceOnly(error)) {
            if (APPINFO_ATTR_TYPE_WARNING.equalsIgnoreCase(ruleType)) {
                this.m_validationWarningMessages.put(name, error);
            } else {
                this.m_validationErrorMessages.put(name, error);
            }
        }
        String defaultValue = elem.elementText("Default");
        String defaultResolveMacros = elem.elementTextTrim(FieldSettingElems.DefaultResolveMacros.name());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(defaultValue)) {
            this.addDefault(contentDef, name, defaultValue, defaultResolveMacros);
        }
        String widget = elem.elementText("Widget");
        String widgetConfig = elem.elementText("WidgetConfig");
        if (widget != null) {
            this.addWidget(contentDef, name, widget);
        }
        if (widgetConfig != null) {
            widgetConfig = widgetConfig.trim();
            this.addConfiguration(contentDef, name, widgetConfig);
        }
        if ((niceName = elem.elementText("DisplayName")) != null) {
            this.m_fieldNiceNames.put(name, niceName);
        }
        if ((description = elem.elementText("Description")) != null) {
            this.m_fieldDescriptions.put(name, description);
        }
        for (Element mappingElem : elem.elements(FieldSettingElems.Mapping.name())) {
            Iterator mapTo = mappingElem.elementText(FieldSettingElems.MapTo.name());
            String useDefault = mappingElem.elementText(FieldSettingElems.UseDefault.name());
            if (mapTo == null) continue;
            this.addMapping(contentDef, name, (String)((Object)mapTo), useDefault);
        }
        String display = elem.elementTextTrim(FieldSettingElems.Display.name());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(display)) {
            try {
                this.addDisplayType(contentDef, name, I_CmsXmlContentHandler.DisplayType.valueOf(display));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if ((synchronization = elem.elementTextTrim(FieldSettingElems.Synchronization.name())) != null) {
            if ("strong".equals(synchronization)) {
                this.m_synchronizations.put(name, I_CmsXmlContentHandler.SynchronizationMode.strong);
            } else if (Boolean.parseBoolean(synchronization)) {
                this.m_synchronizations.put(name, I_CmsXmlContentHandler.SynchronizationMode.standard);
            } else {
                this.m_synchronizations.put(name, I_CmsXmlContentHandler.SynchronizationMode.none);
            }
        }
        for (Element relElem : elem.elements(FieldSettingElems.Relation.name())) {
            String type = relElem.elementTextTrim(FieldSettingElems.Type.name());
            String invalidate = relElem.elementTextTrim(FieldSettingElems.Invalidate.name());
            if (type != null) {
                type = type.toLowerCase();
            }
            if (invalidate != null) {
                invalidate = invalidate.toLowerCase();
            }
            this.addCheckRule(contentDef, name, invalidate, type);
        }
        for (Element visElem : elem.elements(FieldSettingElems.Visibility.name())) {
            String params = visElem.getText();
            VisibilityConfiguration visConfig = this.createVisibilityConfiguration(null, params);
            this.m_visibilityConfigurations.put(name, visConfig);
        }
        for (Element visElem : elem.elements(FieldSettingElems.FieldVisibility.name())) {
            String className = visElem.elementTextTrim(FieldSettingElems.Class.name());
            String params = visElem.elementTextTrim(FieldSettingElems.Params.name());
            VisibilityConfiguration visConfig = this.createVisibilityConfiguration(className, params);
            this.m_visibilityConfigurations.put(name, visConfig);
        }
        String nestedFormatter = elem.elementTextTrim(FieldSettingElems.NestedFormatter.name());
        if (Boolean.parseBoolean(nestedFormatter)) {
            this.m_nestedFormatterElements.add(name);
        }
        if ((search = elem.elementTextTrim(FieldSettingElems.Search.name())) != null) {
            this.addSimpleSearchSetting(contentDef, name, search);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(ifInvalidRelationStr = elem.elementTextTrim(FieldSettingElems.IfInvalidRelation.name()))) {
            ifInvalidRelationStr = null;
        }
        if (ifInvalidRelationStr != null) {
            if (name.contains("[") || name.contains("/")) {
                LOG.error((Object)"Only simple field names allowed for the IfInvalidRelation field setting.");
            } else {
                try {
                    InvalidRelationAction ifInvalidRelation = InvalidRelationAction.valueOf(ifInvalidRelationStr);
                    this.m_invalidRelationActions.put(name, ifInvalidRelation);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        for (Element changeHandlerElem : elem.elements(N_CHANGEHANDLER)) {
            String config = changeHandlerElem.attributeValue("configuration");
            String className = changeHandlerElem.getText().trim();
            CmsChangeHandlerConfig entry = new CmsChangeHandlerConfig(name, className, config);
            this.m_changeHandlerConfigs.add(entry);
        }
    }

    protected void initFields(Element parent, CmsXmlContentDefinition contentDef) throws CmsXmlException {
        for (Element fieldElem : parent.elements(N_SETTING)) {
            this.initField(fieldElem, contentDef);
        }
    }

    protected void initFormatters(Element root, CmsXmlContentDefinition contentDefinition) {
        Iterator<Element> itFormatter = CmsXmlGenericWrapper.elementIterator(root, APPINFO_FORMATTER);
        while (itFormatter.hasNext()) {
            Element element = itFormatter.next();
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(type)) {
                type = "*";
            }
            String jspRootPath = element.attributeValue(APPINFO_ATTR_URI);
            String minWidthStr = element.attributeValue(APPINFO_ATTR_MINWIDTH);
            String maxWidthStr = element.attributeValue(APPINFO_ATTR_MAXWIDTH);
            String preview = element.attributeValue("preview");
            String searchContent = element.attributeValue(APPINFO_ATTR_SEARCHCONTENT);
            this.m_formatters.add(new CmsFormatterBean(type, jspRootPath, minWidthStr, maxWidthStr, preview, searchContent, contentDefinition.getSchemaLocation()));
        }
    }

    protected void initHeadIncludes(Element root, CmsXmlContentDefinition contentDefinition) {
        Iterator<Element> itInclude = CmsXmlGenericWrapper.elementIterator(root, APPINFO_HEAD_INCLUDE);
        while (itInclude.hasNext()) {
            Element element = itInclude.next();
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            String uri = element.attributeValue(APPINFO_ATTR_URI);
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(uri)) continue;
            if ("css".equals(type)) {
                this.m_cssHeadIncludes.add(uri);
                continue;
            }
            if (!"javascript".equals(type)) continue;
            this.m_jsHeadIncludes.add(uri);
        }
    }

    protected void initJsonRenderer(Element element) {
        String cls = element.attributeValue(APPINFO_ATTR_CLASS);
        HashMap<String, String> params = new HashMap<String, String>();
        for (Element paramElement : element.elements(APPINFO_PARAM)) {
            String name = paramElement.attributeValue(APPINFO_ATTR_NAME);
            String value = paramElement.getText();
            params.put(name, value);
        }
        this.m_jsonRendererSettings = new I_CmsXmlContentHandler.JsonRendererSettings(cls, params);
    }

    protected void initLayouts(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        this.m_useAcacia = this.safeParseBoolean(root.attributeValue(ATTR_USE_ACACIA), true);
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_LAYOUT);
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue("element");
            String widgetClassOrAlias = element.attributeValue(APPINFO_ATTR_WIDGET);
            String configuration = element.attributeValue("configuration");
            String displayStr = element.attributeValue(APPINFO_ATTR_DISPLAY);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(displayStr) && elementName != null) {
                this.addDisplayType(contentDefinition, elementName, I_CmsXmlContentHandler.DisplayType.valueOf(displayStr));
            }
            if (elementName == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(widgetClassOrAlias)) continue;
            this.addWidget(contentDefinition, elementName, widgetClassOrAlias);
            if (configuration == null) continue;
            this.addConfiguration(contentDefinition, elementName, configuration);
        }
    }

    protected void initMappings(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, "mapping");
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue("element");
            String maptoName = element.attributeValue(APPINFO_ATTR_MAPTO);
            String useDefault = element.attributeValue(APPINFO_ATTR_USE_DEFAULT);
            if (elementName == null || maptoName == null) continue;
            this.addMapping(contentDefinition, elementName, maptoName, useDefault);
        }
    }

    protected void initModelFolder(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String master = root.attributeValue(APPINFO_ATTR_URI);
        if (master == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_MODELFOLDER_URI_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_modelFolder = master;
    }

    protected void initNestedFormatters(Element element, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(element, APPINFO_NESTED_FORMATTER);
        while (i.hasNext()) {
            Element handlerElement = i.next();
            String formatterElement = handlerElement.attributeValue("element");
            this.addNestedFormatter(formatterElement, contentDefinition);
        }
    }

    protected void initParameters(Element root) {
        this.m_parameters.clear();
        for (Element paramElement : root.elements(APPINFO_PARAM)) {
            String name = paramElement.attributeValue(APPINFO_ATTR_NAME);
            String value = paramElement.getText();
            this.m_parameters.put(name, value);
        }
    }

    protected void initPreview(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String preview = root.attributeValue(APPINFO_ATTR_URI);
        if (preview == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_PREVIEW_URI_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_previewLocation = preview;
    }

    protected void initRelations(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_RELATION);
        while (i.hasNext()) {
            String type;
            Element element = i.next();
            String elementName = element.attributeValue("element");
            String invalidate = element.attributeValue(APPINFO_ATTR_INVALIDATE);
            if (invalidate != null) {
                invalidate = invalidate.toUpperCase();
            }
            if ((type = element.attributeValue(APPINFO_ATTR_TYPE)) != null) {
                type = type.toLowerCase();
            }
            if (elementName == null) continue;
            this.addCheckRule(contentDefinition, elementName, invalidate, type);
        }
    }

    protected void initResourceBundle(Element root, CmsXmlContentDefinition contentDefinition, boolean single) throws CmsXmlException {
        if (this.m_messageBundleNames == null) {
            this.m_messageBundleNames = new ArrayList<String>(2);
        }
        if (single) {
            String messageBundleName = root.attributeValue(APPINFO_ATTR_NAME);
            if (messageBundleName == null) {
                throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_RESOURCE_BUNDLE_NAME_2", root.getName(), contentDefinition.getSchemaLocation()));
            }
            if (!this.m_messageBundleNames.contains(messageBundleName)) {
                this.m_messageBundleNames.add(messageBundleName);
            }
            CmsResourceBundleLoader.flushBundleCache(messageBundleName, false);
        } else {
            Iterator<Element> propertybundles = CmsXmlGenericWrapper.elementIterator(root, APPINFO_PROPERTYBUNDLE);
            while (propertybundles.hasNext()) {
                Element propBundle = propertybundles.next();
                String propertyBundleName = propBundle.attributeValue(APPINFO_ATTR_NAME);
                if (!this.m_messageBundleNames.contains(propertyBundleName)) {
                    this.m_messageBundleNames.add(propertyBundleName);
                }
                CmsResourceBundleLoader.flushBundleCache(propertyBundleName, false);
            }
            Iterator<Element> xmlbundles = CmsXmlGenericWrapper.elementIterator(root, APPINFO_XMLBUNDLE);
            while (xmlbundles.hasNext()) {
                Element xmlbundle = xmlbundles.next();
                String xmlBundleName = xmlbundle.attributeValue(APPINFO_ATTR_NAME);
                if (!this.m_messageBundleNames.contains(xmlBundleName)) {
                    this.m_messageBundleNames.add(xmlBundleName);
                }
                CmsResourceBundleLoader.flushBundleCache(xmlBundleName, true);
                Iterator<Element> bundles = CmsXmlGenericWrapper.elementIterator(xmlbundle, APPINFO_BUNDLE);
                while (bundles.hasNext()) {
                    Element bundle = bundles.next();
                    String localeStr = bundle.attributeValue(APPINFO_ATTR_LOCALE);
                    Locale locale = CmsStringUtil.isEmptyOrWhitespaceOnly(localeStr) ? null : CmsLocaleManager.getLocale(localeStr);
                    boolean isDefaultLocaleAndNotNull = locale != null && locale.equals(CmsLocaleManager.getDefaultLocale());
                    CmsListResourceBundle xmlBundle = null;
                    Iterator<Element> resources = CmsXmlGenericWrapper.elementIterator(bundle, APPINFO_RESOURCE);
                    while (resources.hasNext()) {
                        Element resource = resources.next();
                        String key = resource.attributeValue(APPINFO_ATTR_KEY);
                        String value = resource.attributeValue(APPINFO_ATTR_VALUE);
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
                            value = resource.getTextTrim();
                        }
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(key) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) continue;
                        if (xmlBundle == null) {
                            xmlBundle = new CmsListResourceBundle();
                        }
                        xmlBundle.addMessage(key.trim(), value.trim());
                    }
                    if (xmlBundle == null) continue;
                    CmsResourceBundleLoader.addBundleToCache(xmlBundleName, locale, xmlBundle);
                    if (!isDefaultLocaleAndNotNull) continue;
                    CmsResourceBundleLoader.addBundleToCache(xmlBundleName, null, xmlBundle);
                }
            }
        }
    }

    protected void initSearchSettings(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String containerPageOnly = root.attributeValue(APPINFO_ATTR_CONTAINER_PAGE_ONLY);
        if (!CmsStringUtil.isEmpty(containerPageOnly)) {
            this.m_containerPageOnly = Boolean.valueOf(containerPageOnly);
        }
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_SEARCHSETTING);
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue("element");
            String searchContent = element.attributeValue(APPINFO_ATTR_SEARCHCONTENT);
            I_CmsXmlContentValue.SearchContentType searchContentType = I_CmsXmlContentValue.SearchContentType.fromString(searchContent);
            if (elementName != null) {
                this.addSearchSetting(contentDefinition, elementName, searchContentType);
            }
            Iterator<Element> it = CmsXmlGenericWrapper.elementIterator(element, APPINFO_SOLR_FIELD);
            while (it.hasNext()) {
                Element solrElement = it.next();
                String localeNames = solrElement.attributeValue(APPINFO_ATTR_LOCALE);
                boolean localized = true;
                if (localeNames != null && (localeNames.equals("none") || localeNames.equals("null") || localeNames.trim().equals(""))) {
                    localized = false;
                }
                List<Object> locales = null;
                if (localized) {
                    locales = OpenCms.getLocaleManager().getAvailableLocales(localeNames);
                    if (localized && (locales == null || locales.isEmpty())) {
                        locales = OpenCms.getLocaleManager().getAvailableLocales();
                    } else if (locales.isEmpty()) {
                        locales.add(CmsLocaleManager.getDefaultLocale());
                    }
                } else {
                    locales = Collections.singletonList(null);
                }
                for (Locale locale : locales) {
                    String sourceField;
                    Object targetField = solrElement.attributeValue(APPINFO_ATTR_TARGET_FIELD);
                    if (localized) {
                        targetField = (String)targetField + "_" + locale.toString();
                    }
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sourceField = solrElement.attributeValue(APPINFO_ATTR_SOURCE_FIELD))) {
                        int lastUnderScore = sourceField.lastIndexOf("_");
                        if (lastUnderScore > 0) {
                            sourceField = sourceField.substring(lastUnderScore);
                        }
                        targetField = (String)targetField + sourceField;
                    }
                    String copyFieldNames = solrElement.attributeValue(APPINFO_ATTR_COPY_FIELDS, "");
                    List<String> copyFields = CmsStringUtil.splitAsList(copyFieldNames, ',');
                    String defaultValue = solrElement.attributeValue("default");
                    CmsSolrField field = new CmsSolrField((String)targetField, copyFields, locale, defaultValue);
                    Iterator<Element> ite = CmsXmlGenericWrapper.elementIterator(solrElement, "mapping");
                    while (ite.hasNext()) {
                        Element mappingElement = ite.next();
                        field.addMapping(this.createSearchFieldMapping(contentDefinition, mappingElement, locale, elementName));
                    }
                    if (field.getMappings() == null || field.getMappings().isEmpty()) {
                        CmsSearchFieldMapping map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ITEM, elementName);
                        if (localized) {
                            map.setLocale(locale);
                        }
                        field.addMapping(map);
                    }
                    Set<I_CmsXmlContentHandler.MappingType> mappingTypes = this.parseSearchMappingTypes(solrElement);
                    for (I_CmsXmlContentHandler.MappingType type : mappingTypes) {
                        this.addSearchField(contentDefinition, field, type);
                    }
                }
            }
        }
    }

    protected void initSettings(Element root, CmsXmlContentDefinition contentDefinition) {
        Iterator<Element> itProperties = CmsXmlGenericWrapper.elementIterator(root, APPINFO_SETTING);
        while (itProperties.hasNext()) {
            Element element = itProperties.next();
            CmsXmlContentProperty setting = new CmsXmlContentProperty(element.attributeValue(APPINFO_ATTR_NAME), element.attributeValue(APPINFO_ATTR_TYPE), element.attributeValue(APPINFO_ATTR_WIDGET), element.attributeValue(APPINFO_ATTR_WIDGET_CONFIG), element.attributeValue(APPINFO_ATTR_RULE_REGEX), element.attributeValue(APPINFO_ATTR_RULE_TYPE), element.attributeValue("default"), element.attributeValue(APPINFO_ATTR_NICE_NAME), element.attributeValue(APPINFO_ATTR_DESCRIPTION), element.attributeValue(APPINFO_ATTR_ERROR), element.attributeValue(APPINFO_ATTR_PREFERFOLDER));
            String name = setting.getName();
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) continue;
            this.m_settings.put(name, setting);
        }
    }

    protected void initSynchronizations(Element root, CmsXmlContentDefinition contentDefinition) {
        ArrayList<Element> elements = new ArrayList<Element>(CmsXmlGenericWrapper.elements(root, APPINFO_SYNCHRONIZATION));
        for (Element element : elements) {
            String elementName = element.attributeValue("element");
            this.m_synchronizations.put(elementName, I_CmsXmlContentHandler.SynchronizationMode.standard);
        }
    }

    protected void initTabs(Element root, CmsXmlContentDefinition contentDefinition) {
        if (Boolean.valueOf(root.attributeValue(APPINFO_ATTR_USEALL, CmsStringUtil.FALSE)).booleanValue()) {
            for (I_CmsXmlSchemaType type : contentDefinition.getTypeSequence()) {
                this.m_tabs.add(new CmsXmlContentTab(type.getName()));
            }
        } else {
            Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_TAB);
            while (i.hasNext()) {
                Element element = i.next();
                String elementName = element.attributeValue("element");
                String collapseValue = element.attributeValue(APPINFO_ATTR_COLLAPSE, CmsStringUtil.TRUE);
                Node descriptionNode = element.selectSingleNode("description/text()");
                String description = null;
                description = descriptionNode != null ? descriptionNode.getText() : element.attributeValue(APPINFO_ATTR_DESCRIPTION);
                String tabName = element.attributeValue(APPINFO_ATTR_NAME, elementName);
                if (elementName == null) continue;
                this.m_tabs.add(new CmsXmlContentTab(elementName, Boolean.valueOf(collapseValue), tabName, description));
            }
            I_CmsXmlSchemaType type = contentDefinition.getTypeSequence().get(0);
            CmsXmlContentTab tab = new CmsXmlContentTab(type.getName());
            if (!this.m_tabs.contains(tab)) {
                this.m_tabs.add(0, tab);
            }
        }
    }

    protected void initTemplates(Element root, CmsXmlContentDefinition contentDefinition) {
        String strEnabledByDefault = root.attributeValue(ATTR_ENABLED_BY_DEFAULT);
        this.m_allowedTemplates.setDefaultMembership(this.safeParseBoolean(strEnabledByDefault, true));
        List elements = root.selectNodes(APPINFO_TEMPLATE);
        for (Node elem : elements) {
            boolean enabled = this.safeParseBoolean(((Element)elem).attributeValue(ATTR_ENABLED), true);
            String templateName = elem.getText().trim();
            this.m_allowedTemplates.setContains(templateName, enabled);
        }
        this.m_allowedTemplates.freeze();
    }

    protected void initValidationRules(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        ArrayList<Element> elements = new ArrayList<Element>(CmsXmlGenericWrapper.elements(root, APPINFO_RULE));
        elements.addAll(CmsXmlGenericWrapper.elements(root, APPINFO_VALIDATIONRULE));
        for (Element element : elements) {
            String elementName = element.attributeValue("element");
            String regex = element.attributeValue(APPINFO_ATTR_REGEX);
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            if (type != null) {
                type = type.toLowerCase();
            }
            String message = element.attributeValue(APPINFO_ATTR_MESSAGE);
            if (elementName == null || regex == null) continue;
            this.addValidationRule(contentDefinition, elementName, regex, message, APPINFO_ATTR_TYPE_WARNING.equals(type));
        }
    }

    protected void initVisibilities(Element root, CmsXmlContentDefinition contentDefinition) {
        this.m_visibilityConfigurations = new HashMap<String, VisibilityConfiguration>();
        String mainHandlerClassName = root.attributeValue(APPINFO_ATTR_CLASS);
        I_CmsXmlContentVisibilityHandler mainHandler = this;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(mainHandlerClassName)) {
            try {
                Class<?> handlerClass = Class.forName(mainHandlerClassName);
                mainHandler = (I_CmsXmlContentVisibilityHandler)handlerClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<Element> elements = new ArrayList<Element>(CmsXmlGenericWrapper.elements(root, APPINFO_VISIBILITY));
        for (Element element : elements) {
            try {
                String elementName = element.attributeValue("element");
                String handlerClassName = element.attributeValue(APPINFO_ATTR_CLASS);
                String params = element.attributeValue(APPINFO_ATTR_PARAMS);
                I_CmsXmlContentVisibilityHandler handler = null;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(handlerClassName)) {
                    Class<?> handlerClass = Class.forName(handlerClassName);
                    handler = (I_CmsXmlContentVisibilityHandler)handlerClass.newInstance();
                } else {
                    handler = mainHandler;
                }
                this.m_visibilityConfigurations.put(elementName, new VisibilityConfiguration(handler, params));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isInvalidateParent(String xpath) {
        if (!CmsXmlUtils.isDeepXpath(xpath)) {
            return false;
        }
        Boolean isInvalidateParent = null;
        isInvalidateParent = this.m_relationChecks.get(xpath);
        if (isInvalidateParent == null) {
            String path = CmsXmlUtils.removeXpath(xpath);
            isInvalidateParent = this.m_relationChecks.get(path);
        }
        if (isInvalidateParent == null) {
            return false;
        }
        return isInvalidateParent;
    }

    protected String key(String keyName, Locale locale) {
        CmsMessages messages = this.getMessages(locale);
        if (messages != null) {
            return messages.key(keyName);
        }
        return CmsMessages.formatUnknownKey(keyName);
    }

    protected Set<I_CmsXmlContentHandler.MappingType> parseSearchMappingTypes(Element solrElement) {
        HashSet<I_CmsXmlContentHandler.MappingType> result = new HashSet<I_CmsXmlContentHandler.MappingType>();
        String mappingTypes = solrElement.attributeValue(APPINFO_ATTR_ADD_TO);
        if (mappingTypes != null) {
            String[] types = mappingTypes.split(PRINCIPAL_LIST_SEPARATOR);
            for (int i = 0; i < types.length; ++i) {
                String type = types[i].trim();
                if (APPINFO_VALUE_ADD_TO_PAGE.equals(type)) {
                    result.add(I_CmsXmlContentHandler.MappingType.PAGE);
                    continue;
                }
                if (!"element".equals(type)) continue;
                result.add(I_CmsXmlContentHandler.MappingType.ELEMENT);
            }
        } else {
            result.add(I_CmsXmlContentHandler.MappingType.ELEMENT);
        }
        return result;
    }

    protected void removeEmptyMappings(CmsObject cms, CmsFile file, CmsXmlContent content) throws CmsException {
        List<CmsResource> siblings = null;
        CmsObject rootCms = null;
        for (Map.Entry<String, List<String>> e : this.m_elementMappings.entrySet()) {
            String path = e.getKey();
            List<String> mappings = e.getValue();
            if (mappings == null) continue;
            if (siblings == null || rootCms == null) {
                rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("/");
                siblings = rootCms.readSiblings(content.getFile().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
            for (int v = mappings.size() - 1; v >= 0; --v) {
                Locale locale;
                String filename;
                int i;
                String mapping = mappings.get(v);
                if (mapping.startsWith("propertyList:") || mapping.startsWith("property:")) {
                    for (i = 0; i < siblings.size(); ++i) {
                        String property;
                        filename = siblings.get(i).getRootPath();
                        locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                        if (!content.hasLocale(locale) || content.hasValue(path, locale) || !mapping.startsWith("propertyList:") && !mapping.startsWith("property:")) continue;
                        boolean shared = false;
                        if (mapping.startsWith("propertyList:individual:")) {
                            property = mapping.substring("propertyList:individual:".length());
                        } else if (mapping.startsWith("propertyList:shared:")) {
                            property = mapping.substring("propertyList:shared:".length());
                            shared = true;
                        } else if (mapping.startsWith("propertyList:")) {
                            property = mapping.substring("propertyList:".length());
                        } else if (mapping.startsWith("property:shared:")) {
                            property = mapping.substring("property:shared:".length());
                            shared = true;
                        } else {
                            property = mapping.startsWith("property:individual:") ? mapping.substring("property:individual:".length()) : mapping.substring("property:".length());
                        }
                        rootCms.writePropertyObject(filename, new CmsProperty(property, "", shared ? "" : null));
                    }
                    continue;
                }
                if (!mapping.startsWith("permission:")) continue;
                for (i = 0; i < siblings.size(); ++i) {
                    filename = siblings.get(i).getRootPath();
                    locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                    if (!content.hasLocale(locale) || content.hasValue(path, locale)) continue;
                    List<CmsAccessControlEntry> aces = rootCms.getAccessControlEntries(filename, false);
                    for (CmsAccessControlEntry ace : aces) {
                        if (ace.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                            rootCms.rmacc(filename, "ALL_OTHERS", CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString());
                            continue;
                        }
                        I_CmsPrincipal principal = CmsPrincipal.readPrincipal(rootCms, ace.getPrincipal());
                        if (principal.isGroup()) {
                            rootCms.rmacc(filename, "GROUP", principal.getName());
                            continue;
                        }
                        if (!principal.isUser()) continue;
                        rootCms.rmacc(filename, "USER", principal.getName());
                    }
                }
            }
        }
    }

    protected void resolveDefaultMappings(CmsObject cms, CmsFile file, CmsXmlContent content) throws CmsException {
        for (Map.Entry<String, List<String>> e : this.m_elementMappings.entrySet()) {
            String path = e.getKey();
            List<String> mappings = e.getValue();
            if (mappings == null) continue;
            for (int v = mappings.size() - 1; v >= 0; --v) {
                String mapping = mappings.get(v);
                if (!this.isMappingUsingDefault(path, mapping)) continue;
                for (Locale locale : content.getLocales()) {
                    String defaultValue;
                    if (content.hasValue(path, locale) || (defaultValue = this.getDefault(cms, file, null, path, locale)) == null) continue;
                    this.resolveMapping(cms, content, path, true, 0, locale, defaultValue);
                }
            }
        }
    }

    protected void validateAppinfoElement(Element appinfoElement) throws CmsXmlException {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement(APPINFO_APPINFO);
        root.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        root.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, APPINFO_SCHEMA_SYSTEM_ID);
        root.appendContent((Branch)appinfoElement);
        CmsXmlUtils.validateXmlStructure(doc, "UTF-8", new CmsXmlEntityResolver(null));
    }

    protected CmsXmlContentErrorHandler validateCategories(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (!value.isSimpleType()) {
            return errorHandler;
        }
        I_CmsWidget widget = null;
        widget = CmsWidgetUtil.collectWidgetInfo(cms, value).getWidget();
        if (!(widget instanceof CmsCategoryWidget)) {
            return errorHandler;
        }
        String stringValue = value.getStringValue(cms);
        if (stringValue.isEmpty()) {
            return errorHandler;
        }
        try {
            String[] values = stringValue.split(PRINCIPAL_LIST_SEPARATOR);
            for (int i = 0; i < values.length; ++i) {
                String val = values[i];
                String catPath = CmsCategoryService.getInstance().getCategory(cms, val).getPath();
                String refPath = this.getReferencePath(cms, value);
                CmsCategoryService.getInstance().readCategory(cms, catPath, refPath);
                if (!((CmsCategoryWidget)widget).isOnlyLeafs() || CmsCategoryService.getInstance().readCategories(cms, catPath, false, refPath).isEmpty()) continue;
                errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_CATEGORY_CHECK_NOLEAF_ERROR_0"));
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_CATEGORY_CHECK_EMPTY_ERROR_0"));
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            errorHandler.addError(value, e.getLocalizedMessage());
        }
        return errorHandler;
    }

    protected boolean validateLink(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (value == null || !(value instanceof CmsXmlVfsFileValue) && !(value instanceof CmsXmlVarLinkValue)) {
            return false;
        }
        CmsLink link = null;
        if (value instanceof CmsXmlVfsFileValue) {
            link = ((CmsXmlVfsFileValue)value).getLink(cms);
        } else if (value instanceof CmsXmlVarLinkValue) {
            link = ((CmsXmlVarLinkValue)value).getLink(cms);
        }
        if (link == null || !link.isInternal()) {
            return false;
        }
        try {
            String sitePath = cms.getRequestContext().removeSiteRoot(link.getTarget());
            if (CmsStaticResourceHandler.isStaticResourceUri(sitePath)) {
                return false;
            }
            CmsResource res = null;
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(link.getTarget());
            if (site != null) {
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                res = rootCms.readResource(link.getTarget(), CmsResourceFilter.IGNORE_EXPIRATION);
            } else {
                res = cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            if (res != null) {
                long time = System.currentTimeMillis();
                if (!res.isReleased(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_NOT_RELEASED_0"));
                    }
                    return true;
                }
                if (res.isExpired(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_EXPIRED_0"));
                    }
                    return true;
                }
            }
        }
        catch (CmsException e) {
            if (errorHandler != null) {
                String message = this.getErrorMessage(cms, value.getName());
                if (message == null) {
                    message = Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_ERROR_0");
                }
                errorHandler.addError(value, message);
            }
            return true;
        }
        return false;
    }

    protected CmsXmlContentErrorHandler validateValue(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler, Map<String, String> rules, boolean isWarning) {
        boolean matches;
        String stringToBeMatched;
        String valueStr;
        if (this.validateLink(cms, value, errorHandler)) {
            return errorHandler;
        }
        if (CmsWidgetUtil.collectWidgetInfo(cms, value).getWidget() instanceof CmsDisplayWidget) {
            return errorHandler;
        }
        try {
            valueStr = value.getStringValue(cms);
        }
        catch (Exception e) {
            errorHandler.addError(value, e.getMessage());
            return errorHandler;
        }
        String regex = rules.get(value.getName());
        if (regex == null) {
            return this.validateValue(cms, value, valueStr, errorHandler, isWarning);
        }
        boolean matchSign = true;
        if (regex.charAt(0) == '!') {
            matchSign = false;
            regex = regex.substring(1);
        }
        if ((stringToBeMatched = valueStr) == null) {
            stringToBeMatched = "";
        }
        try {
            matches = Pattern.matches(regex, stringToBeMatched);
        }
        catch (StackOverflowError | PatternSyntaxException e) {
            String localizedMessage = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "";
            String ticket = String.valueOf(System.currentTimeMillis());
            Throwable trace = e;
            if (e instanceof StackOverflowError) {
                String stackOverflowInfoMessage = "StackOverflowError thrown on pattern matching during xml content validation. (Cause will be also logged in DEBUG level.)\nNote 1.- Possible cause: The Java regex engine uses recursive method calls to implement backtracking. When a repetition inside a regular expression contains multiple paths (i.e. the body of the repetition contains an alternation (|), an optional element or another repetition), trying to match the regular expression can cause a stack overflow on large inputs. This does not happen when using a possessive quantifier (such as *+ instead of *) or when using a character class inside a repetition (e.g. [ab]* instead of (a|b)*).\nNote 2.- On StackOverflowError, the size of the stacktraces could be limited by the JVM  and we could be missing information to identify the origin of the problem. To help in this case, we create a new exception close to this origin. Alternatively, you can increase the depth of the stack trace (for instance, '-XX:MaxJavaStackTraceDepth=1000000') to identify it";
                trace = LOG.isDebugEnabled() ? new Exception("StackOverflowError thrown on pattern matching during xml content validation. (Cause will be also logged in DEBUG level.)\nNote 1.- Possible cause: The Java regex engine uses recursive method calls to implement backtracking. When a repetition inside a regular expression contains multiple paths (i.e. the body of the repetition contains an alternation (|), an optional element or another repetition), trying to match the regular expression can cause a stack overflow on large inputs. This does not happen when using a possessive quantifier (such as *+ instead of *) or when using a character class inside a repetition (e.g. [ab]* instead of (a|b)*).\nNote 2.- On StackOverflowError, the size of the stacktraces could be limited by the JVM  and we could be missing information to identify the origin of the problem. To help in this case, we create a new exception close to this origin. Alternatively, you can increase the depth of the stack trace (for instance, '-XX:MaxJavaStackTraceDepth=1000000') to identify it", e) : new Exception("StackOverflowError thrown on pattern matching during xml content validation. (Cause will be also logged in DEBUG level.)\nNote 1.- Possible cause: The Java regex engine uses recursive method calls to implement backtracking. When a repetition inside a regular expression contains multiple paths (i.e. the body of the repetition contains an alternation (|), an optional element or another repetition), trying to match the regular expression can cause a stack overflow on large inputs. This does not happen when using a possessive quantifier (such as *+ instead of *) or when using a character class inside a repetition (e.g. [ab]* instead of (a|b)*).\nNote 2.- On StackOverflowError, the size of the stacktraces could be limited by the JVM  and we could be missing information to identify the origin of the problem. To help in this case, we create a new exception close to this origin. Alternatively, you can increase the depth of the stack trace (for instance, '-XX:MaxJavaStackTraceDepth=1000000') to identify it");
                errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_EDITOR_XMLCONTENT_CANNOT_VALIDATE_ERROR_3", ticket, regex, stringToBeMatched));
            } else {
                errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_EDITOR_XMLCONTENT_INVALID_RULE_3", ticket, regex, localizedMessage));
            }
            LOG.warn((Object)("Ticket " + ticket + " - " + localizedMessage + "\n Regex='" + (matchSign ? "" : "!") + regex + "'\n Path='" + value.getPath() + "'\n Input='" + stringToBeMatched + "'"), trace);
            return errorHandler;
        }
        if (matchSign != matches) {
            String message = this.getValidationMessage(cms, value, regex, valueStr, matchSign, isWarning);
            if (isWarning) {
                errorHandler.addWarning(value, message);
            } else {
                errorHandler.addError(value, message);
                return errorHandler;
            }
        }
        return this.validateValue(cms, value, valueStr, errorHandler, isWarning);
    }

    protected CmsXmlContentErrorHandler validateValue(CmsObject cms, I_CmsXmlContentValue value, String valueStr, CmsXmlContentErrorHandler errorHandler, boolean isWarning) {
        if (isWarning) {
            return errorHandler;
        }
        String message = null;
        if (value instanceof I_CmsXmlValidateWithMessage) {
            CmsMessageContainer messageContainer = ((I_CmsXmlValidateWithMessage)((Object)value)).validateWithMessage(valueStr);
            if (null != messageContainer) {
                message = messageContainer.key(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
            }
        } else if (!value.validateValue(valueStr)) {
            message = this.getValidationMessage(cms, value, value.getTypeName(), valueStr, true, false);
        }
        if (null != message) {
            errorHandler.addError(value, message);
        }
        return errorHandler;
    }

    protected CmsFile writeCategories(CmsObject cms, CmsFile file, CmsXmlContent content) throws CmsException {
        boolean modified;
        block17: {
            boolean hasCategoryWidget;
            if (CmsWorkplace.isTemporaryFile(file)) {
                if (CmsResource.isTemporaryFileName(file.getRootPath())) {
                    String originalFileName = CmsResource.getFolderPath(file.getRootPath()) + CmsResource.getName(file.getRootPath()).substring("~".length());
                    if (cms.existsResource(cms.getRequestContext().removeSiteRoot(originalFileName))) {
                        return file;
                    }
                } else {
                    return file;
                }
            }
            if (!(hasCategoryWidget = this.hasCategoryWidget())) {
                return file;
            }
            modified = false;
            CmsObject tmpCms = OpenCms.initCmsObject(cms);
            tmpCms.getRequestContext().setSiteRoot("");
            try {
                List<CmsResource> listsib = tmpCms.readSiblings(file.getRootPath(), CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = listsib.get(i);
                    List<Locale> locales = this.getLocalesForResource(tmpCms, resource.getRootPath());
                    Locale locale = locales.get(0);
                    for (Locale l : locales) {
                        if (!content.hasLocale(l)) continue;
                        locale = l;
                        break;
                    }
                    boolean clearedCategories = false;
                    CmsXmlContentWidgetVisitor widgetCollector = new CmsXmlContentWidgetVisitor(cms, locale);
                    content.visitAllValuesWith(widgetCollector);
                    for (Map.Entry<String, I_CmsXmlContentValue> entry : widgetCollector.getValues().entrySet()) {
                        String stringValue;
                        String xpath = entry.getKey();
                        I_CmsWidget widget = widgetCollector.getWidgets().get(xpath);
                        I_CmsXmlContentValue value = entry.getValue();
                        if (!(widget instanceof CmsCategoryWidget) || value.getTypeName().equals("OpenCmsDynamicCategory")) continue;
                        if (!clearedCategories) {
                            CmsCategoryService.getInstance().clearCategoriesForResource(tmpCms, resource.getRootPath());
                            clearedCategories = true;
                        }
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(stringValue = value.getStringValue(tmpCms))) continue;
                        try {
                            String[] catRootPathes;
                            for (String catRootPath : catRootPathes = stringValue.split(PRINCIPAL_LIST_SEPARATOR)) {
                                CmsCategory cat = CmsCategoryService.getInstance().getCategory(tmpCms, catRootPath);
                                CmsCategoryService.getInstance().addResourceToCategory(tmpCms, resource.getRootPath(), cat.getPath());
                            }
                        }
                        catch (CmsVfsResourceNotFoundException e) {
                            try {
                                content.removeValue(value.getName(), value.getLocale(), value.getIndex());
                                modified = true;
                            }
                            catch (CmsRuntimeException ex) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)ex.getLocalizedMessage(), (Throwable)ex);
                            }
                        }
                    }
                }
            }
            catch (CmsException ex) {
                if (!LOG.isErrorEnabled()) break block17;
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        if (modified) {
            file = content.correctXmlStructure(cms);
            content.setFile(file);
        }
        return file;
    }

    private void combineSynchronizations(CmsXmlContentDefinition contentDefinition, String path, LinkedHashMap<String, I_CmsXmlContentHandler.SynchronizationMode> combinedSynchronizations) {
        for (String name : contentDefinition.getSchemaTypes()) {
            I_CmsXmlSchemaType type = contentDefinition.getSchemaType(name);
            if (!(type instanceof CmsXmlNestedContentDefinition)) continue;
            CmsXmlContentDefinition nestedDef = ((CmsXmlNestedContentDefinition)type).getNestedContentDefinition();
            String subPath = "".equals(path) ? name : path + "/" + name;
            this.combineSynchronizations(nestedDef, subPath, combinedSynchronizations);
        }
        CmsSynchronizationSpec synchs = contentDefinition.getContentHandler().getSynchronizations(false);
        for (Map.Entry<String, I_CmsXmlContentHandler.SynchronizationMode> entry : synchs.asMap().entrySet()) {
            String subPath = "".equals(path) ? entry.getKey() : path + "/" + entry.getKey();
            combinedSynchronizations.put(subPath, entry.getValue());
        }
    }

    private I_CmsSearchFieldMapping createSearchFieldMapping(CmsXmlContentDefinition contentDefinition, Element element, Locale locale, String defaultParamValue) throws CmsXmlException {
        I_CmsSearchFieldMapping fieldMapping = null;
        String typeAsString = element.attributeValue(APPINFO_ATTR_TYPE);
        CmsSearchFieldMappingType type = CmsSearchFieldMappingType.valueOf(typeAsString);
        if (type == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XML_SCHEMA_MAPPING_TYPE_NOT_EXIST_3", typeAsString, contentDefinition.getTypeName(), contentDefinition.getSchemaLocation()));
        }
        String mappingClass = element.attributeValue(APPINFO_ATTR_CLASS);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(mappingClass)) {
            try {
                fieldMapping = (I_CmsSearchFieldMapping)Class.forName(mappingClass).newInstance();
            }
            catch (Exception e) {
                throw new CmsXmlException(Messages.get().container("ERR_XML_SCHEMA_MAPPING_CLASS_NOT_EXIST_3", mappingClass, contentDefinition.getTypeName(), contentDefinition.getSchemaLocation()));
            }
        } else {
            fieldMapping = new CmsSearchFieldMapping();
        }
        fieldMapping.setType(type);
        String paramValue = element.getStringValue();
        if (paramValue == null || paramValue.isEmpty()) {
            paramValue = defaultParamValue;
        }
        fieldMapping.setParam(paramValue);
        fieldMapping.setLocale(locale);
        fieldMapping.setDefaultValue(element.attributeValue("default"));
        return fieldMapping;
    }

    private String getErrorMessage(CmsObject cms, String element) {
        String configuredMessage = this.m_validationErrorMessages.get(element);
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setMessages(this.getMessages(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)));
        return resolver.resolveMacros(configuredMessage);
    }

    private String getMappingSource(String target) {
        for (Map.Entry<String, List<String>> entry : this.m_elementMappings.entrySet()) {
            if (!entry.getValue().contains(target)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String getSubPath(String[] pathElements, int begin) {
        Object result = "";
        for (int i = begin; i < pathElements.length; ++i) {
            result = (String)result + pathElements[i] + "/";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    private boolean hasCategoryType() {
        try {
            for (I_CmsXmlSchemaType typeEntry : this.m_contentDefinition.getTypeSequence()) {
                String typeName = typeEntry.getTypeName();
                I_CmsXmlSchemaType type = OpenCms.getXmlContentTypeManager().getContentType(typeName);
                if (!(type instanceof CmsXmlCategoryValue)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean hasCategoryWidget() {
        if (this.m_hasCategoryWidget == null) {
            boolean result = false;
            for (Map.Entry<String, String> widgetEntry : this.m_widgetNames.entrySet()) {
                String widgetName = widgetEntry.getValue();
                I_CmsWidget widget = OpenCms.getXmlContentTypeManager().getWidget(widgetName);
                if (widget == null || !(widget instanceof CmsCategoryWidget)) continue;
                result = true;
                break;
            }
            result = result || this.hasCategoryType();
            this.m_hasCategoryWidget = result;
            return result;
        }
        return this.m_hasCategoryWidget;
    }

    private void initGeoMappingEntries(Element element) {
        try {
            for (Element child : element.elements()) {
                CmsGeoMappingConfiguration.EntryType type = CmsGeoMappingConfiguration.EntryType.valueOf(child.getName());
                String value = child.getText();
                CmsGeoMappingConfiguration.Entry entry = new CmsGeoMappingConfiguration.Entry(type, value.trim());
                this.m_geomappingEntries.add(entry);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void initMessageKeyHandler(Element element) {
        String className = element.attributeValue(APPINFO_ATTR_CLASS);
        String configuration = element.attributeValue("configuration");
        try {
            Object messageKeyHandler = Class.forName(className).getConstructor(String.class).newInstance(configuration);
            this.m_messageKeyHandler = (CmsMultiMessages.I_KeyFallbackHandler)messageKeyHandler;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private boolean isMappingUsingDefault(String path, String mapping) {
        String key = path + ":" + mapping;
        return this.m_mappingsUsingDefault.contains(key);
    }

    private void resolveMapping(CmsObject cms, CmsXmlContent content, String valuePath, boolean valueIsSimple, int valueIndex, Locale valueLocale, String originalStringValue) throws CmsException {
        CmsLock lock;
        CmsObject rootCms = this.createRootCms(cms);
        CmsFile file = content.getFile();
        if (!valueIsSimple) {
            return;
        }
        List<String> mappings = this.getMappings(valuePath);
        if (mappings.size() == 0) {
            return;
        }
        List<CmsResource> siblings = rootCms.readSiblings(content.getFile().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
        HashSet<CmsResource> urlNameMappingResources = new HashSet<CmsResource>();
        boolean mapToUrlName = false;
        urlNameMappingResources.add(content.getFile());
        CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(rootCms, content, valueLocale);
        resolver.setKeepEmptyMacros(true);
        String stringValue = resolver.resolveMacros(originalStringValue);
        CmsMappingResolutionContext mappingContext = (CmsMappingResolutionContext)cms.getRequestContext().getAttribute(ATTR_MAPPING_RESOLUTION_CONTEXT);
        block10: for (String mapping : mappings) {
            if (!CmsStringUtil.isNotEmpty(mapping)) continue;
            if (mapping.startsWith("attribute:")) {
                String attribute = mapping.substring("attribute:".length());
                switch (ATTRIBUTES.indexOf(attribute)) {
                    case 0: {
                        long date = 0L;
                        try {
                            date = Long.valueOf(stringValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (date == 0L) {
                            date = 0L;
                        }
                        mappingContext.putReleaseDate(valueLocale, date);
                        continue block10;
                    }
                    case 1: {
                        long date = 0L;
                        try {
                            date = Long.valueOf(stringValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (date == 0L) {
                            date = Long.MAX_VALUE;
                        }
                        mappingContext.putExpirationDate(valueLocale, date);
                        continue block10;
                    }
                }
                continue;
            }
            for (int i = siblings.size() - 1; i >= 0; --i) {
                String property;
                Locale locale;
                String filename = siblings.get(i).getRootPath();
                if (mapping.startsWith("urlName")) {
                    mapToUrlName = true;
                }
                if (!(locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename)).equals(valueLocale)) continue;
                CmsLock lock2 = rootCms.getLock(filename);
                if (lock2.isUnlocked()) {
                    rootCms.lockResource(filename);
                } else if (!lock2.isDirectlyOwnedInProjectBy(rootCms)) {
                    rootCms.changeLock(filename);
                }
                if (mapping.startsWith("permission:") && valueIndex == 0) {
                    String permissionMappings;
                    String mainMapping = permissionMappings = mapping.substring("permission:".length());
                    Map<Object, Object> permissionsToSet = new HashMap();
                    int sepIndex = permissionMappings.indexOf(124);
                    if (sepIndex != -1) {
                        mainMapping = permissionMappings.substring(0, sepIndex);
                        permissionMappings = permissionMappings.substring(sepIndex + 1);
                        permissionsToSet = CmsStringUtil.splitAsMap(permissionMappings, "|", ":");
                    }
                    String principalType = "GROUP";
                    Object permissionString = mainMapping;
                    sepIndex = mainMapping.indexOf(58);
                    if (sepIndex != -1) {
                        principalType = mainMapping.substring(0, sepIndex);
                        permissionString = mainMapping.substring(sepIndex + 1);
                    }
                    if (((String)permissionString).toLowerCase().indexOf(111) == -1) {
                        permissionString = (String)permissionString + "+o";
                    }
                    List<CmsAccessControlEntry> aces = rootCms.getAccessControlEntries(filename, false);
                    for (CmsAccessControlEntry cmsAccessControlEntry : aces) {
                        if (cmsAccessControlEntry.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                            rootCms.rmacc(filename, "ALL_OTHERS", CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString());
                            continue;
                        }
                        I_CmsPrincipal principal = CmsPrincipal.readPrincipal(rootCms, cmsAccessControlEntry.getPrincipal());
                        if (principal.isGroup()) {
                            rootCms.rmacc(filename, "GROUP", principal.getName());
                            continue;
                        }
                        if (!principal.isUser()) continue;
                        rootCms.rmacc(filename, "USER", principal.getName());
                    }
                    for (Map.Entry entry : permissionsToSet.entrySet()) {
                        sepIndex = ((String)entry.getKey()).indexOf(46);
                        if (sepIndex == -1) continue;
                        String type = ((String)entry.getKey()).substring(0, sepIndex);
                        String name = ((String)entry.getKey()).substring(sepIndex + 1);
                        Object permissions = (String)entry.getValue();
                        if (((String)permissions).toLowerCase().indexOf(111) == -1) {
                            permissions = (String)permissions + "+o";
                        }
                        try {
                            rootCms.chacc(filename, type, name, (String)permissions);
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    TreeSet<String> allPrincipals = new TreeSet<String>();
                    String string = CmsXmlUtils.removeXpathIndex(valuePath);
                    List<I_CmsXmlContentValue> values = content.getValues(string, valueLocale);
                    for (I_CmsXmlContentValue val : values) {
                        String principalName = val.getStringValue(rootCms);
                        List<String> principalNames = CmsStringUtil.splitAsList(principalName, PRINCIPAL_LIST_SEPARATOR);
                        for (String principal : principalNames) {
                            allPrincipals.add(principal);
                        }
                    }
                    for (String principal : allPrincipals) {
                        rootCms.chacc(filename, principalType, principal, (String)permissionString);
                    }
                    i = 0;
                    continue;
                }
                if (mapping.startsWith("propertyList:") && valueIndex == 0) {
                    int prefixLength;
                    boolean mapToShared;
                    if (mapping.startsWith("propertyList:shared:")) {
                        mapToShared = true;
                        prefixLength = "propertyList:shared:".length();
                    } else if (mapping.startsWith("propertyList:individual:")) {
                        mapToShared = false;
                        prefixLength = "propertyList:individual:".length();
                    } else {
                        mapToShared = false;
                        prefixLength = "propertyList:".length();
                    }
                    property = mapping.substring(prefixLength);
                    String path = CmsXmlUtils.removeXpathIndex(valuePath);
                    List<I_CmsXmlContentValue> values = content.getValues(path, valueLocale);
                    Iterator<I_CmsXmlContentValue> j = values.iterator();
                    StringBuffer result = new StringBuffer(values.size() * 64);
                    while (j.hasNext()) {
                        I_CmsXmlContentValue val = j.next();
                        result.append(val.getStringValue(rootCms));
                        if (!j.hasNext()) continue;
                        result.append('|');
                    }
                    CmsProperty p = mapToShared ? new CmsProperty(property, null, result.toString()) : new CmsProperty(property, result.toString(), null);
                    rootCms.writePropertyObject(filename, p);
                    if (!mapToShared) continue;
                    i = 0;
                    continue;
                }
                if (mapping.startsWith("property:")) {
                    int prefixLength;
                    boolean mapToShared;
                    if (mapping.startsWith("property:shared:")) {
                        mapToShared = true;
                        prefixLength = "property:shared:".length();
                    } else if (mapping.startsWith("property:individual:")) {
                        mapToShared = false;
                        prefixLength = "property:individual:".length();
                    } else {
                        mapToShared = false;
                        prefixLength = "property:".length();
                    }
                    property = mapping.substring(prefixLength);
                    CmsProperty p = mapToShared ? new CmsProperty(property, null, stringValue) : new CmsProperty(property, stringValue, null);
                    rootCms.writePropertyObject(filename, p);
                    if (!mapToShared) continue;
                    i = 0;
                    continue;
                }
                if (!mapping.startsWith("urlName")) continue;
                urlNameMappingResources.add(siblings.get(i));
            }
        }
        if (mapToUrlName) {
            for (CmsResource resourceForUrlNameMapping : urlNameMappingResources) {
                String mappedName;
                if (CmsResource.isTemporaryFileName(resourceForUrlNameMapping.getRootPath()) || CmsStringUtil.isEmptyOrWhitespaceOnly(mappedName = stringValue)) continue;
                mappedName = mappedName.trim();
                mappingContext.addUrlNameMapping(mappedName, valueLocale, resourceForUrlNameMapping.getStructureId());
            }
        }
        if ((lock = rootCms.getLock(file)).isUnlocked()) {
            rootCms.lockResource(file.getRootPath());
        } else if (!lock.isExclusiveOwnedBy(rootCms.getRequestContext().getCurrentUser())) {
            rootCms.changeLock(file.getRootPath());
        }
    }

    private boolean safeParseBoolean(String text, boolean defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(text);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    static {
        byte[] appinfoSchema;
        byte[] appinfoSchemaTypes;
        indexesNotSetOrOne = new HashSet<String>(Arrays.asList("", "[1]"));
        APPINFO_DEFAULTWIDGET = "defaultwidget";
        APPINFO_FIELD_SETTINGS = "FieldSettings";
        APPINFO_JSON_RENDERER = "jsonrenderer";
        LOG = CmsLog.getLog(CmsDefaultXmlContentHandler.class);
        try {
            appinfoSchemaTypes = CmsFileUtil.readFile(APPINFO_SCHEMA_FILE_TYPES);
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", APPINFO_SCHEMA_FILE_TYPES), (Throwable)e);
        }
        CmsXmlEntityResolver.cacheSystemId(APPINFO_SCHEMA_TYPES_SYSTEM_ID, appinfoSchemaTypes);
        try {
            appinfoSchema = CmsFileUtil.readFile(APPINFO_SCHEMA_FILE);
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", APPINFO_SCHEMA_FILE), (Throwable)e);
        }
        CmsXmlEntityResolver.cacheSystemId(APPINFO_SCHEMA_SYSTEM_ID, appinfoSchema);
    }

    public static enum InvalidRelationAction {
        removeParent,
        removeSelf;

    }

    private class MappingInfo {
        private String m_source;
        private String m_target;

        public MappingInfo(String source, String target) {
            this.m_source = source;
            this.m_target = target;
        }

        public boolean canBeUsedForReverseAvailabilityMapping() {
            return this.exists() && !CmsDefaultXmlContentHandler.this.isMappingUsingDefault(this.m_source, this.m_target) && this.checkIndexesNotSetOrOne(this.m_source);
        }

        public boolean exists() {
            return this.m_source != null && this.m_target != null;
        }

        public String getSource() {
            return this.m_source;
        }

        public String getTarget() {
            return this.m_target;
        }

        private boolean checkIndexesNotSetOrOne(String xpath) {
            return CmsXmlUtils.splitXpath(xpath).stream().allMatch(component -> indexesNotSetOrOne.contains(CmsXmlUtils.getXpathIndex(component)));
        }
    }

    protected static class VisibilityConfiguration {
        private I_CmsXmlContentVisibilityHandler m_handler;
        private String m_params;

        protected VisibilityConfiguration(I_CmsXmlContentVisibilityHandler handler, String params) {
            this.m_handler = handler;
            this.m_params = params;
        }

        public I_CmsXmlContentVisibilityHandler getHandler() {
            return this.m_handler;
        }

        public String getParams() {
            return this.m_params;
        }
    }

    static enum FieldSettingElems {
        Class,
        DefaultResolveMacros,
        Display,
        FieldVisibility,
        IfInvalidRelation,
        Invalidate,
        Mapping,
        MapTo,
        NestedFormatter,
        Params,
        Relation,
        Search,
        Synchronization,
        Type,
        UseDefault,
        Visibility;

    }

    static interface I_Callback {
        public void accept(Element var1) throws CmsXmlException;
    }
}

