/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.Iterator;
import org.opencms.loader.I_CmsFileNameGenerator;

public class CmsNumberSuffixNameSequence
implements Iterator<String> {
    private String m_baseName;
    private int m_counter;
    private String m_prefix;
    private String m_suffix;

    public CmsNumberSuffixNameSequence(String str, boolean splitExtension) {
        int dot;
        this.m_baseName = str;
        if (splitExtension && (dot = this.m_baseName.lastIndexOf(".")) > 0) {
            this.m_prefix = this.m_baseName.substring(0, dot);
            this.m_suffix = this.m_baseName.substring(dot);
        }
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String next() {
        Object result = this.m_baseName;
        if (this.m_counter > 0) {
            String numberSuffix = "-" + I_CmsFileNameGenerator.NUMBER_FORMAT.sprintf(this.m_counter);
            result = this.m_prefix == null ? this.m_baseName + numberSuffix : this.m_prefix + numberSuffix + this.m_suffix;
        }
        ++this.m_counter;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

