/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentValueSequence {
    private CmsXmlContent m_content;
    private boolean m_isChoiceSequence;
    private Locale m_locale;
    private int m_maxOccurs;
    private int m_minOccurs;
    private String m_path;
    private List<I_CmsXmlContentValue> m_values;

    public CmsXmlContentValueSequence(String path, Locale locale, CmsXmlContent content) {
        this.m_locale = locale;
        this.m_content = content;
        this.m_path = CmsXmlUtils.removeXpathIndex(path);
        I_CmsXmlSchemaType type = this.m_content.getContentDefinition().getSchemaType(this.m_path);
        this.m_isChoiceSequence = type.isChoiceOption();
        this.m_values = this.m_isChoiceSequence ? this.m_content.getSubValues(CmsXmlUtils.removeLastXpathElement(this.m_path), this.m_locale) : this.m_content.getValues(path, this.m_locale);
        if (type.getContentDefinition().getChoiceMaxOccurs() > 1) {
            this.m_minOccurs = 0;
            this.m_maxOccurs = type.getContentDefinition().getChoiceMaxOccurs();
        } else {
            if (this.m_isChoiceSequence && !this.m_values.isEmpty()) {
                type = this.m_values.get(0);
            }
            this.m_minOccurs = type.getMinOccurs();
            this.m_maxOccurs = type.getMaxOccurs();
        }
    }

    public I_CmsXmlContentValue addValue(CmsObject cms, I_CmsXmlSchemaType type, int index) {
        String xpath = CmsXmlUtils.concatXpath(CmsXmlUtils.removeLastXpathElement(this.getPath()), type.getName());
        return this.addValue(cms, xpath, index);
    }

    public I_CmsXmlContentValue addValue(CmsObject cms, int index) {
        return this.addValue(cms, this.getPath(), index);
    }

    public I_CmsXmlContentValue addValue(CmsObject cms, String xpath, int index) {
        I_CmsXmlContentValue newValue = this.m_content.addValue(cms, xpath, this.getLocale(), index);
        this.m_values = this.m_content.getValues(this.getPath(), this.getLocale());
        return newValue;
    }

    public int getElementCount() {
        return this.m_values.size();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public int getMaxOccurs() {
        return this.m_maxOccurs;
    }

    public int getMinOccurs() {
        return this.m_minOccurs;
    }

    public String getPath() {
        return this.m_path;
    }

    public I_CmsXmlContentValue getValue(int index) {
        return this.m_values.get(index);
    }

    public List<I_CmsXmlContentValue> getValues() {
        return this.m_values;
    }

    public boolean isChoiceSequence() {
        return this.m_isChoiceSequence;
    }

    public void removeValue(int index) {
        this.m_content.removeValue(this.getPath(), this.getLocale(), index);
        this.m_values = this.m_content.getValues(this.getPath(), this.getLocale());
    }
}

