/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.templatemapper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.templatemapper.CmsTemplateMapperConfiguration;
import org.opencms.xml.templatemapper.I_CmsTemplateMappingContextProvider;

public final class CmsTemplateMapper {
    static final Log LOG = CmsLog.getLog(CmsTemplateMapper.class);
    protected boolean m_enabled;
    protected String m_configPath;
    private boolean m_forSave;

    public CmsTemplateMapper(String configPath) {
        if (configPath != null) {
            this.m_enabled = true;
            this.m_configPath = configPath;
        } else {
            this.m_enabled = false;
        }
    }

    private CmsTemplateMapper() {
        this.m_enabled = true;
    }

    public static CmsTemplateMapper get() {
        return new CmsTemplateMapper();
    }

    public static CmsTemplateMapper get(ServletRequest request) {
        return new CmsTemplateMapper(CmsTemplateMapper.getTemplateMapperConfig(request));
    }

    public static String getTemplateMapperConfig(ServletRequest request) {
        I_CmsTemplateContextProvider provider;
        String result = null;
        CmsTemplateContext templateContext = (CmsTemplateContext)request.getAttribute("templateContext");
        if (templateContext != null && (provider = templateContext.getProvider()) instanceof I_CmsTemplateMappingContextProvider) {
            result = ((I_CmsTemplateMappingContextProvider)((Object)provider)).getMappingConfigurationPath(templateContext.getKey());
        }
        return result;
    }

    public void setForSave(boolean forSave) {
        this.m_forSave = forSave;
    }

    public CmsContainerPageBean transformContainerpageBean(CmsObject cms, CmsContainerPageBean input, String rootPath) {
        CmsTemplateMapperConfiguration config = this.getConfiguration(cms);
        if (config == null || !config.isEnabledForPath(rootPath)) {
            return input;
        }
        ArrayList<CmsContainerBean> newContainers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : input.getContainers().values()) {
            List<CmsContainerElementBean> elements = container.getElements();
            ArrayList<CmsContainerElementBean> newElements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerElementBean element : elements) {
                CmsContainerElementBean newElement = this.transformContainerElement(cms, config, element);
                if (newElement == null) continue;
                newElements.add(newElement);
            }
            CmsContainerBean newContainer = container.copyWithNewElements(newElements);
            newContainers.add(newContainer);
        }
        CmsContainerPageBean result = new CmsContainerPageBean(newContainers);
        return result;
    }

    public CmsContainerElementBean transformDetailElement(CmsObject cms, CmsContainerElementBean input, String rootPath) {
        CmsTemplateMapperConfiguration config = this.getConfiguration(cms);
        if (config == null || !config.isEnabledForPath(rootPath)) {
            return input;
        }
        return this.transformContainerElement(cms, config, input);
    }

    public CmsGroupContainerBean transformGroupContainer(CmsObject cms, CmsGroupContainerBean input, String rootPath) {
        CmsTemplateMapperConfiguration config = this.getConfiguration(cms);
        if (config == null || !config.isEnabledForPath(rootPath)) {
            return input;
        }
        ArrayList<CmsContainerElementBean> newElements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElementBean element : input.getElements()) {
            CmsContainerElementBean newElement = this.transformContainerElement(cms, config, element);
            if (newElement == null) continue;
            newElements.add(newElement);
        }
        HashSet<String> transformedTypes = new HashSet<String>();
        Set<String> oldTypes = input.getTypes();
        if (oldTypes == null) {
            oldTypes = new HashSet<String>();
        }
        for (String type : oldTypes) {
            String newType = config.getMappedElementGroupType(type);
            if (newType == null) {
                newType = type;
            }
            transformedTypes.add(newType);
        }
        CmsGroupContainerBean result = new CmsGroupContainerBean(input.getTitle(), input.getDescription(), newElements, transformedTypes);
        return result;
    }

    protected CmsContainerElementBean transformContainerElement(CmsObject cms, CmsTemplateMapperConfiguration config, CmsContainerElementBean element) {
        CmsUUID mappedFormatterJspId;
        Map<String, String> settings;
        if (this.m_forSave) {
            try {
                element.initResource(cms);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        if ((settings = element.getIndividualSettings()) == null) {
            settings = new HashMap<String, String>();
        }
        HashMap<String, String> newSettings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String value;
            String key = entry.getKey();
            if ("templateContexts".equals(key) || (value = entry.getValue()) == null) continue;
            Object newValue = value;
            if (key.startsWith("formatterSettings#")) {
                CmsUUID schemaFormatterId;
                CmsUUID mappedFormatterId;
                String schemaFormatterIdStr;
                if (CmsUUID.isValidUUID(value)) {
                    String newId = config.getMappedFormatterConfiguration(value);
                    if (newId != null) {
                        newValue = newId;
                    }
                } else if (value.startsWith("schema_formatter") && CmsUUID.isValidUUID(schemaFormatterIdStr = value.substring("schema_formatter".length())) && (mappedFormatterId = config.getMappedFormatterJspId(schemaFormatterId = new CmsUUID(schemaFormatterIdStr))) != null) {
                    newValue = "schema_formatter" + mappedFormatterId;
                }
            }
            newSettings.put(key, (String)newValue);
        }
        CmsContainerElementBean newElement = element.clone();
        newElement.updateIndividualSettings(newSettings);
        CmsUUID formatterId = element.getFormatterId();
        if (formatterId == null && this.m_forSave) {
            try {
                if (element.isGroupContainer(cms)) {
                    formatterId = new CmsUUID("e7029fa2-761e-11e0-bd7f-9ffeadaf4d46");
                    newElement.setFormatterId(formatterId);
                } else if (OpenCms.getResourceManager().matchResourceType("function", element.getResource().getTypeId())) {
                    formatterId = new CmsUUID("087ba7c9-e7fc-4336-acb8-d3416a4eb1fd");
                    newElement.setFormatterId(formatterId);
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if ((mappedFormatterJspId = config.getMappedFormatterJspId(formatterId)) != null) {
            newElement.setFormatterId(mappedFormatterJspId);
        }
        return newElement;
    }

    private CmsTemplateMapperConfiguration getConfiguration(final CmsObject cms) {
        if (!this.m_enabled) {
            return CmsTemplateMapperConfiguration.EMPTY_CONFIG;
        }
        if (this.m_configPath == null) {
            this.m_configPath = OpenCms.getSystemInfo().getConfigFilePath(cms, "template-mapping.xml");
        }
        return (CmsTemplateMapperConfiguration)CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().loadVfsObject(cms, this.m_configPath, new Transformer(){

            public Object transform(Object input) {
                CmsTemplateMapperConfiguration cmsTemplateMapperConfiguration;
                CmsFile file = cms.readFile(CmsTemplateMapper.this.m_configPath, CmsResourceFilter.IGNORE_EXPIRATION);
                SAXReader saxBuilder = new SAXReader();
                ByteArrayInputStream stream = new ByteArrayInputStream(file.getContents());
                try {
                    CmsTemplateMapperConfiguration config;
                    Document document = saxBuilder.read((InputStream)stream);
                    cmsTemplateMapperConfiguration = config = new CmsTemplateMapperConfiguration(cms, document);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        return new CmsTemplateMapperConfiguration();
                    }
                }
                stream.close();
                return cmsTemplateMapperConfiguration;
            }
        });
    }
}

