/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.opencms.xml.types.Messages;

public abstract class A_CmsXmlContentValue
implements I_CmsXmlContentValue,
I_CmsWidgetParameter {
    private static final Log LOG = CmsLog.getLog(A_CmsXmlContentValue.class);
    protected String m_defaultValue;
    protected I_CmsXmlDocument m_document;
    protected Element m_element;
    protected Locale m_locale;
    protected int m_maxOccurs;
    protected int m_minOccurs;
    protected String m_name;
    private CmsXmlContentDefinition m_contentDefinition;
    private int m_index;
    private int m_maxIndex;
    private String m_prefix;
    private int m_xmlIndex;

    protected A_CmsXmlContentValue() {
        this.m_minOccurs = 0;
        this.m_maxOccurs = Integer.MAX_VALUE;
        this.m_index = -1;
        this.m_xmlIndex = -1;
        this.m_maxIndex = -1;
    }

    protected A_CmsXmlContentValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        this.m_element = element;
        this.m_name = element.getName();
        this.m_document = document;
        this.m_locale = locale;
        this.m_minOccurs = type.getMinOccurs();
        this.m_maxOccurs = type.getMaxOccurs();
        this.m_contentDefinition = type.getContentDefinition();
        this.m_index = -1;
        this.m_xmlIndex = -1;
        this.m_maxIndex = -1;
    }

    protected A_CmsXmlContentValue(String name, String minOccurs, String maxOccurs) {
        this.m_name = name;
        this.m_minOccurs = 1;
        if (CmsStringUtil.isNotEmpty(minOccurs)) {
            try {
                this.m_minOccurs = Integer.parseInt(minOccurs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_maxOccurs = 1;
        if (CmsStringUtil.isNotEmpty(maxOccurs)) {
            if ("unbounded".equals(maxOccurs)) {
                this.m_maxOccurs = Integer.MAX_VALUE;
            } else {
                try {
                    this.m_maxOccurs = Integer.parseInt(maxOccurs);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.m_index = -1;
        this.m_xmlIndex = -1;
        this.m_maxIndex = -1;
    }

    @Override
    public void appendXmlSchema(Element root) {
        Element element = root.addElement(CmsXmlContentDefinition.XSD_NODE_ELEMENT);
        element.addAttribute("name", this.getName());
        element.addAttribute("type", this.getTypeName());
        if (this.getMinOccurs() > 1 || this.getMinOccurs() == 0) {
            element.addAttribute("minOccurs", String.valueOf(this.getMinOccurs()));
        }
        if (this.getMaxOccurs() > 1) {
            if (this.getMaxOccurs() == Integer.MAX_VALUE) {
                element.addAttribute("maxOccurs", "unbounded");
            } else {
                element.addAttribute("maxOccurs", String.valueOf(this.getMaxOccurs()));
            }
        }
    }

    @Override
    public int compareTo(I_CmsXmlSchemaType obj) {
        if (obj == this) {
            return 0;
        }
        return this.getTypeName().compareTo(obj.getTypeName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsXmlSchemaType) {
            I_CmsXmlSchemaType other = (I_CmsXmlSchemaType)obj;
            return this.getName().equals(other.getName()) && this.getTypeName().equals(other.getTypeName()) && this.getMinOccurs() == other.getMinOccurs() && this.getMaxOccurs() == other.getMaxOccurs();
        }
        return false;
    }

    @Override
    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        String defaultValue = document.getHandler().getDefault(cms, this, locale);
        if (defaultValue != null) {
            try {
                I_CmsXmlContentValue value = this.createValue(document, element, locale);
                value.setStringValue(cms, defaultValue);
            }
            catch (CmsRuntimeException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1", defaultValue), (Throwable)e);
                element.clearContent();
            }
        }
        return element;
    }

    @Override
    public int getChoiceMaxOccurs() {
        return 0;
    }

    @Override
    public CmsXmlContentDefinition getContentDefinition() {
        return this.m_contentDefinition;
    }

    @Override
    public String getDefault(CmsObject cms) {
        return this.m_contentDefinition.getContentHandler().getDefault(cms, this, this.getLocale());
    }

    @Override
    public String getDefault(Locale locale) {
        return this.m_defaultValue;
    }

    @Override
    public I_CmsXmlDocument getDocument() {
        return this.m_document;
    }

    @Override
    public Element getElement() {
        return this.m_element;
    }

    @Override
    public String getId() {
        if (this.m_element == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(128);
        result.append(this.getTypeName());
        result.append('.');
        result.append(this.getPath().replace('[', '_').replace(']', '_').replace('/', '.'));
        result.append('.');
        result.append(this.getIndex());
        return result.toString();
    }

    @Override
    public int getIndex() {
        if (this.m_index < 0) {
            this.m_index = this.isChoiceOption() ? this.m_element.getParent().elements().indexOf(this.m_element) : this.getXmlIndex();
        }
        return this.m_index;
    }

    @Override
    public String getKey() {
        StringBuffer result = new StringBuffer(128);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_prefix)) {
            result.append(this.m_prefix);
            result.append('.');
        }
        result.append(this.m_contentDefinition.getInnerName());
        result.append('.');
        result.append(this.getName());
        return result.toString();
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public int getMaxIndex() {
        if (this.m_maxIndex < 0) {
            this.m_maxIndex = this.isChoiceOption() ? this.m_element.getParent().elements().size() : this.m_element.getParent().elements(this.m_element.getQName()).size();
        }
        return this.m_maxIndex;
    }

    @Override
    public int getMaxOccurs() {
        return this.m_maxOccurs;
    }

    @Override
    public int getMinOccurs() {
        return this.m_minOccurs;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPath() {
        if (this.m_element == null) {
            return "";
        }
        String path = this.m_element.getUniquePath();
        int pos = path.indexOf(47, path.indexOf(47, 1) + 1) + 1;
        path = path.substring(pos);
        return CmsXmlUtils.createXpath(path, 1);
    }

    @Override
    public String getPlainText(CmsObject cms) {
        return null;
    }

    @Override
    public int getXmlIndex() {
        if (this.m_xmlIndex < 0) {
            this.m_xmlIndex = this.m_element.getParent().elements(this.m_element.getQName()).indexOf(this.m_element);
        }
        return this.m_xmlIndex;
    }

    @Override
    public boolean hasError() {
        return false;
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    @Override
    public boolean isChoiceOption() {
        return this.m_contentDefinition.getChoiceMaxOccurs() > 0;
    }

    @Override
    public boolean isChoiceType() {
        return false;
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public void moveDown() {
        if (this.getIndex() > 0) {
            this.moveValue(-1);
            this.getDocument().initDocument();
        }
    }

    @Override
    public void moveUp() {
        if (this.getIndex() < this.getMaxIndex() - 1) {
            this.moveValue(1);
            this.getDocument().initDocument();
        }
    }

    @Override
    public void setContentDefinition(CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinition = contentDefinition;
    }

    @Override
    public void setDefault(String defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    @Override
    public void setKeyPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String toString() {
        Object value;
        StringBuffer result = new StringBuffer(128);
        result.append(this.getClass().getName());
        result.append(": name=");
        result.append(this.getName());
        result.append(", type=");
        result.append(this.getTypeName());
        result.append(", path=");
        result.append(this.m_element == null ? null : this.getPath());
        try {
            value = "'" + this.getStringValue(null) + "'";
        }
        catch (Exception e) {
            value = "(CmsObject required to generate)";
        }
        result.append(", value=");
        result.append((String)value);
        return result.toString();
    }

    @Override
    public boolean validateValue(String value) {
        return true;
    }

    protected CmsRelationType getRelationType(String path) {
        CmsRelationType result = this.getContentDefinition().getContentHandler().getRelationType(path);
        I_CmsXmlDocument document = this.getDocument();
        if (document != null) {
            result = document.getContentDefinition().getContentHandler().getRelationType(this.getPath(), result);
        } else {
            LOG.warn((Object)("Missing document while evaluating relation type for " + path));
        }
        return result;
    }

    protected void moveValue(int step) {
        Element e = this.getElement();
        Element parent = e.getParent();
        List<Element> siblings = CmsXmlGenericWrapper.elements(parent);
        int idx = siblings.indexOf(e);
        int newIdx = idx + step;
        siblings.remove(idx);
        siblings.add(newIdx, e);
        this.m_index += step;
    }

    protected String readSchemaDefinition(String schemaUri) throws CmsRuntimeException {
        String schemaDefinition;
        try {
            schemaDefinition = CmsFileUtil.readFile(schemaUri, "UTF-8");
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", schemaUri), (Throwable)e);
        }
        return schemaDefinition;
    }
}

