/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlAccessRestrictionValue
extends A_CmsXmlContentValue {
    public static final String TYPE_NAME = "OpenCmsAccessRestriction";
    public static final String N_ACCESS_RESTRICTION_VALUE = "access-restriction-value";
    private static String m_schemaDefinition;

    public CmsXmlAccessRestrictionValue() {
    }

    public CmsXmlAccessRestrictionValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlAccessRestrictionValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlAccessRestrictionValue(document, element, locale, this);
    }

    @Override
    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        element.addComment("Access restriction is dynamically read from permissions.");
        return element;
    }

    @Override
    public String getPlainText(CmsObject cms) {
        return this.getStringValue(cms);
    }

    @Override
    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlAccessRestrictionValue.xsd");
        }
        return m_schemaDefinition;
    }

    @Override
    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        Element categoryElement = this.valueElem(false);
        if (categoryElement == null) {
            return "";
        }
        return categoryElement.getText();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlAccessRestrictionValue(name, minOccurs, maxOccurs);
    }

    @Override
    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        this.valueElem(true).setText(value);
    }

    Element valueElem(boolean create) {
        Element result = this.m_element.element(N_ACCESS_RESTRICTION_VALUE);
        if (result == null && create) {
            result = this.m_element.addElement(N_ACCESS_RESTRICTION_VALUE);
            result.detach();
            this.m_element.elements().add(0, result);
        }
        return result;
    }
}

