/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;

public class CmsJsonAccessPolicy {
    public static final Pattern DEFAULT_PROP_FILTER = Pattern.compile("(?i)^(?!.*(?:secret|api|password|key)).*$");
    public static final String DEFAULT_CORS_FILTER = "*";
    private static final Log LOG = CmsLog.getLog(CmsJsonAccessPolicy.class);
    private String m_accessGroup;
    private List<Pattern> m_exclude;
    private String m_corsAllowOrigin = "*";
    private String m_corsAllowMethods = "*";
    private String m_corsAllowHeaders = "*";
    private List<Pattern> m_include;
    private Boolean m_overrideValue;
    private Pattern m_propertyFilter = DEFAULT_PROP_FILTER;

    public CmsJsonAccessPolicy(boolean enabled) {
        this.m_overrideValue = enabled;
    }

    public CmsJsonAccessPolicy(String accessGroup, List<String> includePatterns, List<String> excludePatterns, String propertyFilterRegex, String corsAllowOrigin, String corsAllowMethods, String corsAllowHeaders) {
        this.m_accessGroup = accessGroup;
        this.m_include = includePatterns.stream().map(Pattern::compile).collect(Collectors.toList());
        this.m_exclude = excludePatterns.stream().map(Pattern::compile).collect(Collectors.toList());
        if (propertyFilterRegex != null) {
            this.m_propertyFilter = Pattern.compile(propertyFilterRegex);
        }
        this.m_corsAllowOrigin = corsAllowOrigin;
        this.m_corsAllowMethods = corsAllowMethods;
        this.m_corsAllowHeaders = corsAllowHeaders;
    }

    public static CmsJsonAccessPolicy parse(byte[] data) throws DocumentException {
        CmsJsonAccessPolicy cmsJsonAccessPolicy;
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        try {
            cmsJsonAccessPolicy = CmsJsonAccessPolicy.parse(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        stream.close();
        return cmsJsonAccessPolicy;
    }

    public static CmsJsonAccessPolicy parse(InputStream stream) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(stream);
        Element root = document.getRootElement();
        Element groupElem = root.element("group");
        String groupName = null;
        if (groupElem != null) {
            groupName = groupElem.getTextTrim();
        }
        Element propertyFilterElem = root.element("property-filter");
        String propertyFilterRegex = null;
        if (propertyFilterElem != null) {
            propertyFilterRegex = propertyFilterElem.getTextTrim();
        }
        List<String> includes = root.elements("include").stream().map(elem -> elem.getTextTrim()).collect(Collectors.toList());
        List<String> excludes = root.elements("exclude").stream().map(elem -> elem.getTextTrim()).collect(Collectors.toList());
        Element elementCors = root.element("cors");
        String corsAllowOrigin = DEFAULT_CORS_FILTER;
        String corsAllowMethods = DEFAULT_CORS_FILTER;
        String corsAllowHeaders = DEFAULT_CORS_FILTER;
        if (elementCors != null) {
            corsAllowOrigin = elementCors.elementTextTrim("allow-origin");
            corsAllowMethods = elementCors.elementTextTrim("allow-methods");
            corsAllowHeaders = elementCors.elementTextTrim("allow-headers");
        }
        return new CmsJsonAccessPolicy(groupName, includes, excludes, propertyFilterRegex, corsAllowOrigin, corsAllowMethods, corsAllowHeaders);
    }

    public boolean checkAccess(CmsObject cms, String path) {
        if (this.m_overrideValue != null) {
            return this.m_overrideValue;
        }
        if (this.m_accessGroup != null) {
            try {
                List<CmsGroup> groups = cms.getGroupsOfUser(cms.getRequestContext().getCurrentUser().getName(), true, true);
                boolean foundGroup = groups.stream().anyMatch(group -> group.getName().equals(this.m_accessGroup));
                if (!foundGroup) {
                    return false;
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        boolean included = (this.m_include.isEmpty() || this.m_include.stream().anyMatch(include -> include.matcher(path).matches())) && !this.m_exclude.stream().anyMatch(exclude -> exclude.matcher(path).matches());
        return included;
    }

    public boolean checkPropertyAccess(String property) {
        boolean result;
        boolean bl = result = this.m_propertyFilter == null || this.m_propertyFilter.matcher(property).matches();
        if (!result) {
            LOG.info((Object)("Filtered property " + property + " because it does not match the JSON property filter."));
        }
        return result;
    }

    public void setCorsHeaders(HttpServletResponse response) {
        if (this.m_corsAllowOrigin != null) {
            response.setHeader("Access-Control-Allow-Origin", this.m_corsAllowOrigin);
        }
        if (this.m_corsAllowMethods != null) {
            response.setHeader("Access-Control-Allow-Methods", this.m_corsAllowMethods);
        }
        if (this.m_corsAllowHeaders != null) {
            response.setHeader("Access-Control-Allow-Headers", this.m_corsAllowHeaders);
        }
    }
}

