/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.document;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.document.A_CmsJsonDocument;
import org.opencms.xml.xml2json.document.CmsJsonDocumentEmbeddedXmlContent;
import org.opencms.xml.xml2json.document.CmsJsonDocumentResource;
import org.opencms.xml.xml2json.document.I_CmsJsonDocument;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerException;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerXmlContent;

public class CmsJsonDocumentFolder
extends A_CmsJsonDocument
implements I_CmsJsonDocument {
    private static final Log LOG = CmsLog.getLog(CmsJsonDocumentFolder.class);

    public CmsJsonDocumentFolder(CmsJsonRequest jsonRequest) {
        super(jsonRequest);
    }

    @Override
    public Object getJson() throws JSONException, CmsException, CmsJsonHandlerException, CmsJsonHandlerXmlContent.PathNotFoundException, Exception {
        CmsResource target = this.m_context.getResource();
        int levels = this.m_jsonRequest.getParamLevels(1);
        this.m_json = this.folderListingJson(target, levels);
        return this.m_json;
    }

    protected JSONObject folderListingJson(CmsResource target, int levelsLeft) throws Exception {
        List<CmsResource> children = this.m_context.getCms().readResources(target, CmsResourceFilter.DEFAULT, false);
        JSONObject result = new JSONObject(true);
        for (CmsResource resource : children) {
            JSONObject childEntry = this.formatResource(resource);
            if (resource.isFolder() && levelsLeft > 1) {
                JSONObject childrenJson = this.folderListingJson(resource, levelsLeft - 1);
                childEntry.put("children", childrenJson);
            }
            result.put(resource.getName(), childEntry);
        }
        return result;
    }

    private JSONObject formatResource(CmsResource resource) throws Exception {
        boolean isContent = false;
        if (!resource.isFolder()) {
            isContent = CmsResourceTypeXmlContent.isXmlContent(resource);
        }
        Boolean paramContent = this.m_jsonRequest.getParamContent();
        Boolean paramWrapper = this.m_jsonRequest.getParamWrapper(true);
        if (isContent && paramContent.booleanValue()) {
            CmsFile file = this.m_context.getCms().readFile(resource);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_context.getCms(), file);
            CmsJsonDocumentEmbeddedXmlContent jsonDocumentXmlContent = new CmsJsonDocumentEmbeddedXmlContent(this.m_jsonRequest, xmlContent);
            return (JSONObject)jsonDocumentXmlContent.getJson();
        }
        if (paramWrapper.booleanValue()) {
            CmsJsonDocumentResource jsonDocumentResource = new CmsJsonDocumentResource(this.m_jsonRequest, resource);
            return (JSONObject)jsonDocumentResource.getJson();
        }
        return new JSONObject();
    }
}

