/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.document.CmsJsonDocumentFolder;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsJsonHandlerFolder
implements I_CmsJsonHandler {
    private static final Log LOG = CmsLog.getLog(CmsJsonHandlerFolder.class);

    @Override
    public double getOrder() {
        return 200.0;
    }

    @Override
    public boolean matches(CmsJsonHandlerContext context) {
        return context.getResource() != null && context.getResource().isFolder();
    }

    @Override
    public CmsJsonResult renderJson(CmsJsonHandlerContext context) {
        try {
            try {
                CmsResource indexJson = context.getRootCms().readResource(CmsStringUtil.joinPaths(context.getPath(), "index.json"));
                return new CmsJsonResult(indexJson);
            }
            catch (CmsVfsResourceNotFoundException e) {
                CmsJsonRequest jsonRequest = new CmsJsonRequest(context, this);
                jsonRequest.validate();
                if (jsonRequest.hasErrors()) {
                    return new CmsJsonResult(jsonRequest.getErrorsAsJson(), 400);
                }
                CmsJsonDocumentFolder jsonDocument = new CmsJsonDocumentFolder(jsonRequest);
                return new CmsJsonResult(jsonDocument.getJson(), 200);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 500);
        }
    }
}

