/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import org.apache.commons.logging.Log;
import org.opencms.json.JSONException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.document.CmsJsonDocumentList;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerXmlContent;

public class CmsJsonHandlerList
extends CmsJsonHandlerXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsJsonHandlerList.class);
    private static final String TYPE_LIST_CONFIG = "listconfig";

    @Override
    public double getOrder() {
        return 50.0;
    }

    @Override
    public boolean matches(CmsJsonHandlerContext context) {
        String typeName = OpenCms.getResourceManager().getResourceType(context.getResource()).getTypeName();
        return typeName.equals(TYPE_LIST_CONFIG);
    }

    @Override
    public CmsJsonResult renderJson(CmsJsonHandlerContext context) {
        try {
            CmsJsonRequest jsonRequest = new CmsJsonRequest(context, this);
            jsonRequest.validate();
            if (jsonRequest.hasErrors()) {
                return new CmsJsonResult(jsonRequest.getErrorsAsJson(), 400);
            }
            CmsJsonDocumentList jsonDocument = new CmsJsonDocumentList(jsonRequest, context.getContent());
            return new CmsJsonResult(jsonDocument.getJson(), 200);
        }
        catch (JSONException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 404);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 500);
        }
    }
}

