/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsFolderOrName {
    private String m_folderName;
    private CmsResource m_folder;
    private String m_basePath;
    private static final Log LOG = CmsLog.getLog(CmsFolderOrName.class);

    public CmsFolderOrName(CmsResource folder) {
        this.m_folder = folder;
    }

    public CmsFolderOrName(String basePath, String name) {
        this.m_basePath = basePath;
        this.m_folderName = name;
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public CmsResource getFolder() {
        return this.m_folder;
    }

    public String getFolderName() {
        return this.m_folderName;
    }

    public String getFolderPath(CmsObject cms) {
        if (this.m_folder != null) {
            try {
                return OpenCms.getADEManager().getRootPath(this.m_folder.getStructureId(), cms.getRequestContext().getCurrentProject().isOnlineProject());
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return this.m_folder.getRootPath();
            }
        }
        if (this.m_basePath != null) {
            return CmsStringUtil.joinPaths(this.m_basePath, this.m_folderName);
        }
        return CmsStringUtil.joinPaths(cms.getRequestContext().getSiteRoot(), ".content", this.m_folderName);
    }

    public boolean isFolder() {
        return this.m_folder != null;
    }

    public boolean isName() {
        return this.m_folderName != null;
    }
}

