/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.Messages;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPublishGroupHelper {
    private static final Log LOG = CmsLog.getLog(CmsPublishGroupHelper.class);
    protected static final int GROUP_SESSIONS_GAP = 28800000;
    private Locale m_locale;

    public CmsPublishGroupHelper(Locale locale) {
        this.m_locale = locale;
    }

    public Map<Long, Integer> computeDays(List<Long> sortedDates) {
        if (sortedDates.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> days = new HashMap<Long, Integer>();
        long lastDate = System.currentTimeMillis();
        int dayCounter = 0;
        for (Long dateObj : sortedDates) {
            long date = dateObj;
            long dayDifference = this.getDayDifference(lastDate, date);
            dayCounter = (int)((long)dayCounter + dayDifference);
            lastDate = date;
            days.put(dateObj, new Integer(dayCounter));
        }
        return days;
    }

    public Map<Long, Integer> computeDaysForResources(List<CmsResource> resources) {
        Map<Long, Integer> result = this.computeDays(this.getModificationDates(resources));
        if (LOG.isDebugEnabled()) {
            for (CmsResource res : resources) {
                LOG.debug((Object)("Resource " + res.getRootPath() + " is " + result.get(new Long(res.getDateLastModified())) + " days old."));
            }
        }
        return result;
    }

    public int getDayDifference(long first, long second) {
        if (first < second) {
            throw new IllegalArgumentException();
        }
        Calendar firstDay = this.getStartOfDay(first);
        Calendar secondDay = this.getStartOfDay(second);
        int result = 0;
        while (firstDay.after(secondDay)) {
            firstDay.add(5, -1);
            ++result;
        }
        return result;
    }

    public List<Long> getModificationDates(List<CmsResource> resources) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (CmsResource res : resources) {
            result.add(new Long(res.getDateLastModified()));
        }
        return result;
    }

    public String getPublishGroupName(List<CmsResource> resources, GroupAge age) {
        String groupName;
        long groupDate = resources.get(0).getDateLastModified();
        switch (age) {
            case young: {
                groupName = Messages.get().getBundle(this.m_locale).key("GUI_GROUPNAME_SESSION_1", new Date(groupDate));
                break;
            }
            case medium: {
                groupName = Messages.get().getBundle(this.m_locale).key("GUI_GROUPNAME_DAY_1", new Date(groupDate));
                break;
            }
            default: {
                groupName = Messages.get().getBundle(this.m_locale).key("GUI_GROUPNAME_EVERYTHING_ELSE_0");
            }
        }
        return groupName;
    }

    public Calendar getStartOfDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        Calendar result = Calendar.getInstance();
        result.set(1, year);
        result.set(2, month);
        result.set(5, day);
        return result;
    }

    public List<List<CmsResource>> partitionMediumResources(List<CmsResource> resources, Map<Long, Integer> days) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        CmsResource firstRes = resources.get(0);
        int lastDay = days.get(new Long(firstRes.getDateLastModified()));
        ArrayList<List<CmsResource>> result = new ArrayList<List<CmsResource>>();
        ArrayList<CmsResource> currentGroup = new ArrayList<CmsResource>();
        result.add(currentGroup);
        for (CmsResource res : resources) {
            LOG.debug((Object)("Processing medium-aged resource " + res.getRootPath()));
            int day = days.get(new Long(res.getDateLastModified()));
            if (day != lastDay) {
                LOG.debug((Object)"=== new group ===");
                currentGroup = new ArrayList();
                result.add(currentGroup);
            }
            lastDay = day;
            currentGroup.add(res);
        }
        return result;
    }

    public Map<GroupAge, List<CmsResource>> partitionPublishResourcesByAge(List<CmsResource> resources, Map<Long, Integer> days) {
        ArrayList<CmsResource> youngRes = new ArrayList<CmsResource>();
        ArrayList mediumRes = new ArrayList();
        ArrayList oldRes = new ArrayList();
        for (CmsResource res : resources) {
            int day = days.get(new Long(res.getDateLastModified()));
            ArrayList<CmsResource> listToAddTo = null;
            if (day < 7) {
                listToAddTo = youngRes;
                LOG.debug((Object)("Classifying publish resource " + res.getRootPath() + " as young"));
            } else if (day < 28) {
                listToAddTo = mediumRes;
                LOG.debug((Object)("Classifying publish resource " + res.getRootPath() + " as medium-aged"));
            } else {
                listToAddTo = oldRes;
                LOG.debug((Object)("Classifying publish resource " + res.getRootPath() + " as old"));
            }
            listToAddTo.add(res);
        }
        HashMap<GroupAge, List<CmsResource>> result = new HashMap<GroupAge, List<CmsResource>>();
        result.put(GroupAge.young, youngRes);
        result.put(GroupAge.medium, mediumRes);
        result.put(GroupAge.old, oldRes);
        return result;
    }

    public List<List<CmsResource>> partitionYoungResources(List<CmsResource> resources) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<CmsResource>> result = new ArrayList<List<CmsResource>>();
        ArrayList<CmsResource> currentGroup = new ArrayList<CmsResource>();
        result.add(currentGroup);
        long lastDate = resources.get(0).getDateLastModified();
        for (CmsResource res : resources) {
            LOG.debug((Object)("Processing young resource " + res.getRootPath()));
            long resDate = res.getDateLastModified();
            if (lastDate - resDate > 28800000L) {
                LOG.debug((Object)"=== new group ===");
                currentGroup = new ArrayList();
                result.add(currentGroup);
            }
            lastDate = resDate;
            currentGroup.add(res);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GroupAge {
        medium,
        old,
        young;

    }
}

