/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.detailpage.CmsDetailPageConfigurationWriter;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.sitemap.CmsSitemapNavPosCalculator;
import org.opencms.ade.sitemap.Messages;
import org.opencms.ade.sitemap.shared.CmsAdditionalEntryInfo;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.ade.sitemap.shared.CmsDetailPageTable;
import org.opencms.ade.sitemap.shared.CmsNewResourceInfo;
import org.opencms.ade.sitemap.shared.CmsSitemapChange;
import org.opencms.ade.sitemap.shared.CmsSitemapClipboardData;
import org.opencms.ade.sitemap.shared.CmsSitemapData;
import org.opencms.ade.sitemap.shared.CmsSitemapInfo;
import org.opencms.ade.sitemap.shared.CmsSitemapMergeInfo;
import org.opencms.ade.sitemap.shared.CmsSubSitemapInfo;
import org.opencms.ade.sitemap.shared.rpc.I_CmsSitemapService;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.shared.CmsBrokenLinkBean;
import org.opencms.gwt.shared.CmsClientLock;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONArray;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsVfsSitemapService
extends CmsGwtService
implements I_CmsSitemapService {
    public static final String KEY_FUNCTION_DETAIL = "functionDetail";
    private static final String ADDINFO_ADE_DELETED_LIST = "ADE_DELETED_LIST";
    private static final String ADDINFO_ADE_MODIFIED_LIST = "ADE_MODIFIED_LIST";
    private static final Log LOG = CmsLog.getLog(CmsVfsSitemapService.class);
    private static final String RECOURCE_TYPE_NAME_REDIRECT = "htmlredirect";
    private static final String REDIRECT_LINK_TARGET_XPATH = "Link";
    private static final long serialVersionUID = -7236544324371767330L;
    private CmsJspNavBuilder m_navBuilder;

    public static CmsVfsSitemapService newInstance(HttpServletRequest request) {
        CmsVfsSitemapService service = new CmsVfsSitemapService();
        service.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        service.setRequest(request);
        return service;
    }

    @Override
    public CmsSubSitemapInfo createSubSitemap(CmsUUID entryId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource subSitemapFolder = cms.readResource(entryId);
            this.ensureLock(subSitemapFolder);
            String sitePath = cms.getSitePath(subSitemapFolder);
            String folderName = CmsStringUtil.joinPaths(sitePath, ".content/");
            String sitemapConfigName = CmsStringUtil.joinPaths(folderName, ".config");
            if (!cms.existsResource(folderName)) {
                cms.createResource(folderName, OpenCms.getResourceManager().getResourceType("content_folder").getTypeId());
            }
            I_CmsResourceType configType = OpenCms.getResourceManager().getResourceType("sitemap_config");
            if (cms.existsResource(sitemapConfigName)) {
                CmsResource configFile = cms.readResource(sitemapConfigName);
                if (configFile.getTypeId() != configType.getTypeId()) {
                    throw new CmsException(Messages.get().container("ERR_CREATING_SUB_SITEMAP_WRONG_CONFIG_FILE_TYPE_2", sitemapConfigName, "sitemap_config"));
                }
            } else {
                cms.createResource(sitemapConfigName, OpenCms.getResourceManager().getResourceType("sitemap_config").getTypeId());
            }
            subSitemapFolder.setType(this.getEntryPointType());
            cms.writeResource(subSitemapFolder);
            this.tryUnlock(subSitemapFolder);
            CmsSitemapClipboardData clipboard = this.getClipboardData();
            CmsClientSitemapEntry entry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(sitePath), false);
            clipboard.addModified(entry);
            this.setClipboardData(clipboard);
            return new CmsSubSitemapInfo(entry, System.currentTimeMillis());
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsAdditionalEntryInfo getAdditionalEntryInfo(CmsUUID structureId) throws CmsRpcException {
        CmsAdditionalEntryInfo result = null;
        try {
            try {
                CmsResource resource = this.getCmsObject().readResource(structureId);
                result = new CmsAdditionalEntryInfo();
                result.setResourceState(resource.getState());
                if (this.isRedirectType(resource.getTypeId())) {
                    CmsFile file = this.getCmsObject().readFile(resource);
                    CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCmsObject(), file);
                    String link = content.getValue(REDIRECT_LINK_TARGET_XPATH, this.getCmsObject().getRequestContext().getLocale()).getStringValue(this.getCmsObject());
                    HashMap<String, String> additional = new HashMap<String, String>();
                    additional.put(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_REDIRECT_TARGET_LABEL_0"), link);
                    result.setAdditional(additional);
                }
            }
            catch (CmsVfsResourceNotFoundException ne) {
                result = new CmsAdditionalEntryInfo();
                result.setResourceState(CmsResourceState.STATE_DELETED);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsClientSitemapEntry getChildren(String entryPointUri, String root, int levels) throws CmsRpcException {
        CmsClientSitemapEntry entry = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource rootRes = cms.readResource(root.replaceAll("/$", ""));
            root = cms.getSitePath(rootRes);
            CmsJspNavElement navElement = this.getNavBuilder().getNavigationForResource(root);
            entry = this.toClientEntry(navElement, false);
            if (rootRes.isFolder() && (!this.isSubSitemap(navElement) || root.equals(entryPointUri))) {
                entry.setSubEntries(this.getChildren(root, levels));
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return entry;
    }

    @Override
    public CmsSitemapMergeInfo mergeSubSitemap(String entryPoint, CmsUUID subSitemapId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource subSitemapFolder = cms.readResource(subSitemapId);
            this.ensureLock(subSitemapFolder);
            subSitemapFolder.setType(OpenCms.getResourceManager().getResourceType("folder").getTypeId());
            cms.writeResource(subSitemapFolder);
            String sitePath = cms.getSitePath(subSitemapFolder);
            String sitemapConfigName = CmsStringUtil.joinPaths(sitePath, ".content", ".config");
            if (cms.existsResource(sitemapConfigName)) {
                cms.deleteResource(sitemapConfigName, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            this.tryUnlock(subSitemapFolder);
            CmsSitemapClipboardData clipboard = this.getClipboardData();
            CmsClientSitemapEntry entry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(cms.getSitePath(subSitemapFolder)), false);
            clipboard.addModified(entry);
            this.setClipboardData(clipboard);
            return new CmsSitemapMergeInfo(this.getChildren(entryPoint, sitePath, 1), System.currentTimeMillis());
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsSitemapData prefetch(String sitemapUri) throws CmsRpcException {
        CmsSitemapData result = null;
        CmsObject cms = this.getCmsObject();
        try {
            CmsADEConfigData parentConfigData;
            String openPath = this.getRequest().getParameter("path");
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(openPath)) {
                openPath = "/";
            }
            openPath = cms.getRequestContext().addSiteRoot(openPath);
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, openPath);
            LinkedHashMap<String, CmsXmlContentProperty> propertyConfig = new LinkedHashMap<String, CmsXmlContentProperty>(configData.getPropertyConfigurationAsMap());
            Map<String, CmsClientProperty> parentProperties = this.generateParentProperties(configData.getBasePath());
            String siteRoot = cms.getRequestContext().getSiteRoot();
            String exportRfsPrefix = OpenCms.getStaticExportManager().getDefaultRfsPrefix();
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
            boolean isSecure = site.hasSecureServer();
            String parentSitemap = null;
            if (configData.getBasePath() != null && (parentSitemap = (parentConfigData = OpenCms.getADEManager().lookupConfiguration(cms, CmsResource.getParentFolder(configData.getBasePath()))).getBasePath()) != null) {
                parentSitemap = cms.getRequestContext().removeSiteRoot(parentSitemap);
            }
            String noEdit = "";
            CmsNewResourceInfo defaultNewInfo = null;
            List<CmsNewResourceInfo> newResourceInfos = null;
            CmsDetailPageTable detailPages = null;
            List<CmsNewResourceInfo> resourceTypeInfos = null;
            boolean canEditDetailPages = false;
            boolean isOnlineProject = CmsProject.isOnlineProject(cms.getRequestContext().getCurrentProject().getUuid());
            Locale locale = CmsLocaleManager.getDefaultLocale();
            try {
                String basePath = configData.getBasePath();
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                CmsResource baseDir = rootCms.readResource(basePath);
                OpenCms.getLocaleManager();
                locale = CmsLocaleManager.getMainLocale(cms, baseDir);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            detailPages = new CmsDetailPageTable(configData.getAllDetailPages());
            if (!isOnlineProject) {
                if (configData.getDefaultModelPage() != null) {
                    resourceTypeInfos = this.getResourceTypeInfos(this.getCmsObject(), configData, locale);
                    defaultNewInfo = this.createNewResourceInfo(cms, configData.getDefaultModelPage().getResource(), locale);
                }
                canEditDetailPages = !configData.isModuleConfiguration();
                newResourceInfos = this.getNewResourceInfos(cms, configData, locale);
            }
            if (isOnlineProject) {
                noEdit = Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_SITEMAP_NO_EDIT_ONLINE_0");
            }
            List<String> allPropNames = this.getPropertyNames(cms);
            String returnCode = this.getRequest().getParameter("returncode");
            cms.getRequestContext().getSiteRoot();
            result = new CmsSitemapData(new CmsTemplateFinder(cms).getTemplates(), propertyConfig, this.getClipboardData(), parentProperties, allPropNames, exportRfsPrefix, isSecure, noEdit, this.isDisplayToolbar(this.getRequest()), defaultNewInfo, newResourceInfos, this.createResourceTypeInfo(OpenCms.getResourceManager().getResourceType(RECOURCE_TYPE_NAME_REDIRECT), null), this.getSitemapInfo(configData.getBasePath()), parentSitemap, this.getRootEntry(configData.getBasePath()), this.getRequest().getParameter("path"), 30, detailPages, resourceTypeInfos, returnCode, canEditDetailPages);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsClientSitemapEntry> save(String entryPoint, CmsSitemapChange change) throws CmsRpcException {
        List<CmsClientSitemapEntry> result = null;
        try {
            result = this.saveInternal(entryPoint, change);
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsClientSitemapEntry> saveSync(String entryPoint, CmsSitemapChange change) throws CmsRpcException {
        return this.save(entryPoint, change);
    }

    protected CmsBrokenLinkBean createSitemapBrokenLinkBean(CmsResource resource) throws CmsException {
        String path;
        CmsObject cms = this.getCmsObject();
        CmsProperty titleProp = cms.readPropertyObject(resource, "Title", true);
        String defaultTitle = "";
        String title = titleProp.getValue(defaultTitle);
        String subtitle = path = cms.getSitePath(resource);
        return new CmsBrokenLinkBean(title, subtitle);
    }

    protected LockInfo ensureLockAndGetInfo(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        boolean justLocked = false;
        List<CmsResource> blockingResources = cms.getBlockingLockedResources(resource);
        if (blockingResources != null && !blockingResources.isEmpty()) {
            throw new CmsException(org.opencms.gwt.Messages.get().container("ERR_RESOURCE_HAS_BLOCKING_LOCKED_CHILDREN_1", cms.getSitePath(resource)));
        }
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(resource);
        if (!lock.isOwnedBy(user)) {
            cms.lockResourceTemporary(resource);
            lock = cms.getLock(resource);
            justLocked = true;
        } else if (!lock.isOwnedInProjectBy(user, cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(resource);
            lock = cms.getLock(resource);
            justLocked = true;
        }
        return new LockInfo(lock, justLocked);
    }

    protected List<CmsClientSitemapEntry> saveInternal(String entryPoint, CmsSitemapChange change) throws CmsException {
        this.ensureSession();
        ArrayList<CmsClientSitemapEntry> result = new ArrayList<CmsClientSitemapEntry>();
        CmsClientSitemapEntry changedEntry = null;
        switch (change.getChangeType()) {
            case clipboardOnly: {
                break;
            }
            case remove: {
                changedEntry = this.removeEntryFromNavigation(change);
                break;
            }
            case undelete: {
                changedEntry = this.undelete(change);
                break;
            }
            default: {
                changedEntry = this.applyChange(entryPoint, change);
            }
        }
        if (changedEntry != null) {
            result.add(changedEntry);
        }
        this.setClipboardData(change.getClipBoardData());
        return result;
    }

    Map<String, CmsClientProperty> createClientProperties(Iterable<CmsProperty> props, boolean preserveOrigin) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (CmsProperty prop : props) {
            CmsClientProperty clientProp = this.createClientProperty(prop, preserveOrigin);
            result.put(prop.getName(), clientProp);
        }
        return result;
    }

    void ensureSingleLocale(CmsXmlContainerPage containerPage, CmsResource localeRes) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Locale mainLocale = CmsLocaleManager.getMainLocale(cms, localeRes);
        OpenCms.getLocaleManager();
        Locale defaultLocale = CmsLocaleManager.getDefaultLocale();
        if (containerPage.hasLocale(mainLocale)) {
            this.removeAllLocalesExcept(containerPage, mainLocale);
        } else if (containerPage.hasLocale(defaultLocale)) {
            containerPage.copyLocale(defaultLocale, mainLocale);
            this.removeAllLocalesExcept(containerPage, mainLocale);
        } else if (containerPage.getLocales().size() > 0) {
            containerPage.copyLocale(containerPage.getLocales().get(0), mainLocale);
            this.removeAllLocalesExcept(containerPage, mainLocale);
        } else {
            containerPage.addLocale(cms, mainLocale);
        }
    }

    Map<String, CmsClientProperty> getClientProperties(CmsObject cms, CmsResource res, boolean search) throws CmsException {
        List<CmsProperty> props = cms.readPropertyObjects(res, search);
        Map<String, CmsClientProperty> result = this.createClientProperties(props, false);
        return result;
    }

    private void addFunctionDetailElement(CmsObject cms, CmsXmlContainerPage page, String containerName, CmsUUID elementId, CmsUUID formatterId) throws CmsException {
        List<Locale> pageLocales = page.getLocales();
        for (Locale locale : pageLocales) {
            CmsContainerPageBean bean = page.getContainerPage(cms, locale);
            ArrayList<CmsContainerBean> containerBeans = new ArrayList<CmsContainerBean>();
            Collection<CmsContainerBean> originalContainers = bean.getContainers().values();
            if (containerName == null && !originalContainers.isEmpty()) {
                CmsContainerBean firstContainer = originalContainers.iterator().next();
                containerName = firstContainer.getName();
            }
            boolean foundContainer = false;
            for (CmsContainerBean cntBean : originalContainers) {
                boolean isDetailTarget = cntBean.getName().equals(containerName);
                if (isDetailTarget && !foundContainer) {
                    foundContainer = true;
                    ArrayList<CmsContainerElementBean> newElems = new ArrayList<CmsContainerElementBean>();
                    newElems.addAll(cntBean.getElements());
                    CmsContainerElementBean newElement = new CmsContainerElementBean(elementId, formatterId, new HashMap<String, String>(), false);
                    newElems.add(0, newElement);
                    CmsContainerBean newCntBean = new CmsContainerBean(cntBean.getName(), cntBean.getType(), newElems);
                    containerBeans.add(newCntBean);
                    continue;
                }
                containerBeans.add(cntBean);
            }
            if (!foundContainer) {
                throw new CmsException(Messages.get().container("ERR_NO_FUNCTION_DETAIL_CONTAINER_1", page.getFile().getRootPath()));
            }
            CmsContainerPageBean bean2 = new CmsContainerPageBean(locale, new ArrayList<CmsContainerBean>(containerBeans));
            page.writeContainerPage(cms, locale, bean2);
        }
    }

    private CmsClientSitemapEntry applyChange(String entryPoint, CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource configFile = null;
        CmsClientSitemapEntry changedEntry = null;
        if (change.hasDetailPageInfos()) {
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().addSiteRoot(entryPoint));
            if (!configData.isModuleConfiguration() && configData.getResource() != null) {
                configFile = configData.getResource();
            }
            if (configFile != null) {
                this.ensureLock(configFile);
            }
        }
        if (change.isNew()) {
            changedEntry = this.createNewEntry(entryPoint, change);
        } else if (change.getChangeType() == CmsSitemapChange.ChangeType.delete) {
            changedEntry = this.delete(change);
        } else if (change.getEntryId() != null) {
            this.modifyEntry(change);
        }
        if (change.hasDetailPageInfos() && configFile != null) {
            this.saveDetailPages(change.getDetailPageInfos(), configFile, change.getEntryId());
            this.tryUnlock(configFile);
        }
        return changedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNavigationChanges(CmsSitemapChange change, CmsResource entryFolder) throws CmsException {
        CmsObject cms = this.getCmsObject();
        String parentPath = null;
        if (change.hasNewParent()) {
            CmsResource parent = cms.readResource(change.getParentId());
            parentPath = cms.getSitePath(parent);
        } else {
            parentPath = CmsResource.getParentFolder(cms.getSitePath(entryFolder));
        }
        List<CmsJspNavElement> navElements = this.getNavBuilder().getNavigationForFolder(parentPath, true);
        CmsSitemapNavPosCalculator npc = new CmsSitemapNavPosCalculator(navElements, entryFolder, change.getPosition());
        List<CmsJspNavElement> navs = npc.getNavigationChanges();
        ArrayList<CmsResource> needToUnlock = new ArrayList<CmsResource>();
        try {
            for (CmsJspNavElement nav : navs) {
                LockInfo lockInfo = this.ensureLockAndGetInfo(nav.getResource());
                if (nav.getResource().equals(entryFolder) || !lockInfo.wasJustLocked()) continue;
                needToUnlock.add(nav.getResource());
            }
            for (CmsJspNavElement nav : navs) {
                CmsProperty property = new CmsProperty("NavPos", "" + nav.getNavPosition(), null);
                cms.writePropertyObject(cms.getSitePath(nav.getResource()), property);
            }
        }
        finally {
            for (CmsResource lockedRes : needToUnlock) {
                try {
                    cms.unlockResource(lockedRes);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private CmsClientProperty createClientProperty(CmsProperty prop, boolean preserveOrigin) {
        CmsClientProperty result = new CmsClientProperty(prop.getName(), prop.getStructureValue(), prop.getResourceValue());
        if (preserveOrigin) {
            result.setOrigin(prop.getOrigin());
        }
        return result;
    }

    private CmsClientSitemapEntry createNewEntry(String entryPoint, CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsClientSitemapEntry newEntry = null;
        if (change.getParentId() != null) {
            CmsResource parentFolder = cms.readResource(change.getParentId());
            String entryPath = "";
            CmsResource entryFolder = null;
            CmsResource newRes = null;
            byte[] content = null;
            List<CmsProperty> properties = Collections.emptyList();
            CmsResource copyPage = null;
            if (change.getNewCopyResourceId() != null) {
                copyPage = cms.readResource(change.getNewCopyResourceId());
                content = cms.readFile(copyPage).getContents();
                properties = cms.readPropertyObjects(copyPage, false);
            }
            if (this.isRedirectType(change.getNewResourceTypeId())) {
                entryPath = CmsStringUtil.joinPaths(cms.getSitePath(parentFolder), change.getName());
                newRes = cms.createResource(entryPath, change.getNewResourceTypeId(), null, Collections.singletonList(new CmsProperty("Title", change.getName(), null)));
                cms.writePropertyObjects(newRes, this.generateInheritProperties(change, newRes));
                this.applyNavigationChanges(change, newRes);
            } else {
                boolean isContainerPage;
                boolean idWasNull;
                String entryFolderPath = CmsStringUtil.joinPaths(cms.getSitePath(parentFolder), change.getName() + "/");
                boolean bl = idWasNull = change.getEntryId() == null;
                if (idWasNull) {
                    change.setEntryId(new CmsUUID());
                }
                boolean isFunctionDetail = change.getCreateParameter() != null && CmsUUID.isValidUUID(change.getCreateParameter());
                entryFolder = new CmsResource(change.getEntryId(), new CmsUUID(), entryFolderPath, CmsResourceTypeFolder.getStaticTypeId(), true, 0, cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, System.currentTimeMillis(), cms.getRequestContext().getCurrentUser().getId(), System.currentTimeMillis(), cms.getRequestContext().getCurrentUser().getId(), 0L, Long.MAX_VALUE, 1, 0, System.currentTimeMillis(), 0);
                entryFolder = cms.createResource(entryFolderPath, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId(), null, this.generateInheritProperties(change, entryFolder));
                if (idWasNull) {
                    change.setEntryId(entryFolder.getStructureId());
                }
                this.applyNavigationChanges(change, entryFolder);
                entryPath = CmsStringUtil.joinPaths(entryFolderPath, "index.html");
                boolean bl2 = isContainerPage = change.getNewResourceTypeId() == CmsResourceTypeXmlContainerPage.getContainerPageTypeIdSafely();
                if (isContainerPage && copyPage != null) {
                    CmsXmlContainerPage page = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(copyPage), true, true);
                    this.ensureSingleLocale(page, entryFolder);
                    if (isFunctionDetail) {
                        String functionDetailContainer = this.getFunctionDetailContainerName(parentFolder);
                        CmsUUID functionStructureId = new CmsUUID(change.getCreateParameter());
                        CmsResource functionFormatter = cms.readResource("/system/modules/org.opencms.ade.containerpage/formatters/function.jsp");
                        this.addFunctionDetailElement(cms, page, functionDetailContainer, functionStructureId, functionFormatter.getStructureId());
                    }
                    content = page.marshal();
                }
                newRes = cms.createResource(entryPath, change.getNewResourceTypeId(), content, properties);
                cms.writePropertyObjects(newRes, this.generateOwnProperties(change));
            }
            if (entryFolder != null) {
                this.tryUnlock(entryFolder);
                newEntry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(cms.getSitePath(entryFolder)), false);
            }
            this.tryUnlock(newRes);
            if (newEntry == null) {
                newEntry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(cms.getSitePath(newRes)), false);
            }
            newEntry.setPosition(-1);
            change.getClipBoardData().getModifications().remove(null);
            change.getClipBoardData().getModifications().put(newEntry.getId(), newEntry);
        }
        return newEntry;
    }

    private CmsNewResourceInfo createNewResourceInfo(CmsObject cms, CmsResource modelResource, Locale locale) throws CmsException {
        int typeId = modelResource.getTypeId();
        String name = OpenCms.getResourceManager().getResourceType(typeId).getTypeName();
        String title = cms.readPropertyObject(modelResource, "Title", false).getValue();
        String description = cms.readPropertyObject(modelResource, "Description", false).getValue();
        try {
            CmsGallerySearchResult result = CmsGallerySearch.searchById(cms, modelResource.getStructureId(), locale);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(result.getTitle())) {
                title = result.getTitle();
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(result.getDescription())) {
                description = result.getDescription();
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        boolean editable = false;
        try {
            CmsResource freshModelResource = cms.readResource(modelResource.getStructureId());
            editable = cms.hasPermissions(freshModelResource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.DEFAULT);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsNewResourceInfo info = new CmsNewResourceInfo(typeId, name, title, description, modelResource.getStructureId(), editable, description);
        Float navpos = null;
        try {
            CmsProperty navposProp = cms.readPropertyObject(modelResource, "NavPos", true);
            String navposStr = navposProp.getValue();
            if (navposStr != null) {
                try {
                    navpos = Float.valueOf(navposStr);
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        info.setNavPos(navpos);
        info.setDate(CmsDateUtil.getDate(new Date(modelResource.getDateLastModified()), 1, this.getWorkplaceLocale()));
        info.setVfsPath(modelResource.getRootPath());
        return info;
    }

    private CmsNewResourceInfo createResourceTypeInfo(I_CmsResourceType resType, CmsResource copyResource) {
        String name = resType.getTypeName();
        Locale locale = this.getWorkplaceLocale();
        if (copyResource != null) {
            return new CmsNewResourceInfo(copyResource.getTypeId(), name, CmsWorkplaceMessages.getResourceTypeName(locale, name), CmsWorkplaceMessages.getResourceTypeDescription(locale, name), copyResource.getStructureId(), false, CmsWorkplaceMessages.getResourceTypeName(locale, name));
        }
        return new CmsNewResourceInfo(resType.getTypeId(), name, CmsWorkplaceMessages.getResourceTypeName(locale, name), CmsWorkplaceMessages.getResourceTypeDescription(locale, name), null, false, CmsWorkplaceMessages.getResourceTypeName(locale, name));
    }

    private CmsClientSitemapEntry delete(CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource resource = cms.readResource(change.getEntryId());
        this.ensureLock(resource);
        cms.deleteResource(cms.getSitePath(resource), CmsResource.DELETE_PRESERVE_SIBLINGS);
        this.tryUnlock(resource);
        return null;
    }

    private CmsClientLock generateClientLock(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsLock lock = cms.getLock(resource);
        CmsClientLock clientLock = new CmsClientLock();
        clientLock.setLockType(CmsClientLock.LockType.valueOf(lock.getType().getMode()));
        CmsUUID ownerId = lock.getUserId();
        if (!lock.isUnlocked() && ownerId != null) {
            clientLock.setLockOwner(cms.readUser(ownerId).getDisplayName(cms, cms.getRequestContext().getLocale()));
            clientLock.setOwnedByUser(cms.getRequestContext().getCurrentUser().getId().equals(ownerId));
        }
        return clientLock;
    }

    private List<CmsProperty> generateInheritProperties(CmsSitemapChange change, CmsResource entryFolder) {
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
        Map<String, CmsClientProperty> clientProps = change.getOwnInternalProperties();
        if (clientProps != null) {
            for (CmsClientProperty clientProp : clientProps.values()) {
                CmsProperty prop = new CmsProperty(clientProp.getName(), clientProp.getStructureValue(), clientProp.getResourceValue());
                result.add(prop);
            }
        }
        result.add(new CmsProperty("Title", change.getName(), null));
        return result;
    }

    private List<CmsProperty> generateOwnProperties(CmsSitemapChange change) {
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
        Map<String, CmsClientProperty> clientProps = change.getDefaultFileProperties();
        if (clientProps != null) {
            for (CmsClientProperty clientProp : clientProps.values()) {
                CmsProperty prop = new CmsProperty(clientProp.getName(), clientProp.getStructureValue(), clientProp.getResourceValue());
                result.add(prop);
            }
        }
        result.add(new CmsProperty("Title", change.getName(), null));
        return result;
    }

    private Map<String, CmsClientProperty> generateParentProperties(String rootPath) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (rootPath == null) {
            rootPath = cms.getRequestContext().addSiteRoot("/");
        }
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        String parentRootPath = CmsResource.getParentFolder(rootPath);
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        if (parentRootPath != null) {
            List<CmsProperty> props = rootCms.readPropertyObjects(parentRootPath, true);
            for (CmsProperty prop : props) {
                CmsClientProperty clientProp = this.createClientProperty(prop, true);
                result.put(clientProp.getName(), clientProp);
            }
        }
        return result;
    }

    private List<CmsClientSitemapEntry> getChildren(String root, int levels) throws CmsException {
        ArrayList<CmsClientSitemapEntry> children = new ArrayList<CmsClientSitemapEntry>();
        int i = 0;
        for (CmsJspNavElement navElement : this.getNavBuilder().getNavigationForFolder(root, true)) {
            CmsClientSitemapEntry child = this.toClientEntry(navElement, false);
            if (child == null) continue;
            child.setPosition(i);
            children.add(child);
            if (child.isFolderType() && (levels > 1 || levels == -1) && !this.isSubSitemap(navElement)) {
                child.setSubEntries(this.getChildren(child.getSitePath(), levels - 1));
                child.setChildrenLoadedInitially(true);
            }
            ++i;
        }
        return children;
    }

    private CmsSitemapClipboardData getClipboardData() {
        CmsSitemapClipboardData result = new CmsSitemapClipboardData();
        result.setModifications(this.getModifiedList());
        result.setDeletions(this.getDeletedList());
        return result;
    }

    private LinkedHashMap<CmsUUID, CmsClientSitemapEntry> getDeletedList() {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        Object obj = user.getAdditionalInfo(ADDINFO_ADE_DELETED_LIST);
        LinkedHashMap<CmsUUID, CmsClientSitemapEntry> result = new LinkedHashMap<CmsUUID, CmsClientSitemapEntry>();
        if (obj instanceof String) {
            try {
                JSONArray array = new JSONArray((String)obj);
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        CmsUUID delId = new CmsUUID(array.getString(i));
                        CmsResource res = cms.readResource(delId, CmsResourceFilter.ALL);
                        if (!res.getState().isDeleted()) continue;
                        CmsClientSitemapEntry delEntry = new CmsClientSitemapEntry();
                        delEntry.setSitePath(cms.getSitePath(res));
                        delEntry.setOwnProperties(this.getClientProperties(cms, res, false));
                        delEntry.setName(res.getName());
                        delEntry.setVfsPath(cms.getSitePath(res));
                        delEntry.setEntryType(res.isFolder() ? CmsClientSitemapEntry.EntryType.folder : (this.isRedirectType(res.getTypeId()) ? CmsClientSitemapEntry.EntryType.redirect : CmsClientSitemapEntry.EntryType.leaf));
                        result.put(delId, delEntry);
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        }
        return result;
    }

    private int getEntryPointType() throws CmsException {
        return OpenCms.getResourceManager().getResourceType("subsitemap").getTypeId();
    }

    private String getFunctionDetailContainerName(CmsResource parent) {
        try {
            CmsResource templateRes;
            CmsObject cms = this.getCmsObject();
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            CmsProperty templateProp = cms.readPropertyObject(parent, "template", true);
            String templateVal = templateProp.getValue();
            if (templateVal == null) {
                return null;
            }
            try {
                templateRes = cms.readResource(templateVal);
            }
            catch (CmsVfsResourceNotFoundException e) {
                templateRes = rootCms.readResource(templateVal);
            }
            CmsProperty containerInfoProp = cms.readPropertyObject(templateRes, "container.info", true);
            String containerInfo = containerInfoProp.getValue() == null ? "" : containerInfoProp.getValue();
            Map<String, String> attrs = CmsStringUtil.splitAsMap(containerInfo, "|", "=");
            String functionDetailContainerName = attrs.get(KEY_FUNCTION_DETAIL);
            return functionDetailContainerName;
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private LinkedHashMap<CmsUUID, CmsClientSitemapEntry> getModifiedList() {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        Object obj = user.getAdditionalInfo(ADDINFO_ADE_MODIFIED_LIST);
        LinkedHashMap<CmsUUID, CmsClientSitemapEntry> result = new LinkedHashMap<CmsUUID, CmsClientSitemapEntry>();
        if (obj instanceof String) {
            try {
                JSONArray array = new JSONArray((String)obj);
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        CmsUUID modId = new CmsUUID(array.getString(i));
                        CmsResource res = cms.readResource(modId);
                        String sitePath = cms.getSitePath(res);
                        CmsJspNavElement navEntry = this.getNavBuilder().getNavigationForResource(sitePath);
                        if (!navEntry.isInNavigation()) continue;
                        CmsClientSitemapEntry modEntry = this.toClientEntry(navEntry, false);
                        result.put(modId, modEntry);
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        }
        return result;
    }

    private CmsJspNavBuilder getNavBuilder() {
        if (this.m_navBuilder == null) {
            this.m_navBuilder = new CmsJspNavBuilder(this.getCmsObject());
        }
        return this.m_navBuilder;
    }

    private List<CmsNewResourceInfo> getNewResourceInfos(CmsObject cms, CmsADEConfigData configData, Locale locale) throws CmsException {
        ArrayList<CmsNewResourceInfo> result = new ArrayList<CmsNewResourceInfo>();
        for (CmsModelPageConfig modelConfig : configData.getModelPages()) {
            result.add(this.createNewResourceInfo(cms, modelConfig.getResource(), locale));
        }
        Collections.sort(result, new Comparator<CmsNewResourceInfo>(){

            @Override
            public int compare(CmsNewResourceInfo a, CmsNewResourceInfo b) {
                return ComparisonChain.start().compare((Object)a.getNavPos(), (Object)b.getNavPos(), (Comparator)Ordering.natural().nullsLast()).result();
            }
        });
        return result;
    }

    private List<String> getPropertyNames(CmsObject cms) throws CmsException {
        List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
        ArrayList<String> result = new ArrayList<String>();
        for (CmsPropertyDefinition propDef : propDefs) {
            result.add(propDef.getName());
        }
        return result;
    }

    private List<CmsNewResourceInfo> getResourceTypeInfos(CmsObject cms, CmsADEConfigData configData, Locale locale) {
        ArrayList<CmsNewResourceInfo> result = new ArrayList<CmsNewResourceInfo>();
        for (CmsResourceTypeConfig typeConfig : configData.getResourceTypes()) {
            if (typeConfig.isDetailPagesDisabled()) continue;
            String typeName = typeConfig.getTypeName();
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeName);
                result.add(this.createResourceTypeInfo(resourceType, configData.getDefaultModelPage().getResource()));
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        List<CmsFunctionReference> functionRefs = configData.getFunctionReferences();
        for (CmsFunctionReference functionRef : functionRefs) {
            try {
                String description;
                CmsResource functionRes = cms.readResource(functionRef.getStructureId());
                String subtitle = description = cms.readPropertyObject(functionRes, "Description", false).getValue();
                try {
                    CmsGallerySearchResult searchResult = CmsGallerySearch.searchById(cms, functionRef.getStructureId(), this.getWorkplaceLocale());
                    subtitle = searchResult.getDescription();
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                CmsNewResourceInfo info = new CmsNewResourceInfo(configData.getDefaultModelPage().getResource().getTypeId(), "function@" + functionRef.getName(), functionRef.getName(), description, configData.getDefaultModelPage().getResource().getStructureId(), false, subtitle);
                info.setAdditionalData(functionRef.getStructureId().toString());
                info.setIsFunction(true);
                result.add(info);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private CmsClientSitemapEntry getRootEntry(String rootPath) throws CmsSecurityException, CmsException {
        CmsJspNavElement navElement;
        CmsClientSitemapEntry result;
        String sitePath = "/";
        if (rootPath != null) {
            sitePath = this.getCmsObject().getRequestContext().removeSiteRoot(rootPath);
        }
        if ((result = this.toClientEntry(navElement = this.getNavBuilder().getNavigationForResource(sitePath), true)) != null) {
            result.setPosition(0);
            result.setChildrenLoadedInitially(true);
            result.setSubEntries(this.getChildren(sitePath, 1));
        }
        return result;
    }

    private CmsSitemapInfo getSitemapInfo(String basePath) throws CmsException {
        String description;
        CmsObject cms = this.getCmsObject();
        CmsResource baseFolder = cms.readResource(cms.getRequestContext().removeSiteRoot(basePath));
        CmsResource defaultFile = cms.readDefaultFile(baseFolder);
        String title = cms.readPropertyObject(baseFolder, "Title", false).getValue();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title) && defaultFile != null) {
            title = cms.readPropertyObject(defaultFile, "Title", false).getValue();
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(description = cms.readPropertyObject(baseFolder, "Description", false).getValue()) && defaultFile != null) {
            description = cms.readPropertyObject(defaultFile, "Description", false).getValue();
        }
        return new CmsSitemapInfo(cms.getRequestContext().getCurrentProject().getName(), description, OpenCms.getLocaleManager().getDefaultLocale(cms, baseFolder).toString(), OpenCms.getSiteManager().getCurrentSite(cms).getUrl() + OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, basePath), title);
    }

    private Locale getWorkplaceLocale() {
        Locale result = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        if (result == null) {
            result = CmsLocaleManager.getDefaultLocale();
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }

    private boolean hasDefaultFileChanges(CmsSitemapChange change) {
        return change.getDefaultFileId() != null && !change.isNew();
    }

    private boolean hasOwnChanges(CmsSitemapChange change) {
        return !change.isNew();
    }

    private boolean isDefaultFile(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (resource.isFolder()) {
            return false;
        }
        String parentPath = CmsResource.getParentFolder(cms.getSitePath(resource));
        CmsResource defaultFile = cms.readDefaultFile(parentPath);
        return resource.equals(defaultFile);
    }

    private boolean isDisplayToolbar(HttpServletRequest request) {
        boolean displayToolbar = true;
        if (CmsHistoryResourceHandler.isHistoryRequest((ServletRequest)request)) {
            displayToolbar = false;
        }
        return displayToolbar;
    }

    private boolean isRedirectType(int typeId) {
        try {
            return typeId == OpenCms.getResourceManager().getResourceType(RECOURCE_TYPE_NAME_REDIRECT).getTypeId();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSubSitemap(CmsJspNavElement navElement) throws CmsException {
        return navElement.getResource().getTypeId() == this.getEntryPointType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyEntry(CmsSitemapChange change) throws CmsException {
        CmsResource entryFolder;
        block17: {
            CmsObject cms = this.getCmsObject();
            CmsResource entryPage = null;
            entryFolder = null;
            CmsResource ownRes = null;
            CmsResource defaultFileRes = null;
            try {
                if (this.hasOwnChanges(change)) {
                    ownRes = cms.readResource(change.getEntryId());
                    this.ensureLock(ownRes);
                }
                if (this.hasDefaultFileChanges(change)) {
                    defaultFileRes = cms.readResource(change.getDefaultFileId());
                    this.ensureLock(defaultFileRes);
                }
                if (ownRes != null && ownRes.isFolder()) {
                    entryFolder = ownRes;
                }
                if (ownRes != null && ownRes.isFile()) {
                    entryPage = ownRes;
                }
                if (defaultFileRes != null) {
                    entryPage = defaultFileRes;
                }
                if (change.isLeafType()) {
                    entryFolder = entryPage;
                }
                this.updateProperties(cms, ownRes, defaultFileRes, change.getPropertyChanges());
                if (change.hasChangedPosition()) {
                    this.updateNavPos(ownRes, change);
                }
                if (entryFolder != null && (change.hasNewParent() || change.hasChangedName())) {
                    String destinationPath;
                    if (change.hasNewParent()) {
                        CmsResource futureParent = cms.readResource(change.getParentId());
                        destinationPath = CmsStringUtil.joinPaths(cms.getSitePath(futureParent), change.getName());
                    } else {
                        destinationPath = CmsStringUtil.joinPaths(CmsResource.getParentFolder(cms.getSitePath(entryFolder)), change.getName());
                    }
                    if (change.isLeafType() && destinationPath.endsWith("/")) {
                        destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
                    }
                    if (!cms.getSitePath(entryFolder).equals(destinationPath)) {
                        cms.moveResource(cms.getSitePath(entryFolder), destinationPath);
                    }
                    entryFolder = cms.readResource(entryFolder.getStructureId());
                }
                if (entryPage == null) break block17;
            }
            catch (Throwable throwable) {
                if (entryPage != null) {
                    this.tryUnlock(entryPage);
                }
                if (entryFolder != null) {
                    this.tryUnlock(entryFolder);
                }
                throw throwable;
            }
            this.tryUnlock(entryPage);
        }
        if (entryFolder != null) {
            this.tryUnlock(entryFolder);
        }
    }

    private void removeAllLocalesExcept(CmsXmlContainerPage page, Locale localeToKeep) throws CmsXmlException {
        List<Locale> locales = page.getLocales();
        for (Locale locale : locales) {
            if (locale.equals(localeToKeep)) continue;
            page.removeLocale(locale);
        }
    }

    private CmsClientSitemapEntry removeEntryFromNavigation(CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource entryFolder = cms.readResource(change.getEntryId());
        this.ensureLock(entryFolder);
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>();
        properties.add(new CmsProperty("NavText", "", ""));
        properties.add(new CmsProperty("NavPos", "", ""));
        cms.writePropertyObjects(cms.getSitePath(entryFolder), properties);
        this.tryUnlock(entryFolder);
        return null;
    }

    private void saveDetailPages(List<CmsDetailPageInfo> detailPages, CmsResource resource, CmsUUID newId) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsDetailPageConfigurationWriter writer = new CmsDetailPageConfigurationWriter(cms, resource);
        writer.updateAndSave(detailPages, newId);
    }

    private void setClipboardData(CmsSitemapClipboardData clipboardData) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        if (clipboardData != null) {
            JSONArray modified = new JSONArray();
            if (clipboardData.getModifications() != null) {
                for (CmsUUID id : clipboardData.getModifications().keySet()) {
                    if (id == null) continue;
                    modified.put(id.toString());
                }
            }
            user.setAdditionalInfo(ADDINFO_ADE_MODIFIED_LIST, modified.toString());
            JSONArray deleted = new JSONArray();
            if (clipboardData.getDeletions() != null) {
                for (CmsUUID id : clipboardData.getDeletions().keySet()) {
                    if (id == null) continue;
                    deleted.put(id.toString());
                }
            }
            user.setAdditionalInfo(ADDINFO_ADE_DELETED_LIST, deleted.toString());
            cms.writeUser(user);
        }
    }

    private boolean shouldChangeDefaultFileTitle(Map<String, CmsProperty> properties, CmsProperty folderNavtext) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || folderNavtext != null && properties.get("Title").getValue().equals(folderNavtext.getValue());
    }

    private boolean shouldChangeTitle(Map<String, CmsProperty> properties) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || properties.get("NavText") != null && properties.get("Title").getValue().equals(properties.get("NavText").getValue());
    }

    private CmsClientSitemapEntry toClientEntry(CmsJspNavElement navElement, boolean isRoot) throws CmsException {
        CmsResource entryPage = null;
        CmsObject cms = this.getCmsObject();
        CmsClientSitemapEntry clientEntry = new CmsClientSitemapEntry();
        CmsResource entryFolder = null;
        CmsResource ownResource = navElement.getResource();
        CmsResource defaultFileResource = null;
        if (ownResource.isFolder()) {
            defaultFileResource = cms.readDefaultFile(ownResource);
        }
        Map<String, CmsClientProperty> ownProps = this.getClientProperties(cms, ownResource, false);
        HashMap<String, CmsClientProperty> defaultFileProps = null;
        if (defaultFileResource != null) {
            defaultFileProps = this.getClientProperties(cms, defaultFileResource, false);
            clientEntry.setDefaultFileId(defaultFileResource.getStructureId());
            clientEntry.setDefaultFileType(OpenCms.getResourceManager().getResourceType(defaultFileResource.getTypeId()).getTypeName());
        } else {
            defaultFileProps = new HashMap();
        }
        boolean isDefault = this.isDefaultFile(ownResource);
        clientEntry.setId(ownResource.getStructureId());
        clientEntry.setFolderDefaultPage(isDefault);
        if (navElement.getResource().isFolder()) {
            CmsLock folderLock;
            entryFolder = navElement.getResource();
            entryPage = defaultFileResource;
            clientEntry.setName(entryFolder.getName());
            if (entryPage == null) {
                entryPage = entryFolder;
            }
            if (!isRoot && this.isSubSitemap(navElement)) {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.subSitemap);
                clientEntry.setDefaultFileType(null);
            }
            clientEntry.setHasForeignFolderLock(!(folderLock = cms.getLock(entryFolder)).isUnlocked() && !folderLock.isOwnedBy(cms.getRequestContext().getCurrentUser()));
            if (!cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                List<CmsResource> blockingChildren = cms.getBlockingLockedResources(entryFolder);
                clientEntry.setBlockingLockedChildren(blockingChildren != null && !blockingChildren.isEmpty());
            }
        } else {
            entryPage = navElement.getResource();
            clientEntry.setName(entryPage.getName());
            if (this.isRedirectType(entryPage.getTypeId())) {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.redirect);
            } else {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.leaf);
            }
        }
        String path = cms.getSitePath(entryPage);
        clientEntry.setVfsPath(path);
        clientEntry.setOwnProperties(ownProps);
        clientEntry.setDefaultFileProperties(defaultFileProps);
        clientEntry.setSitePath(entryFolder != null ? cms.getSitePath(entryFolder) : path);
        clientEntry.setLock(this.generateClientLock(entryPage));
        clientEntry.setInNavigation(isRoot || navElement.isInNavigation());
        String type = OpenCms.getResourceManager().getResourceType(ownResource).getTypeName();
        clientEntry.setResourceTypeName(type);
        return clientEntry;
    }

    private CmsClientSitemapEntry undelete(CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource deleted = cms.readResource(change.getEntryId(), CmsResourceFilter.ALL);
        if (deleted.getState().isDeleted()) {
            this.ensureLock(deleted);
            cms.undeleteResource(this.getCmsObject().getSitePath(deleted), true);
            this.tryUnlock(deleted);
        }
        return null;
    }

    private void updateNavPos(CmsResource res, CmsSitemapChange change) throws CmsException {
        if (change.hasChangedPosition()) {
            this.applyNavigationChanges(change, res);
        }
    }

    private void updateProperties(CmsObject cms, CmsResource ownRes, CmsResource defaultFileRes, List<CmsPropertyModification> propertyModifications) throws CmsException {
        Map<String, CmsProperty> ownProps = this.getPropertiesByName(cms.readPropertyObjects(ownRes, false));
        boolean changeOwnTitle = this.shouldChangeTitle(ownProps);
        boolean changeDefaultFileTitle = false;
        Map<String, CmsProperty> defaultFileProps = Collections.emptyMap();
        if (defaultFileRes != null) {
            defaultFileProps = this.getPropertiesByName(cms.readPropertyObjects(defaultFileRes, false));
            changeDefaultFileTitle = this.shouldChangeDefaultFileTitle(defaultFileProps, ownProps.get("NavText"));
        }
        String hasNavTextChange = null;
        ArrayList<CmsProperty> ownPropertyChanges = new ArrayList<CmsProperty>();
        ArrayList<CmsProperty> defaultFilePropertyChanges = new ArrayList<CmsProperty>();
        for (CmsPropertyModification propMod : propertyModifications) {
            CmsProperty propToModify = null;
            if (ownRes.getStructureId().equals(propMod.getId())) {
                if ("NavText".equals(propMod.getName())) {
                    hasNavTextChange = propMod.getValue();
                } else if ("Title".equals(propMod.getName())) {
                    changeOwnTitle = false;
                }
                propToModify = ownProps.get(propMod.getName());
                if (propToModify == null) {
                    propToModify = new CmsProperty(propMod.getName(), null, null);
                }
                ownPropertyChanges.add(propToModify);
            } else {
                if ("Title".equals(propMod.getName())) {
                    changeDefaultFileTitle = false;
                }
                if ((propToModify = defaultFileProps.get(propMod.getName())) == null) {
                    propToModify = new CmsProperty(propMod.getName(), null, null);
                }
                defaultFilePropertyChanges.add(propToModify);
            }
            String newValue = propMod.getValue();
            if (newValue == null) {
                newValue = "";
            }
            if (propMod.isStructureValue()) {
                propToModify.setStructureValue(newValue);
                continue;
            }
            propToModify.setResourceValue(newValue);
        }
        if (hasNavTextChange != null) {
            CmsProperty titleProp;
            if (changeOwnTitle) {
                titleProp = ownProps.get("Title");
                if (titleProp == null) {
                    titleProp = new CmsProperty("Title", null, null);
                }
                titleProp.setStructureValue(hasNavTextChange);
                ownPropertyChanges.add(titleProp);
            }
            if (changeDefaultFileTitle) {
                titleProp = defaultFileProps.get("Title");
                if (titleProp == null) {
                    titleProp = new CmsProperty("Title", null, null);
                }
                titleProp.setStructureValue(hasNavTextChange);
                defaultFilePropertyChanges.add(titleProp);
            }
        }
        if (!ownPropertyChanges.isEmpty()) {
            cms.writePropertyObjects(ownRes, ownPropertyChanges);
        }
        if (!defaultFilePropertyChanges.isEmpty() && defaultFileRes != null) {
            cms.writePropertyObjects(defaultFileRes, defaultFilePropertyChanges);
        }
    }

    protected class LockInfo {
        private CmsLock m_lock;
        private boolean m_wasJustLocked;

        public LockInfo(CmsLock lock, boolean wasJustLocked) {
            this.m_lock = lock;
            this.m_wasJustLocked = wasJustLocked;
        }

        public CmsLock getLock() {
            return this.m_lock;
        }

        public boolean wasJustLocked() {
            return this.m_wasJustLocked;
        }
    }
}

