/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.ade.sitemap.shared.I_CmsSitemapController;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.CmsClientLock;
import org.opencms.gwt.shared.CmsLinkBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsClientSitemapEntry
implements IsSerializable {
    private String m_cachedExportName;
    private boolean m_childrenLoadedInitially;
    private CmsUUID m_defaultFileId;
    private Map<String, CmsClientProperty> m_defaultFileProperties = new HashMap<String, CmsClientProperty>();
    private String m_defaultFileType;
    private String m_detailpageTypeName;
    private EditStatus m_editStatus = EditStatus.normal;
    private EntryType m_entryType;
    private boolean m_hasBlockingLockedChildren;
    private boolean m_hasForeignFolderLock;
    private CmsUUID m_id;
    private boolean m_inNavigation;
    private boolean m_isFolderDefaultPage;
    private CmsClientLock m_lock;
    private String m_name;
    private boolean m_new;
    private Map<String, CmsClientProperty> m_ownProperties = new HashMap<String, CmsClientProperty>();
    private int m_position;
    private String m_resourceTypeName;
    private String m_sitePath;
    private List<CmsClientSitemapEntry> m_subEntries = new ArrayList<CmsClientSitemapEntry>();
    private String m_vfsPath;

    public CmsClientSitemapEntry() {
        this.m_entryType = EntryType.folder;
    }

    public CmsClientSitemapEntry(CmsClientSitemapEntry clone) {
        this();
        this.copyMembers(clone);
        this.setPosition(clone.getPosition());
    }

    public void addSubEntry(CmsClientSitemapEntry entry) {
        entry.setPosition(this.m_subEntries.size());
        entry.updateSitePath(CmsStringUtil.joinPaths(this.m_sitePath, entry.getName()));
        entry.setFolderDefaultPage(entry.isLeafType() && this.getVfsPath().equals(entry.getVfsPath()));
        this.m_subEntries.add(entry);
    }

    public boolean getChildrenLoadedInitially() {
        return this.m_childrenLoadedInitially;
    }

    public CmsUUID getDefaultFileId() {
        return this.m_defaultFileId;
    }

    public Map<String, CmsClientProperty> getDefaultFileProperties() {
        return this.m_defaultFileProperties;
    }

    public String getDefaultFileType() {
        return this.m_defaultFileType;
    }

    public String getDetailpageTypeName() {
        return this.m_detailpageTypeName;
    }

    public EditStatus getEditStatus() {
        return this.m_editStatus;
    }

    public EntryType getEntryType() {
        return this.m_entryType;
    }

    public String getExportName() {
        return this.m_cachedExportName;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public CmsClientLock getLock() {
        return this.m_lock;
    }

    public String getName() {
        return this.m_name;
    }

    public Map<String, CmsClientProperty> getOwnProperties() {
        return this.m_ownProperties;
    }

    public int getPosition() {
        return this.m_position;
    }

    public String getResourceTypeName() {
        return this.m_resourceTypeName;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public List<CmsClientSitemapEntry> getSubEntries() {
        return this.m_subEntries;
    }

    public String getTitle() {
        CmsClientProperty navtext = this.m_ownProperties.get("NavText");
        if (!CmsClientProperty.isPropertyEmpty(navtext)) {
            return navtext.getEffectiveValue();
        }
        CmsClientProperty title = this.m_ownProperties.get("Title");
        if (!CmsClientProperty.isPropertyEmpty(title)) {
            return title.getEffectiveValue();
        }
        return this.m_name;
    }

    public String getVfsPath() {
        return this.m_vfsPath;
    }

    public boolean hasBlockingLockedChildren() {
        return this.m_hasBlockingLockedChildren;
    }

    public boolean hasForeignFolderLock() {
        return this.m_hasForeignFolderLock;
    }

    public boolean hasInternalRedirect() {
        return false;
    }

    public void initialize(I_CmsSitemapController controller) {
        this.m_ownProperties = controller.replaceProperties(this.m_id, this.m_ownProperties);
        this.m_defaultFileProperties = controller.replaceProperties(this.m_defaultFileId, this.m_defaultFileProperties);
    }

    public void initializeAll(I_CmsSitemapController controller) {
        this.initialize(controller);
        for (CmsClientSitemapEntry child : this.m_subEntries) {
            child.initializeAll(controller);
        }
    }

    public void insertSubEntry(CmsClientSitemapEntry entry, int position) {
        entry.updateSitePath(CmsStringUtil.joinPaths(this.m_sitePath, entry.getName()));
        this.m_subEntries.add(position, entry);
        this.updatePositions(position);
    }

    public boolean isEditable() {
        return !this.hasForeignFolderLock() && !this.hasBlockingLockedChildren() && (this.getLock() == null || this.getLock().getLockOwner() == null || this.getLock().isOwnedByUser());
    }

    public boolean isFolderDefaultPage() {
        return this.m_isFolderDefaultPage;
    }

    public boolean isFolderType() {
        return EntryType.folder == this.m_entryType;
    }

    public boolean isInNavigation() {
        return this.m_inNavigation;
    }

    public boolean isLeafType() {
        return EntryType.leaf == this.m_entryType || EntryType.redirect == this.m_entryType;
    }

    public boolean isNew() {
        return this.m_new;
    }

    public boolean isRoot() {
        return this.m_name.equals("");
    }

    public boolean isSubSitemapType() {
        return EntryType.subSitemap == this.m_entryType;
    }

    public void normalizeProperties() {
        CmsClientProperty.removeEmptyProperties(this.m_ownProperties);
        if (this.m_defaultFileProperties != null) {
            CmsClientProperty.removeEmptyProperties(this.m_defaultFileProperties);
        }
    }

    public CmsClientSitemapEntry removeSubEntry(int position) {
        CmsClientSitemapEntry removed = this.m_subEntries.remove(position);
        this.updatePositions(position);
        return removed;
    }

    public void setBlockingLockedChildren(boolean hasBlockingLockedChildren) {
        this.m_hasBlockingLockedChildren = hasBlockingLockedChildren;
    }

    public void setChildrenLoadedInitially(boolean childrenLoaded) {
        this.m_childrenLoadedInitially = childrenLoaded;
    }

    public void setDefaultFileId(CmsUUID defaultFileId) {
        this.m_defaultFileId = defaultFileId;
    }

    public void setDefaultFileProperties(Map<String, CmsClientProperty> properties) {
        this.m_defaultFileProperties = properties;
    }

    public void setDefaultFileType(String defaultFileType) {
        this.m_defaultFileType = defaultFileType;
    }

    public void setDetailpageTypeName(String detailpageTypeName) {
        this.m_detailpageTypeName = detailpageTypeName;
    }

    public void setEdited() {
        if (this.m_editStatus == EditStatus.normal) {
            this.m_editStatus = EditStatus.edited;
        }
    }

    public void setEditStatus(EditStatus status) {
        this.m_editStatus = status;
    }

    public void setEntryType(EntryType entryType) {
        this.m_entryType = entryType;
    }

    public void setExportName(String exportName) {
        this.m_cachedExportName = exportName;
    }

    public void setFolderDefaultPage(boolean isFolderDefaultPage) {
        this.m_isFolderDefaultPage = isFolderDefaultPage;
    }

    public void setHasForeignFolderLock(boolean hasForeignFolderLock) {
        this.m_hasForeignFolderLock = hasForeignFolderLock;
    }

    public void setId(CmsUUID id) {
        this.m_id = id;
    }

    public void setInNavigation(boolean inNavigation) {
        this.m_inNavigation = inNavigation;
    }

    public void setLock(CmsClientLock lock) {
        this.m_lock = lock;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNew(boolean new1) {
        this.m_new = new1;
    }

    public void setOwnProperties(Map<String, CmsClientProperty> properties) {
        this.m_ownProperties = properties;
    }

    public void setPosition(int position) {
        this.m_position = position;
    }

    public void setRedirect(CmsLinkBean info) {
    }

    public void setRedirect(String link, boolean internal) {
    }

    public void setResourceTypeName(String typeName) {
        this.m_resourceTypeName = typeName;
    }

    public void setSitePath(String sitePath) {
        this.m_sitePath = sitePath;
    }

    public void setSubEntries(List<CmsClientSitemapEntry> children) {
        this.m_childrenLoadedInitially = true;
        this.m_subEntries.clear();
        if (children != null) {
            this.m_subEntries.addAll(children);
            for (CmsClientSitemapEntry child : children) {
                child.updateSitePath(CmsStringUtil.joinPaths(this.m_sitePath, child.getName()));
            }
        }
    }

    public void setVfsPath(String path) {
        this.m_vfsPath = path;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sitePath).append("\n");
        for (CmsClientSitemapEntry child : this.m_subEntries) {
            sb.append(child.toString());
        }
        return sb.toString();
    }

    public void update(CmsClientSitemapEntry source) {
        this.copyMembers(source);
        if (source.getPosition() >= 0) {
            this.setPosition(source.getPosition());
        }
    }

    public void updateSitePath(String sitepath) {
        if (this.m_sitePath.equals(sitepath)) {
            return;
        }
        this.m_sitePath = sitepath;
        String name = CmsResource.getName(sitepath);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        this.m_name = name;
        for (CmsClientSitemapEntry child : this.m_subEntries) {
            child.updateSitePath(CmsStringUtil.joinPaths(sitepath, CmsResource.getName(child.getSitePath())));
        }
    }

    private void copyMembers(CmsClientSitemapEntry source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setOwnProperties(new HashMap<String, CmsClientProperty>(source.getOwnProperties()));
        this.setDefaultFileId(source.getDefaultFileId());
        this.setDefaultFileType(source.getDefaultFileType());
        Map<String, CmsClientProperty> defaultFileProperties = source.getDefaultFileProperties();
        if (defaultFileProperties == null) {
            defaultFileProperties = new HashMap<String, CmsClientProperty>();
        }
        this.setDefaultFileProperties(new HashMap<String, CmsClientProperty>(defaultFileProperties));
        if (source.getDetailpageTypeName() != null) {
            this.setDetailpageTypeName(source.getDetailpageTypeName());
        }
        this.setSitePath(source.getSitePath());
        this.setVfsPath(source.getVfsPath());
        this.setEditStatus(source.getEditStatus());
        this.setLock(source.getLock());
        this.setEntryType(source.getEntryType());
        this.setInNavigation(source.isInNavigation());
        this.setHasForeignFolderLock(source.hasForeignFolderLock());
        this.setBlockingLockedChildren(source.hasBlockingLockedChildren());
        this.setFolderDefaultPage(source.isFolderDefaultPage());
        this.setResourceTypeName(source.getResourceTypeName());
        this.setChildrenLoadedInitially(source.getChildrenLoadedInitially());
        this.setFolderDefaultPage(source.isFolderDefaultPage());
    }

    private void updatePositions(int position) {
        for (int i = position; i < this.m_subEntries.size(); ++i) {
            this.m_subEntries.get(i).setPosition(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        folder,
        leaf,
        redirect,
        subSitemap;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditStatus {
        created,
        edited,
        normal;

    }
}

