/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsVfsDiskCache {
    private String m_rfsRepository;

    public CmsVfsDiskCache(String basepath, String foldername) {
        this.m_rfsRepository = CmsFileUtil.normalizePath(basepath + foldername + File.separatorChar);
    }

    public static File saveFile(String rfsName, byte[] content) throws IOException {
        File f = new File(rfsName);
        File p = f.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        FileOutputStream fs = new FileOutputStream(f);
        fs.write(content);
        fs.close();
        return f;
    }

    public byte[] getCacheContent(String rfsName, long dateLastModified) {
        block3: {
            dateLastModified = this.simplifyDateLastModified(dateLastModified);
            try {
                File f = new File(rfsName);
                if (!f.exists()) break block3;
                if (f.lastModified() != dateLastModified) {
                    f.delete();
                    break block3;
                }
                return CmsFileUtil.readFile(f);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public String getCacheName(boolean online, String rootPath, String parameters) {
        String rfsName = CmsFileUtil.getRepositoryName(this.m_rfsRepository, rootPath, online);
        if (CmsStringUtil.isNotEmpty(parameters)) {
            String extension = CmsFileUtil.getExtension(rfsName);
            rfsName = CmsFileUtil.getRfsPath(rfsName, extension, parameters);
        }
        return rfsName;
    }

    public String getRepositoryPath() {
        return this.m_rfsRepository;
    }

    public void saveCacheFile(String rfsName, byte[] content, long dateLastModified) throws IOException {
        dateLastModified = this.simplifyDateLastModified(dateLastModified);
        File f = CmsVfsDiskCache.saveFile(rfsName, content);
        f.setLastModified(dateLastModified);
    }

    private long simplifyDateLastModified(long dateLastModified) {
        return dateLastModified / 1000L;
    }
}

