/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.List;
import org.opencms.db.CmsSubscriptionReadMode;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSubscriptionFilter
extends CmsVisitedByFilter {
    private List<CmsGroup> m_groups = new ArrayList<CmsGroup>();
    private CmsSubscriptionReadMode m_mode;

    public CmsSubscriptionFilter() {
        this.m_mode = CmsSubscriptionReadMode.UNVISITED;
    }

    public CmsSubscriptionFilter(CmsObject cms) {
        this(cms, false);
    }

    public CmsSubscriptionFilter(CmsObject cms, boolean addUserGroups) {
        super(cms);
        if (addUserGroups) {
            try {
                this.m_groups = cms.getGroupsOfUser(this.getUser().getName(), false);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        this.m_mode = CmsSubscriptionReadMode.UNVISITED;
    }

    public void addGroup(CmsGroup group) {
        this.m_groups.add(group);
    }

    @Override
    public Object clone() {
        CmsSubscriptionFilter filter = new CmsSubscriptionFilter();
        filter.setFromDate(this.getFromDate());
        filter.setParentPath(this.getParentPath());
        filter.setToDate(this.getToDate());
        if (this.getUser() != null) {
            filter.setUser(this.getUser());
        }
        filter.setGroups(this.getGroups());
        filter.setMode(this.getMode());
        return filter;
    }

    public List<CmsGroup> getGroups() {
        return this.m_groups;
    }

    public CmsSubscriptionReadMode getMode() {
        return this.m_mode;
    }

    public void setGroups(List<CmsGroup> groups) {
        this.m_groups = groups;
    }

    public void setMode(CmsSubscriptionReadMode mode) {
        this.m_mode = mode;
    }

    public void setUserGroups(CmsObject cms) {
        if (this.getUser() != null) {
            try {
                this.m_groups = cms.getGroupsOfUser(this.getUser().getName(), false);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append(super.toString());
        if (!this.getGroups().isEmpty()) {
            result.append(", Groups: ").append(CmsStringUtil.collectionAsString(this.getGroups(), ";"));
        }
        result.append(", Mode: ").append(this.getMode().toString());
        return result.toString();
    }
}

