/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import javax.persistence.EntityManager;
import org.opencms.db.jpa.CmsSqlManager;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsVfsException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.report.I_CmsReport;

public final class CmsDbContext
extends org.opencms.db.CmsDbContext {
    protected EntityManager m_entityManager = CmsSqlManager.getEntityManager();
    protected boolean m_shouldCommit = true;

    public CmsDbContext() {
        this(null);
    }

    public CmsDbContext(CmsRequestContext context) {
        super(context);
        this.m_entityManager.getTransaction().begin();
    }

    public void clear() {
        if (this.m_shouldCommit) {
            this.commitAndClose();
        } else {
            this.rollbackAndClose();
        }
        CmsSqlManager.returnEntityManager(this.m_entityManager);
        this.m_requestContext = null;
        this.m_flexRequestContextInfo = null;
    }

    public EntityManager getEntityManager() {
        return this.m_entityManager;
    }

    public void report(I_CmsReport report, CmsMessageContainer message, Throwable throwable) throws CmsVfsException, CmsException {
        this.m_shouldCommit = false;
        if (report != null) {
            if (message != null) {
                report.println(message, 5);
            }
            if (throwable != null) {
                report.println(throwable);
            }
        }
        this.throwException(message, throwable);
    }

    public void rollback() {
        if (this.m_entityManager.getTransaction() != null && this.m_entityManager.getTransaction().isActive()) {
            this.m_entityManager.getTransaction().rollback();
            this.m_entityManager.getTransaction().begin();
            this.m_shouldCommit = true;
        }
    }

    private void commitAndClose() {
        if (this.m_entityManager.getTransaction() != null && this.m_entityManager.getTransaction().isActive()) {
            this.m_entityManager.getTransaction().commit();
        }
    }

    private void rollbackAndClose() {
        if (this.m_entityManager.getTransaction() != null && this.m_entityManager.getTransaction().isActive()) {
            this.m_entityManager.getTransaction().rollback();
        }
    }
}

