/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.log;

import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.opencms.db.CmsDbContext;
import org.opencms.db.log.CmsLogEntryType;
import org.opencms.db.log.Messages;
import org.opencms.util.CmsUUID;

public class CmsLogEntry {
    public static final String ATTR_LOG_ENTRY = "ATTR_LOG_ENTRY";
    private final String[] m_data;
    private final long m_date;
    private final CmsUUID m_structureId;
    private final CmsLogEntryType m_type;
    private final CmsUUID m_userId;

    public CmsLogEntry(CmsDbContext dbc, CmsUUID structureId, CmsLogEntryType type, String[] data) {
        this.m_userId = dbc.currentUser().getId();
        this.m_date = System.currentTimeMillis();
        this.m_structureId = structureId;
        this.m_data = data == null ? new String[]{} : data;
        this.m_type = type;
    }

    public CmsLogEntry(CmsUUID userId, long date, CmsUUID structureId, CmsLogEntryType type, String[] data) {
        this.m_userId = userId;
        this.m_date = date;
        this.m_structureId = structureId != null ? structureId : CmsUUID.getNullUUID();
        this.m_data = data == null ? new String[]{} : data;
        this.m_type = type;
    }

    public String[] getData() {
        return this.m_data;
    }

    public long getDate() {
        return this.m_date;
    }

    public String getDetails(Locale locale) {
        return Messages.get().getBundle(locale).key(this.m_type.getDetailKey(), this.m_data);
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public CmsLogEntryType getType() {
        return this.m_type;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.getClass().getName()).append(":");
        sb.append("user=").append(this.m_userId).append(",");
        sb.append("date=").append(new Date(this.m_date)).append(",");
        sb.append("structure=").append(this.m_structureId).append(",");
        sb.append("type=").append(this.m_type.getLocalizedName(Locale.ENGLISH)).append(",");
        sb.append("data=").append(Arrays.toString(this.m_data)).append(",");
        return sb.append("]").toString();
    }
}

