/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingResultSet;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.generic.Messages;
import org.opencms.db.oracle.CmsSqlManager;
import org.opencms.db.oracle.CmsUserDriver;
import org.opencms.file.CmsDataAccessException;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.util.CmsUUID;

public class CmsProjectDriver
extends org.opencms.db.generic.CmsProjectDriver {
    public void createPublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_ORACLE_PUBLISHJOB_CREATE");
            stmt.setString(1, publishJob.getPublishHistoryId().toString());
            stmt.setString(2, publishJob.getProjectId().toString());
            stmt.setString(3, publishJob.getProjectName());
            stmt.setString(4, publishJob.getUserId().toString());
            stmt.setString(5, publishJob.getLocale().toString());
            stmt.setInt(6, publishJob.getFlags());
            stmt.setInt(7, publishJob.getSize());
            stmt.setLong(8, publishJob.getEnqueueTime());
            stmt.setLong(9, publishJob.getStartTime());
            stmt.setLong(10, publishJob.getFinishTime());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        try {
            this.internalWritePublishJobData(dbc, publishJob.getPublishHistoryId(), "C_ORACLE_PUBLISHJOB_UPDATE_PUBLISHLIST", "PUBLISH_LIST", this.internalSerializePublishList(publishJob.getPublishList()));
        }
        catch (IOException e) {
            throw new CmsDbIoException(Messages.get().container("ERR_SERIALIZING_PUBLISHLIST_1", publishJob.getPublishHistoryId().toString()), (Throwable)e);
        }
    }

    public void writePublishReport(CmsDbContext dbc, CmsUUID publishId, byte[] content) throws CmsDataAccessException {
        this.internalWritePublishJobData(dbc, publishId, "C_ORACLE_PUBLISHJOB_UPDATE_PUBLISHREPORT", "PUBLISH_REPORT", content);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalWritePublishJobData(CmsDbContext dbc, CmsUUID publishJobHistoryId, String queryKey, String fieldName, byte[] data) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement commit = null;
        ResultSet res = null;
        boolean wasInTransaction = false;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, queryKey);
            boolean bl = wasInTransaction = !conn.getAutoCommit();
            if (!wasInTransaction) {
                conn.setAutoCommit(false);
            }
            stmt.setString(1, publishJobHistoryId.toString());
            res = ((DelegatingResultSet)stmt.executeQuery()).getInnermostDelegate();
            if (!res.next()) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishJobHistoryId));
            }
            OutputStream output = CmsUserDriver.getOutputStreamFromBlob(res, fieldName);
            output.write(data);
            output.close();
            if (!wasInTransaction) {
                commit = this.m_sqlManager.getPreparedStatement(conn, "C_COMMIT");
                commit.execute();
                this.m_sqlManager.closeAll(dbc, null, commit, null);
            }
            this.m_sqlManager.closeAll(dbc, null, stmt, res);
            commit = null;
            stmt = null;
            res = null;
            if (!wasInTransaction) {
                conn.setAutoCommit(true);
            }
        }
        catch (IOException e) {
            try {
                throw new CmsDbIoException(Messages.get().container("ERR_WRITING_TO_OUTPUT_STREAM_1", publishJobHistoryId), (Throwable)e);
                catch (SQLException e2) {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
                throw throwable;
            }
        }
        CmsSqlManager.closeAllInTransaction(this.m_sqlManager, dbc, conn, stmt, res, commit, wasInTransaction);
    }

    public org.opencms.db.generic.CmsSqlManager initSqlManager(String classname) {
        return org.opencms.db.generic.CmsSqlManager.getInstance(classname);
    }
}

