/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.Locale;
import org.opencms.db.generic.Messages;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;

public class CmsGroup
extends CmsPrincipal {
    private CmsUUID m_parentId;

    public CmsGroup() {
    }

    public CmsGroup(CmsUUID id, CmsUUID parentId, String name, String description, int flags) {
        this.m_id = id;
        this.m_name = name;
        this.m_description = description;
        this.m_flags = flags;
        this.m_parentId = parentId;
    }

    public void checkName(String name) {
        OpenCms.getValidationHandler().checkGroupName(name);
    }

    public Object clone() {
        return new CmsGroup(this.m_id, this.m_parentId, this.m_name, this.m_description, this.m_flags);
    }

    public String getDescription(Locale locale) {
        CmsMacroResolver macroResolver = new CmsMacroResolver();
        macroResolver.setMessages(Messages.get().getBundle(locale));
        return macroResolver.resolveMacros(this.m_description);
    }

    public CmsUUID getParentId() {
        return this.m_parentId;
    }

    public boolean isGroup() {
        return true;
    }

    public boolean isProjectCoWorker() {
        return (this.getFlags() & 4) == 4;
    }

    public boolean isProjectManager() {
        return (this.getFlags() & 2) == 2;
    }

    public boolean isRole() {
        return (this.getFlags() & 0x100000) == 0x100000;
    }

    public boolean isUser() {
        return false;
    }

    public boolean isVirtual() {
        return (this.getFlags() & 0x400) == 1024;
    }

    public void setParentId(CmsUUID parentId) {
        this.m_parentId = parentId;
    }

    public void setProjectCoWorker(boolean value) {
        if (this.isProjectCoWorker() != value) {
            this.setFlags(this.getFlags() ^ 4);
        }
    }

    public void setProjectManager(boolean value) {
        if (this.isProjectManager() != value) {
            this.setFlags(this.getFlags() ^ 2);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[Group]");
        result.append(" name:");
        result.append(this.getName());
        result.append(" id:");
        result.append(this.m_id);
        result.append(" description:");
        result.append(this.m_description);
        return result.toString();
    }
}

