/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.List;
import org.opencms.file.CmsResource;
import org.opencms.file.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.A_CmsModeIntEnumeration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsProject
implements Cloneable,
Comparable<CmsProject> {
    public static final String ONLINE_PROJECT_NAME = "Online";
    public static final CmsUUID ONLINE_PROJECT_ID = CmsUUID.getConstantUUID("Online");
    public static final int PROJECT_FLAG_HIDDEN = 4;
    public static final int PROJECT_FLAG_NONE = 0;
    public static final CmsProjectType PROJECT_TYPE_NORMAL = CmsProjectType.MODE_PROJECT_NORMAL;
    public static final CmsProjectType PROJECT_TYPE_TEMPORARY = CmsProjectType.MODE_PROJECT_TEMPORARY;
    private long m_dateCreated;
    private String m_description;
    private int m_flags;
    private CmsUUID m_groupManagersId;
    private CmsUUID m_groupUsersId;
    private CmsUUID m_id;
    private String m_name;
    private CmsUUID m_ownerId;
    private CmsProjectType m_type;

    public CmsProject() {
    }

    public CmsProject(CmsUUID projectId, String projectFqn, String description, CmsUUID ownerId, CmsUUID groupId, CmsUUID managerGroupId, int flags, long dateCreated, CmsProjectType type) {
        this.m_id = projectId;
        this.m_name = projectFqn;
        this.m_description = description;
        this.m_ownerId = ownerId;
        this.m_groupUsersId = groupId;
        this.m_groupManagersId = managerGroupId;
        this.m_flags = flags;
        this.m_type = type;
        this.m_dateCreated = dateCreated;
    }

    public static void checkProjectName(String name) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_PROJECTNAME_VALIDATION_0"));
        }
    }

    public static boolean isInsideProject(List<String> projectResources, CmsResource resource) {
        String resourcename = resource.getRootPath();
        return CmsProject.isInsideProject(projectResources, resourcename);
    }

    public static boolean isInsideProject(List<String> projectResources, String resourcename) {
        for (int i = projectResources.size() - 1; i >= 0; --i) {
            String projectResource = projectResources.get(i);
            if (!(CmsResource.isFolder(projectResource) ? resourcename.startsWith(projectResource) : resourcename.equals(projectResource))) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnlineProject(CmsUUID projectId) {
        return projectId.equals(ONLINE_PROJECT_ID);
    }

    public Object clone() {
        return new CmsProject(this.m_id, this.m_name, this.m_description, this.m_ownerId, this.m_groupUsersId, this.m_groupManagersId, this.m_flags, this.m_dateCreated, this.m_type);
    }

    @Override
    public int compareTo(CmsProject o) {
        if (o == this) {
            return 0;
        }
        return this.m_name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsProject) {
            return ((CmsProject)obj).m_id.equals(this.m_id);
        }
        return false;
    }

    public long getDateCreated() {
        return this.m_dateCreated;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getFlags() {
        return this.m_flags;
    }

    public CmsUUID getGroupId() {
        return this.m_groupUsersId;
    }

    public CmsUUID getManagerGroupId() {
        return this.m_groupManagersId;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOuFqn() {
        return CmsOrganizationalUnit.getParentFqn(this.m_name);
    }

    public CmsUUID getOwnerId() {
        return this.m_ownerId;
    }

    public String getSimpleName() {
        return CmsOrganizationalUnit.getSimpleName(this.m_name);
    }

    public CmsProjectType getType() {
        return this.m_type;
    }

    public CmsUUID getUuid() {
        return this.m_id;
    }

    public int hashCode() {
        if (this.m_name != null) {
            return this.m_name.hashCode();
        }
        return 0;
    }

    public boolean isDeleteAfterPublishing() {
        return this.m_type == PROJECT_TYPE_TEMPORARY;
    }

    public boolean isHidden() {
        return (this.getFlags() & 4) == 4;
    }

    public boolean isOnlineProject() {
        return CmsProject.isOnlineProject(this.m_id);
    }

    public void setDeleteAfterPublishing(boolean deleteAfterPublishing) {
        this.m_type = deleteAfterPublishing ? PROJECT_TYPE_TEMPORARY : PROJECT_TYPE_NORMAL;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setFlags(int flags) {
        this.m_flags = flags;
    }

    public void setGroupId(CmsUUID id) {
        CmsUUID.checkId(id, false);
        this.m_groupUsersId = id;
    }

    public void setHidden(boolean value) {
        if (this.isHidden() != value) {
            this.setFlags(this.getFlags() ^ 4);
        }
    }

    public void setManagerGroupId(CmsUUID id) {
        CmsUUID.checkId(id, false);
        this.m_groupManagersId = id;
    }

    public void setName(String name) {
        CmsProject.checkProjectName(name);
        this.m_name = name;
    }

    public void setOwnerId(CmsUUID id) {
        CmsUUID.checkId(id, false);
        this.m_ownerId = id;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[Project]:");
        result.append(this.m_name);
        result.append(" , Id=");
        result.append(this.m_id);
        result.append(", Desc=");
        result.append(this.m_description);
        return result.toString();
    }

    void setType(CmsProjectType type) {
        this.m_type = type;
    }

    public static final class CmsProjectType
    extends A_CmsModeIntEnumeration {
        protected static final CmsProjectType MODE_PROJECT_NORMAL = new CmsProjectType(0);
        protected static final CmsProjectType MODE_PROJECT_TEMPORARY = new CmsProjectType(1);
        private static final long serialVersionUID = -8701314451776599534L;

        private CmsProjectType(int mode) {
            super(mode);
        }

        public static CmsProjectType valueOf(int mode) {
            switch (mode) {
                case 0: {
                    return MODE_PROJECT_NORMAL;
                }
                case 1: {
                    return MODE_PROJECT_TEMPORARY;
                }
            }
            return MODE_PROJECT_NORMAL;
        }
    }
}

