/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import java.util.Comparator;
import org.opencms.db.CmsResourceState;
import org.opencms.util.CmsUUID;

public interface I_CmsResource {
    public static final Comparator<I_CmsResource> COMPARE_DATE_LAST_MODIFIED = new Comparator<I_CmsResource>(){

        @Override
        public int compare(I_CmsResource r1, I_CmsResource r2) {
            long date2;
            if (r1 == r2) {
                return 0;
            }
            long date1 = r1.getDateLastModified();
            return date1 > (date2 = r2.getDateLastModified()) ? -1 : (date1 < date2 ? 1 : 0);
        }
    };
    public static final Comparator<I_CmsResource> COMPARE_DATE_RELEASED = new Comparator<I_CmsResource>(){

        @Override
        public int compare(I_CmsResource r1, I_CmsResource r2) {
            long date2;
            if (r1 == r2) {
                return 0;
            }
            long date1 = r1.getDateReleased();
            if (date1 == 0L) {
                date1 = r1.getDateLastModified();
            }
            if ((date2 = r2.getDateReleased()) == 0L) {
                date2 = r2.getDateLastModified();
            }
            return date1 > date2 ? -1 : (date1 < date2 ? 1 : 0);
        }
    };
    public static final Comparator<I_CmsResource> COMPARE_ROOT_PATH = new Comparator<I_CmsResource>(){

        @Override
        public int compare(I_CmsResource r1, I_CmsResource r2) {
            if (r1 == r2) {
                return 0;
            }
            return r1.getRootPath().compareTo(r2.getRootPath());
        }
    };
    public static final Comparator<I_CmsResource> COMPARE_ROOT_PATH_IGNORE_CASE = new Comparator<I_CmsResource>(){

        @Override
        public int compare(I_CmsResource r1, I_CmsResource r2) {
            if (r1 == r2) {
                return 0;
            }
            return r1.getRootPath().compareToIgnoreCase(r2.getRootPath());
        }
    };
    public static final Comparator<I_CmsResource> COMPARE_ROOT_PATH_IGNORE_CASE_FOLDERS_FIRST = new Comparator<I_CmsResource>(){

        @Override
        public int compare(I_CmsResource r1, I_CmsResource r2) {
            if (r1 == r2) {
                return 0;
            }
            if (r1.isFolder() && !r2.isFolder()) {
                return -1;
            }
            if (r2.isFolder() && !r1.isFolder()) {
                return 1;
            }
            return r1.getRootPath().compareToIgnoreCase(r2.getRootPath());
        }
    };

    public long getDateContent();

    public long getDateCreated();

    public long getDateExpired();

    public long getDateLastModified();

    public long getDateReleased();

    public int getFlags();

    public int getLength();

    public String getName();

    public CmsUUID getProjectLastModified();

    public CmsUUID getResourceId();

    public String getRootPath();

    public int getSiblingCount();

    public CmsResourceState getState();

    public CmsUUID getStructureId();

    public int getTypeId();

    public CmsUUID getUserCreated();

    public CmsUUID getUserLastModified();

    public int getVersion();

    public boolean isExpired(long var1);

    public boolean isFile();

    public boolean isFolder();

    public boolean isInternal();

    public boolean isLabeled();

    public boolean isReleased(long var1);

    public boolean isReleasedAndNotExpired(long var1);

    public boolean isTouched();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CmsResourceAttribute {
        dateContent,
        dateCreated,
        dateExpired,
        dateLastModified,
        dateReleased,
        flags,
        length,
        name,
        projectLastModified,
        resourceId,
        rootPath,
        siblingCount,
        state,
        structureId,
        typeId,
        userCreated,
        userLastModified,
        version;

    }
}

