/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.I_CmsResource;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.ComparatorInverter;
import org.opencms.file.collectors.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsTimeFrameCategoryCollector
extends A_CmsResourceCollector {
    private static final String COLLECTOR_NAME = "timeFrameAndCategories";
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList("timeFrameAndCategories"));
    public static final DateFormat DATEFORMAT_SQL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public List<String> getCollectorNames() {
        return new ArrayList<String>(COLLECTORS_LIST);
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsException, CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTOR_NAME;
        }
        if (COLLECTOR_NAME.equals(collectorName)) {
            return this.getCreateInFolder(cms, new CollectorDataPropertyBased(param));
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTOR_NAME;
        }
        if (COLLECTOR_NAME.equals(collectorName)) {
            return this.getTimeFrameAndCategories(cms, param);
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    private List<CmsResource> getTimeFrameAndCategories(CmsObject cms, String param) throws CmsException {
        CmsProperty prop;
        CmsResource res;
        List<CmsResource> result = null;
        CollectorDataPropertyBased data = new CollectorDataPropertyBased(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(data.getType()).addExcludeFlags(1024);
        result = cms.readResources(foldername, filter, true);
        String timeProperty = data.getPropertyTime().getName();
        long start = data.getTimeFrameStart();
        long end = data.getTimeFrameEnd();
        Iterator<CmsResource> itResults = result.iterator();
        while (itResults.hasNext()) {
            long resTime;
            res = itResults.next();
            prop = cms.readPropertyObject(res, timeProperty, true);
            if (prop.isNullProperty() || (resTime = Long.parseLong(prop.getValue())) >= start && resTime <= end) continue;
            itResults.remove();
        }
        List<String> categories = data.getCategories();
        if (categories != null && !categories.isEmpty()) {
            itResults = result.iterator();
            String categoriesProperty = data.getPropertyCategories().getName();
            while (itResults.hasNext()) {
                res = itResults.next();
                prop = cms.readPropertyObject(res, categoriesProperty, true);
                if (prop.isNullProperty()) {
                    itResults.remove();
                    continue;
                }
                List<String> categoriesFound = CmsStringUtil.splitAsList(prop.getValue(), '|');
                Iterator<String> itCategories = categories.iterator();
                boolean contained = false;
                while (itCategories.hasNext()) {
                    String category = itCategories.next();
                    if (!categoriesFound.contains(category)) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                itResults.remove();
            }
        }
        if (data.isSortDescending()) {
            Collections.sort(result, I_CmsResource.COMPARE_DATE_RELEASED);
        } else {
            Collections.sort(result, new ComparatorInverter(I_CmsResource.COMPARE_DATE_RELEASED));
        }
        return this.shrinkToFit(result, data.getCount());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectorDataPropertyBased
    extends CmsCollectorData {
        public static final String PARAM_KEY_CATEGORIES = "categories";
        public static final String PARAM_KEY_PPROPERTY_CATEGORIES = "propertyCategories";
        public static final String PARAM_KEY_PPROPERTY_TIME = "propertyTime";
        public static final String PARAM_KEY_RESOURCE = "resource";
        public static final String PARAM_KEY_RESOURCE_TYPE = "resourceType";
        public static final String PARAM_KEY_RESULT_LIMIT = "resultLimit";
        public static final String PARAM_KEY_SORT_DESCENDING = "sortDescending";
        public static final String PARAM_KEY_TIMEFRAME_END = "timeEnd";
        public static final String PARAM_KEY_TIMEFRAME_START = "timeStart";
        private List<String> m_categories = Collections.emptyList();
        private int m_count;
        private String m_fileName;
        private CmsProperty m_propertyCategories = new CmsProperty();
        private CmsProperty m_propertyTime = new CmsProperty();
        private boolean m_sortDescending;
        private long m_timeFrameEnd = Long.MAX_VALUE;
        private long m_timeFrameStart;
        private I_CmsResourceType m_type;

        public CollectorDataPropertyBased(String data) throws CmsLoaderException {
            try {
                this.parseParam(data);
            }
            catch (ParseException pe) {
                CmsIllegalArgumentException ex = new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_DATE_FORMAT_SYNTAX_0"));
                ex.initCause(pe);
                throw ex;
            }
        }

        public List<String> getCategories() {
            return this.m_categories;
        }

        @Override
        public int getCount() {
            return this.m_count;
        }

        @Override
        public String getFileName() {
            return this.m_fileName;
        }

        public CmsProperty getPropertyCategories() {
            return this.m_propertyCategories;
        }

        public CmsProperty getPropertyTime() {
            return this.m_propertyTime;
        }

        public long getTimeFrameEnd() {
            return this.m_timeFrameEnd;
        }

        public long getTimeFrameStart() {
            return this.m_timeFrameStart;
        }

        @Override
        public int getType() {
            return this.m_type.getTypeId();
        }

        public boolean isSortDescending() {
            return this.m_sortDescending;
        }

        private void parseParam(String param) throws CmsLoaderException, ParseException {
            List<String> keyValuePairs = CmsStringUtil.splitAsList(param, '|');
            for (String keyValuePairStr : keyValuePairs) {
                String[] keyValuePair = CmsStringUtil.splitAsArray(keyValuePairStr, '=');
                if (keyValuePair.length != 2) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_KEY_VALUE_SYNTAX_1", new Object[]{keyValuePairStr}));
                }
                String key = String.valueOf(keyValuePair[0]).trim();
                String value = String.valueOf(keyValuePair[1]).trim();
                if (PARAM_KEY_RESOURCE.equals(key)) {
                    this.m_fileName = value;
                    continue;
                }
                if (PARAM_KEY_RESOURCE_TYPE.equals(key)) {
                    this.m_type = OpenCms.getResourceManager().getResourceType(value);
                    continue;
                }
                if (PARAM_KEY_RESULT_LIMIT.equals(key)) {
                    this.m_count = Integer.parseInt(value);
                    continue;
                }
                if (PARAM_KEY_SORT_DESCENDING.equals(key)) {
                    this.m_sortDescending = new Boolean(value);
                    continue;
                }
                if (PARAM_KEY_TIMEFRAME_START.equals(key)) {
                    this.m_timeFrameStart = DATEFORMAT_SQL.parse(value).getTime();
                    continue;
                }
                if (PARAM_KEY_TIMEFRAME_END.equals(key)) {
                    this.m_timeFrameEnd = DATEFORMAT_SQL.parse(value).getTime();
                    continue;
                }
                if (PARAM_KEY_PPROPERTY_TIME.equals(key)) {
                    this.m_propertyTime.setName(value);
                    continue;
                }
                if (PARAM_KEY_CATEGORIES.equals(key)) {
                    this.m_categories = CmsStringUtil.splitAsList(value, ',');
                    continue;
                }
                if (!PARAM_KEY_PPROPERTY_CATEGORIES.equals(key)) continue;
                this.m_propertyCategories.setName(value);
            }
        }
    }
}

