/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.file.types.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.security.CmsPermissionSet;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsResourceTypeXmlContainerPage
extends CmsResourceTypeXmlContent {
    public static final String CONFIGURATION_TYPE_NAME = "sitemap_config";
    public static final String GROUP_CONTAINER_TYPE_NAME = "groupcontainer";
    private static int containerPageTypeId;
    private static final Log LOG;
    private static final String RESOURCE_TYPE_NAME = "containerpage";
    private static final String SCHEMA = "/system/modules/org.opencms.ade.containerpage/schemas/container_page.xsd";

    public CmsResourceTypeXmlContainerPage() {
        this.m_typeName = RESOURCE_TYPE_NAME;
        this.addConfigurationParameter("schema", SCHEMA);
    }

    public static int getContainerPageTypeId() throws CmsLoaderException {
        I_CmsResourceType resType;
        if (containerPageTypeId == 0 && (resType = OpenCms.getResourceManager().getResourceType(CmsResourceTypeXmlContainerPage.getStaticTypeName())) != null) {
            containerPageTypeId = resType.getTypeId();
        }
        return containerPageTypeId;
    }

    public static int getContainerPageTypeIdSafely() {
        try {
            return CmsResourceTypeXmlContainerPage.getContainerPageTypeId();
        }
        catch (CmsLoaderException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return -1;
        }
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public static boolean isContainerPage(CmsResource resource) {
        boolean result = false;
        if (resource != null) {
            result = resource.getTypeId() == CmsResourceTypeXmlContainerPage.getContainerPageTypeIdSafely();
        }
        return result;
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        boolean hasModelUri = false;
        CmsXmlContainerPage newContent = null;
        if (this.getSchema() != null && (content == null || content.length == 0)) {
            CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, this.getSchema());
            Locale locale = OpenCms.getLocaleManager().getDefaultLocales(cms, CmsResource.getParentFolder(resourcename)).get(0);
            String modelUri = (String)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_MODEL);
            CmsObject newCms = OpenCms.initCmsObject(cms);
            newCms.getRequestContext().setUri(CmsResource.getParentFolder(resourcename));
            if (modelUri != null) {
                newContent = CmsXmlContainerPageFactory.createDocument(newCms, locale, modelUri);
                hasModelUri = true;
            } else {
                newContent = CmsXmlContainerPageFactory.createDocument(newCms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
            }
            content = newContent.marshal();
        }
        CmsResource resource = super.createResource(cms, securityManager, resourcename, content, properties);
        if (hasModelUri) {
            newContent = CmsXmlContainerPageFactory.unmarshal(cms, resource);
            resource = newContent.getHandler().prepareForWrite(cms, newContent, newContent.getFile());
        }
        return resource;
    }

    @Override
    public int getLoaderId() {
        return 11;
    }

    @Override
    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (!RESOURCE_TYPE_NAME.equals(name)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_NAME_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        int typeId = Integer.valueOf(id);
        if (containerPageTypeId > 0 && containerPageTypeId != typeId) {
            throw new CmsConfigurationException(Messages.get().container("ERR_RESOURCE_TYPE_ALREADY_CONFIGURED_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        super.initConfiguration(RESOURCE_TYPE_NAME, id, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsLink> parseLinks(CmsObject cms, CmsFile file) {
        CmsXmlContainerPage xmlContent;
        if (file.getLength() == 0) {
            return Collections.emptyList();
        }
        long requestTime = cms.getRequestContext().getRequestTime();
        try {
            cms.getRequestContext().setRequestTime(Long.MIN_VALUE);
            xmlContent = CmsXmlContainerPageFactory.unmarshal(cms, file);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_READ_RESOURCE_1", cms.getSitePath(file)), (Throwable)e);
            }
            List<CmsLink> list = Collections.emptyList();
            return list;
        }
        finally {
            cms.getRequestContext().setRequestTime(requestTime);
        }
        HashSet<CmsLink> links = new HashSet<CmsLink>();
        CmsLink xsdLink = this.getXsdLink(cms, xmlContent);
        if (xsdLink != null) {
            links.add(xsdLink);
        }
        List<Locale> locales = xmlContent.getLocales();
        for (Locale locale : locales) {
            List<I_CmsXmlContentValue> values = xmlContent.getValues(locale);
            for (I_CmsXmlContentValue value : values) {
                CmsXmlVfsFileValue refValue;
                CmsLink link;
                if (!(value instanceof CmsXmlVfsFileValue) || (link = (refValue = (CmsXmlVfsFileValue)value).getLink(cms)) == null) continue;
                links.add(link);
            }
        }
        return new ArrayList<CmsLink>(links);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
        CmsXmlContainerPage xmlContent = CmsXmlContainerPageFactory.unmarshal(cms, resource, false, true);
        resource = xmlContent.getHandler().prepareForWrite(cms, xmlContent, resource);
        CmsFile file = securityManager.writeFile(cms.getRequestContext(), resource);
        I_CmsResourceType type = this.getResourceType(file);
        List<CmsLink> links = null;
        if (type instanceof I_CmsLinkParseable) {
            links = ((I_CmsLinkParseable)((Object)type)).parseLinks(cms, file);
        }
        securityManager.updateRelationsForResource(cms.getRequestContext(), file, links);
        return file;
    }

    static {
        LOG = CmsLog.getLog(CmsResourceTypeXmlContainerPage.class);
    }
}

