/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.util.List;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexRequestContextInfo;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.flex.Messages;
import org.opencms.main.CmsLog;

public class CmsFlexController {
    public static final String ATTRIBUTE_NAME = "org.opencms.flex.CmsFlexController";
    private static final Log LOG = CmsLog.getLog(CmsFlexController.class);
    private CmsFlexCache m_cache;
    private CmsObject m_cmsObject;
    private List<CmsFlexRequestContextInfo> m_flexContextInfoList;
    private List<CmsFlexRequest> m_flexRequestList;
    private List<CmsFlexResponse> m_flexResponseList;
    private boolean m_forwardMode;
    private HttpServletRequest m_req;
    private HttpServletResponse m_res;
    private CmsResource m_resource;
    private boolean m_streaming;
    private Throwable m_throwable;
    private String m_throwableResourceUri;
    private boolean m_top;

    public CmsFlexController(CmsObject cms, CmsFlexController base) {
        this.m_cmsObject = cms;
        this.m_resource = base.m_resource;
        this.m_cache = base.m_cache;
        this.m_req = base.m_req;
        this.m_res = base.m_res;
        this.m_streaming = base.m_streaming;
        this.m_top = base.m_top;
        this.m_flexRequestList = base.m_flexRequestList;
        this.m_flexResponseList = base.m_flexResponseList;
        this.m_flexContextInfoList = base.m_flexContextInfoList;
        this.m_forwardMode = base.m_forwardMode;
        this.m_throwableResourceUri = base.m_throwableResourceUri;
    }

    public CmsFlexController(CmsObject cms, CmsResource resource, CmsFlexCache cache, HttpServletRequest req, HttpServletResponse res, boolean streaming, boolean top) {
        this.m_cmsObject = cms;
        this.m_resource = resource;
        this.m_cache = cache;
        this.m_req = req;
        this.m_res = res;
        this.m_streaming = streaming;
        this.m_top = top;
        this.m_flexRequestList = new Vector<CmsFlexRequest>();
        this.m_flexResponseList = new Vector<CmsFlexResponse>();
        this.m_flexContextInfoList = new Vector<CmsFlexRequestContextInfo>();
        this.m_forwardMode = false;
        this.m_throwableResourceUri = null;
    }

    public static CmsObject getCmsObject(ServletRequest req) {
        CmsFlexController controller = (CmsFlexController)req.getAttribute(ATTRIBUTE_NAME);
        if (controller != null) {
            return controller.getCmsObject();
        }
        return null;
    }

    public static CmsFlexController getController(ServletRequest req) {
        return (CmsFlexController)req.getAttribute(ATTRIBUTE_NAME);
    }

    public static Throwable getThrowable(ServletRequest req) {
        CmsFlexController controller = (CmsFlexController)req.getAttribute(ATTRIBUTE_NAME);
        if (controller != null) {
            return controller.getThrowable();
        }
        return null;
    }

    public static String getThrowableResourceUri(ServletRequest req) {
        CmsFlexController controller = (CmsFlexController)req.getAttribute(ATTRIBUTE_NAME);
        if (controller != null) {
            return controller.getThrowableResourceUri();
        }
        return null;
    }

    public static boolean isCmsOnlineRequest(ServletRequest req) {
        if (req == null) {
            return false;
        }
        return CmsFlexController.getController(req).getCmsObject().getRequestContext().getCurrentProject().isOnlineProject();
    }

    public static boolean isCmsRequest(ServletRequest req) {
        return req != null && req.getAttribute(ATTRIBUTE_NAME) != null;
    }

    public static boolean isNotModifiedSince(HttpServletRequest req, long dateLastModified) {
        try {
            long lastModifiedHeader = req.getDateHeader("If-Modified-Since");
            return lastModifiedHeader > -1L && dateLastModified / 1000L * 1000L == lastModifiedHeader;
        }
        catch (Exception ex) {
            LOG.warn((Object)Messages.get().getBundle().key("ERR_HEADER_IFMODIFIEDSINCE_FORMAT_3", new Object[]{"If-Modified-Since", req.getHeader("user-agent"), req.getHeader("If-Modified-Since")}));
            return false;
        }
    }

    public static void removeController(ServletRequest req) {
        CmsFlexController controller = (CmsFlexController)req.getAttribute(ATTRIBUTE_NAME);
        if (controller != null) {
            controller.clear();
        }
    }

    public static void setController(ServletRequest req, CmsFlexController controller) {
        req.setAttribute(ATTRIBUTE_NAME, (Object)controller);
    }

    public static void setDateExpiresHeader(HttpServletResponse res, long dateExpires, long maxAge) {
        long now = System.currentTimeMillis();
        if (dateExpires > now && dateExpires != Long.MAX_VALUE) {
            if (maxAge < 0L) {
                maxAge = 86400000L;
            }
            if (dateExpires - now > maxAge) {
                dateExpires = now + maxAge;
            }
            res.setDateHeader("Expires", dateExpires);
            res.setHeader("Cache-Control", "max-age=" + maxAge / 1000L);
        }
    }

    public static void setDateLastModifiedHeader(HttpServletResponse res, long dateLastModified) {
        if (dateLastModified > -1L) {
            res.setDateHeader("Last-Modified", dateLastModified / 1000L * 1000L);
        } else {
            res.setDateHeader("Last-Modified", System.currentTimeMillis());
        }
    }

    public void clear() {
        if (this.m_flexRequestList != null) {
            this.m_flexRequestList.clear();
        }
        this.m_flexRequestList = null;
        if (this.m_flexResponseList != null) {
            this.m_flexResponseList.clear();
        }
        this.m_flexResponseList = null;
        if (this.m_req != null) {
            this.m_req.removeAttribute(ATTRIBUTE_NAME);
        }
        this.m_req = null;
        this.m_res = null;
        this.m_cmsObject = null;
        this.m_resource = null;
        this.m_cache = null;
        this.m_throwable = null;
    }

    public CmsFlexCache getCmsCache() {
        return this.m_cache;
    }

    public CmsObject getCmsObject() {
        return this.m_cmsObject;
    }

    public CmsResource getCmsResource() {
        return this.m_resource;
    }

    public CmsFlexRequest getCurrentRequest() {
        return this.m_flexRequestList.get(this.m_flexRequestList.size() - 1);
    }

    public CmsFlexResponse getCurrentResponse() {
        return this.m_flexResponseList.get(this.m_flexResponseList.size() - 1);
    }

    public long getDateExpires() {
        int pos = this.m_flexContextInfoList.size() - 1;
        if (pos < 0) {
            return Long.MAX_VALUE;
        }
        return this.m_flexContextInfoList.get(pos).getDateExpires();
    }

    public long getDateLastModified() {
        int pos = this.m_flexContextInfoList.size() - 1;
        if (pos < 0) {
            return 0L;
        }
        return this.m_flexContextInfoList.get(pos).getDateLastModified();
    }

    public int getResponseStackSize() {
        return this.m_flexResponseList.size();
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public String getThrowableResourceUri() {
        return this.m_throwableResourceUri;
    }

    public HttpServletRequest getTopRequest() {
        return this.m_req;
    }

    public HttpServletResponse getTopResponse() {
        return this.m_res;
    }

    public boolean isEmptyRequestList() {
        return this.m_flexRequestList != null && this.m_flexRequestList.isEmpty();
    }

    public boolean isForwardMode() {
        return this.m_forwardMode;
    }

    public boolean isStreaming() {
        return this.m_streaming;
    }

    public boolean isTop() {
        return this.m_top;
    }

    public void pop() {
        if (this.m_flexRequestList != null && !this.m_flexRequestList.isEmpty()) {
            this.m_flexRequestList.remove(this.m_flexRequestList.size() - 1);
        }
        if (this.m_flexResponseList != null && !this.m_flexRequestList.isEmpty()) {
            this.m_flexResponseList.remove(this.m_flexResponseList.size() - 1);
        }
        if (this.m_flexContextInfoList != null && !this.m_flexContextInfoList.isEmpty()) {
            CmsFlexRequestContextInfo info = this.m_flexContextInfoList.remove(this.m_flexContextInfoList.size() - 1);
            if (this.m_flexContextInfoList.size() > 0) {
                this.m_flexContextInfoList.get(0).merge(info);
                this.updateRequestContextInfo();
            }
        }
    }

    public void push(CmsFlexRequest req, CmsFlexResponse res) {
        this.m_flexRequestList.add(req);
        this.m_flexResponseList.add(res);
        this.m_flexContextInfoList.add(new CmsFlexRequestContextInfo());
        this.updateRequestContextInfo();
    }

    public void setForwardMode(boolean value) {
        this.m_forwardMode = value;
    }

    public Throwable setThrowable(Throwable throwable, String resource) {
        if (this.m_throwable == null) {
            this.m_throwable = throwable;
            this.m_throwableResourceUri = resource;
        } else if (LOG.isDebugEnabled()) {
            if (resource != null) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCONTROLLER_IGNORED_EXCEPTION_1", resource));
            } else {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCONTROLLER_IGNORED_EXCEPTION_0"));
            }
        }
        return this.m_throwable;
    }

    public void suspendFlexResponse() {
        for (int i = 0; i < this.m_flexResponseList.size(); ++i) {
            CmsFlexResponse res = this.m_flexResponseList.get(i);
            res.setSuspended(true);
        }
    }

    public void updateDates(long dateLastModified, long dateExpires) {
        int pos = this.m_flexContextInfoList.size() - 1;
        if (pos < 0) {
            return;
        }
        this.m_flexContextInfoList.get(pos).updateDates(dateLastModified, dateExpires);
    }

    private void updateRequestContextInfo() {
        if (this.m_flexContextInfoList != null && !this.m_flexContextInfoList.isEmpty()) {
            this.m_cmsObject.getRequestContext().setAttribute("Last-Modified", this.m_flexContextInfoList.get(this.m_flexContextInfoList.size() - 1));
        }
    }
}

