/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.I_CmsClientMessageBundle;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsClientMessageBundle
implements I_CmsClientMessageBundle {
    private static final Log LOG = CmsLog.getLog(A_CmsClientMessageBundle.class);

    protected A_CmsClientMessageBundle() {
    }

    @Override
    public String export(HttpServletRequest request) {
        CmsObject cms = CmsFlexController.getCmsObject((ServletRequest)request);
        return this.export(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    @Override
    public String export(String localeName) {
        return this.export(CmsLocaleManager.getLocale(localeName));
    }

    @Override
    public String export(Locale locale) {
        JSONObject keys = new JSONObject();
        try {
            ResourceBundle resourceBundle = CmsResourceBundleLoader.getBundle(this.getBundleName(), locale);
            Enumeration<String> bundleKeys = resourceBundle.getKeys();
            while (bundleKeys.hasMoreElements()) {
                String bundleKey = bundleKeys.nextElement();
                keys.put(bundleKey, resourceBundle.getString(bundleKey));
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
            try {
                keys.put("error", e.getLocalizedMessage());
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
            }
        }
        return this.getBundleName().replace('.', '_') + "=" + keys.toString() + ";";
    }

    @Override
    public String getBundleName() {
        return this.getClass().getPackage().getName() + ".clientmessages";
    }

    @Override
    public Class<?> getClientImpl() throws Exception {
        return Class.forName(this.getClass().getPackage().getName() + ".client.Messages");
    }
}

