/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.gwt.shared.property.CmsClientTemplateBean;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsTemplateFinder {
    protected CmsObject m_cms;

    public CmsTemplateFinder(CmsObject cms) {
        this.m_cms = cms;
    }

    public Map<String, CmsClientTemplateBean> getTemplates() throws CmsException {
        HashMap<String, CmsClientTemplateBean> result = new HashMap<String, CmsClientTemplateBean>();
        CmsObject cms = this.getCmsObject();
        int templateId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeJsp.getContainerPageTemplateTypeName()).getTypeId();
        List<CmsResource> templates = cms.readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(templateId), true);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(cms.getRequestContext().getSiteRoot())) {
            templates.addAll(cms.readResources("/system/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(templateId), true));
        }
        for (CmsResource template : templates) {
            CmsClientTemplateBean templateBean = this.getTemplateBean(cms, template);
            result.put(templateBean.getSitePath(), templateBean);
        }
        return result;
    }

    protected CmsObject getCmsObject() {
        return this.m_cms;
    }

    private CmsClientTemplateBean getTemplateBean(CmsObject cms, CmsResource resource) throws CmsException {
        CmsProperty titleProp = cms.readPropertyObject(resource, "Title", false);
        CmsProperty descProp = cms.readPropertyObject(resource, "Description", false);
        CmsProperty imageProp = cms.readPropertyObject(resource, "template.image", false);
        return new CmsClientTemplateBean(titleProp.getValue(), descProp.getValue(), cms.getSitePath(resource), imageProp.getValue());
    }
}

