/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.io.SAXWriter;
import org.opencms.file.CmsFile;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsXmlSaxWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CmsExportHelper {
    private static final int SUB_LENGTH = 4096;
    private String m_exportPath;
    private ZipOutputStream m_exportZipStream;
    private boolean m_isExportAsFiles;
    private SAXWriter m_saxWriter;

    public CmsExportHelper(String exportPath, boolean exportAsFiles, boolean validateXml) throws SAXException, IOException {
        Writer writer;
        this.m_exportPath = exportPath;
        this.m_isExportAsFiles = exportAsFiles;
        this.removeOldExport(exportPath);
        if (this.m_isExportAsFiles) {
            this.m_exportPath = this.m_exportPath + "/";
            String fileName = this.getRfsFileName("manifest.xml");
            File rfsFile = new File(fileName);
            rfsFile.getParentFile().mkdirs();
            rfsFile.createNewFile();
            writer = new FileWriter(rfsFile);
        } else {
            this.m_exportZipStream = new ZipOutputStream(new FileOutputStream(this.m_exportPath));
            writer = new StringWriter(4096);
        }
        CmsXmlSaxWriter saxHandler = new CmsXmlSaxWriter(writer, OpenCms.getSystemInfo().getDefaultEncoding());
        saxHandler.setEscapeXml(true);
        saxHandler.setEscapeUnknownChars(true);
        saxHandler.startDocument();
        if (validateXml) {
            saxHandler.startDTD("export", null, "http://www.opencms.org/dtd/6.0/opencms-import7.dtd");
            saxHandler.endDTD();
        }
        this.m_saxWriter = new SAXWriter((ContentHandler)saxHandler, (LexicalHandler)saxHandler);
    }

    public SAXWriter getSaxWriter() {
        return this.m_saxWriter;
    }

    public void writeFile(CmsFile file, String name) throws IOException {
        if (this.m_isExportAsFiles) {
            this.writeFile2Rfs(file, name);
        } else {
            this.writeFile2Zip(file, name);
        }
    }

    public void writeManifest(CmsXmlSaxWriter xmlSaxWriter) throws IOException, SAXException {
        if (this.m_isExportAsFiles) {
            this.writeManifest2Rfs(xmlSaxWriter);
        } else {
            this.writeManifest2Zip(xmlSaxWriter);
        }
    }

    protected String getRfsFileName(String name) {
        return this.m_exportPath + name;
    }

    protected void removeOldExport(String exportPath) {
        File output = new File(exportPath);
        if (output.exists()) {
            if (output.isDirectory()) {
                CmsFileUtil.purgeDirectory(output);
            } else if (this.m_isExportAsFiles) {
                output.delete();
            }
        }
    }

    protected void writeFile2Rfs(CmsFile file, String name) throws IOException {
        String fileName = this.getRfsFileName(name);
        File rfsFile = new File(fileName);
        if (!rfsFile.getParentFile().exists()) {
            rfsFile.getParentFile().mkdirs();
        }
        rfsFile.createNewFile();
        FileOutputStream rfsFileOut = new FileOutputStream(rfsFile);
        rfsFileOut.write(file.getContents());
        rfsFileOut.close();
    }

    protected void writeFile2Zip(CmsFile file, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(file.getDateLastModified());
        this.m_exportZipStream.putNextEntry(entry);
        this.m_exportZipStream.write(file.getContents());
        this.m_exportZipStream.closeEntry();
    }

    protected void writeManifest2Rfs(CmsXmlSaxWriter xmlSaxWriter) throws SAXException, IOException {
        xmlSaxWriter.endDocument();
        xmlSaxWriter.getWriter().close();
    }

    protected void writeManifest2Zip(CmsXmlSaxWriter xmlSaxWriter) throws IOException, SAXException {
        xmlSaxWriter.endDocument();
        xmlSaxWriter.getWriter().close();
        ZipEntry entry = new ZipEntry("manifest.xml");
        this.m_exportZipStream.putNextEntry(entry);
        StringBuffer result = ((StringWriter)xmlSaxWriter.getWriter()).getBuffer();
        int steps = result.length() / 4096;
        int rest = result.length() % 4096;
        int pos = 0;
        for (int i = 0; i < steps; ++i) {
            String sub = result.substring(pos, pos + 4096);
            this.m_exportZipStream.write(sub.getBytes(OpenCms.getSystemInfo().getDefaultEncoding()));
            pos += 4096;
        }
        if (rest > 0) {
            String sub = result.substring(pos, pos + rest);
            this.m_exportZipStream.write(sub.getBytes(OpenCms.getSystemInfo().getDefaultEncoding()));
        }
        this.m_exportZipStream.closeEntry();
        this.m_exportZipStream.close();
    }
}

