/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.Messages;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.page.CmsXmlPage;

public final class CmsXmlPageConverter {
    private CmsXmlPageConverter() {
    }

    public static CmsXmlPage convertToXmlPage(CmsObject cms, byte[] content, Locale locale, String encoding) throws CmsImportExportException, CmsXmlException {
        CmsXmlPage xmlPage = null;
        Document page = CmsXmlUtils.unmarshalHelper(content, null);
        Element xmltemplate = page.getRootElement();
        if (xmltemplate == null || !"XMLTEMPLATE".equals(xmltemplate.getName())) {
            throw new CmsImportExportException(Messages.get().container("ERR_NOT_FOUND_ELEM_XMLTEMPLATE_0"));
        }
        Iterator i = xmltemplate.elementIterator("edittemplate");
        boolean useEditTemplates = true;
        if (!i.hasNext()) {
            i = xmltemplate.elementIterator("TEMPLATE");
            useEditTemplates = false;
        }
        xmlPage = new CmsXmlPage(locale, encoding);
        while (i.hasNext()) {
            Element currentTemplate = (Element)i.next();
            String bodyName = currentTemplate.attributeValue("name");
            if (CmsStringUtil.isEmpty(bodyName)) {
                bodyName = "body";
            }
            String bodyContent = null;
            if (useEditTemplates) {
                bodyContent = currentTemplate.getText();
            } else {
                StringBuffer contentBuffer = new StringBuffer();
                Iterator k = currentTemplate.nodeIterator();
                while (k.hasNext()) {
                    Node n = (Node)k.next();
                    if (n.getNodeType() == 4) {
                        contentBuffer.append(n.getText());
                        continue;
                    }
                    if (n.getNodeType() != 1 || !"LINK".equals(n.getName())) continue;
                    contentBuffer.append(OpenCms.getSystemInfo().getOpenCmsContext());
                    contentBuffer.append(n.getText());
                }
                bodyContent = contentBuffer.toString();
            }
            if (bodyContent == null) {
                throw new CmsImportExportException(Messages.get().container("ERR_BODY_CONTENT_NOT_FOUND_0"));
            }
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(bodyContent = CmsStringUtil.substitute(bodyContent, "${OpenCmsContext}", OpenCms.getSystemInfo().getOpenCmsContext()))) continue;
            xmlPage.addValue(bodyName, locale);
            xmlPage.setStringValue(cms, bodyName, locale, bodyContent);
        }
        return xmlPage;
    }
}

