/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsFile;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspBean;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.CmsJspTagImage;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.jsp.CmsJspTagInfo;
import org.opencms.jsp.CmsJspTagLabel;
import org.opencms.jsp.CmsJspTagLink;
import org.opencms.jsp.CmsJspTagProperty;
import org.opencms.jsp.CmsJspTagTemplate;
import org.opencms.jsp.CmsJspTagUser;
import org.opencms.jsp.Messages;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditJspIncludeProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.I_CmsDirectEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspActionElement
extends CmsJspBean {
    public static final CmsMessageContainer NOT_INITIALIZED = Messages.get().container("GUI_ERR_ACTIONELEM_NOT_INIT_0");
    private CmsJspNavBuilder m_vfsNav;

    public CmsJspActionElement() {
    }

    public CmsJspActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public void editable(boolean isEditable) throws JspException {
        if (isEditable) {
            CmsJspTagEditable.editableTagAction(this.getJspContext(), null, CmsDirectEditMode.AUTO, null);
        }
    }

    public void editable(boolean isEditable, String filename) throws JspException {
        if (isEditable) {
            CmsJspTagEditable.editableTagAction(this.getJspContext(), CmsDirectEditJspIncludeProvider.class.getName(), CmsDirectEditMode.AUTO, filename);
        }
    }

    public void editable(String provider, String mode, String filename) throws JspException {
        CmsJspTagEditable.editableTagAction(this.getJspContext(), provider, CmsDirectEditMode.valueOf(mode), filename);
    }

    public void editableManualClose(boolean needsClose) throws JspException {
        if (needsClose) {
            CmsJspTagEditable.editableTagAction(this.getJspContext(), null, CmsDirectEditMode.MANUAL, null);
        }
    }

    public boolean editableManualOpen() throws JspException {
        I_CmsDirectEditProvider eb;
        boolean result = false;
        if (!CmsFlexController.isCmsOnlineRequest(this.getJspContext().getRequest()) && (eb = CmsJspTagEditable.getDirectEditProvider(this.getJspContext())) != null && eb.isManual(CmsDirectEditMode.MANUAL)) {
            result = true;
            CmsJspTagEditable.editableTagAction(this.getJspContext(), null, CmsDirectEditMode.MANUAL, null);
        }
        return result;
    }

    public String getContent(String target) {
        return this.getContent(target, null, null);
    }

    public String getContent(String target, String element, Locale locale) {
        I_CmsResourceLoader loader;
        CmsFile file;
        target = this.toAbsolute(target);
        try {
            file = this.getCmsObject().readFile(target);
            loader = OpenCms.getResourceManager().getLoader(file);
        }
        catch (ClassCastException e) {
            return CmsMessages.formatUnknownKey(e.getMessage());
        }
        catch (CmsException e) {
            return CmsMessages.formatUnknownKey(e.getMessage());
        }
        try {
            byte[] result = loader.dump(this.getCmsObject(), file, element, locale, this.getRequest(), this.getResponse());
            return new String(result, this.getRequestContext().getEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            return CmsMessages.formatUnknownKey(uee.getMessage());
        }
        catch (Throwable t) {
            Throwable cause = CmsFlexController.getThrowable((ServletRequest)this.getRequest());
            if (cause == null) {
                cause = t;
            }
            this.handleException(cause);
            return CmsMessages.formatUnknownKey(cause.getMessage());
        }
    }

    public CmsMessages getMessages(String bundleName, Locale locale) {
        return new CmsMessages(bundleName, locale);
    }

    public CmsMessages getMessages(String bundleName, String language) {
        return this.getMessages(bundleName, language, "", "", null);
    }

    public CmsMessages getMessages(String bundleName, String language, String defaultLanguage) {
        return this.getMessages(bundleName, language, "", "", defaultLanguage);
    }

    public CmsMessages getMessages(String bundleName, String language, String country, String variant, String defaultLanguage) {
        try {
            if (defaultLanguage != null && CmsStringUtil.isEmpty(language)) {
                language = defaultLanguage;
            }
            if (language == null) {
                language = "";
            }
            if (country == null) {
                country = "";
            }
            if (variant == null) {
                variant = "";
            }
            return this.getMessages(bundleName, new Locale(language, country, variant));
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    public CmsJspNavBuilder getNavigation() {
        if (this.isNotInitialized()) {
            return null;
        }
        if (this.m_vfsNav == null) {
            this.m_vfsNav = new CmsJspNavBuilder(this.getCmsObject());
        }
        return this.m_vfsNav;
    }

    public String getNavigationUri() {
        return this.getCmsObject().getRequestContext().getUri();
    }

    public String img(String target, CmsImageScaler scaler, Map<String, String> attributes) {
        return this.img(target, scaler, attributes, false);
    }

    public String img(String target, CmsImageScaler scaler, Map<String, String> attributes, boolean partialTag) {
        try {
            return CmsJspTagImage.imageTagAction(target, scaler, attributes, partialTag, (ServletRequest)this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
            CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_IMG_SCALE_2", target, scaler == null ? "null" : scaler.toString());
            return this.getMessage(msgContainer);
        }
    }

    public void include(String target) throws JspException {
        this.include(target, null, null);
    }

    public void include(String target, String element) throws JspException {
        this.include(target, element, null);
    }

    public void include(String target, String element, boolean editable) throws JspException {
        this.include(target, element, editable, null);
    }

    public void include(String target, String element, boolean editable, Map parameterMap) throws JspException {
        this.include(target, element, editable, true, parameterMap);
    }

    public void include(String target, String element, boolean editable, boolean cacheable, Map parameterMap) throws JspException {
        if (this.isNotInitialized()) {
            return;
        }
        HashMap<String, String[]> modParameterMap = null;
        if (parameterMap != null) {
            try {
                modParameterMap = new HashMap<String, String[]>(parameterMap.size());
                for (Map.Entry entry : parameterMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        modParameterMap.put(key, (String[])value);
                        continue;
                    }
                    if (value == null) {
                        value = "null";
                    }
                    String[] newValue = new String[]{value.toString()};
                    modParameterMap.put(key, newValue);
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        CmsJspTagInclude.includeTagAction(this.getJspContext(), target, element, null, editable, cacheable, modParameterMap, CmsRequestUtil.getAtrributeMap((ServletRequest)this.getRequest()), (ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
    }

    public void include(String target, String element, Map parameterMap) throws JspException {
        this.include(target, element, false, parameterMap);
    }

    public void includeSilent(String target, String element) {
        try {
            this.include(target, element, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void includeSilent(String target, String element, boolean editable) {
        try {
            this.include(target, element, editable, null);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void includeSilent(String target, String element, boolean editable, Map parameterMap) {
        try {
            this.include(target, element, editable, parameterMap);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public void includeSilent(String target, String element, Map parameterMap) {
        try {
            this.include(target, element, parameterMap);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public String info(String property) {
        try {
            return CmsJspTagInfo.infoTagAction(property, this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
            CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_INFO_PROP_READ_1", property);
            return this.getMessage(msgContainer);
        }
    }

    public String label(String label) {
        if (this.isNotInitialized()) {
            return this.getMessage(NOT_INITIALIZED);
        }
        try {
            return CmsJspTagLabel.wpLabelTagAction(label, (ServletRequest)this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
            CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_WORKPL_LABEL_READ_1", label);
            return this.getMessage(msgContainer);
        }
    }

    public String link(String target) {
        return this.link(target, null);
    }

    public String link(String target, String detailPage) {
        if (this.isNotInitialized()) {
            return this.getMessage(NOT_INITIALIZED);
        }
        try {
            return CmsJspTagLink.linkTagAction(target, (ServletRequest)this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
            CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_GEN_LINK_1", target);
            return this.getMessage(msgContainer);
        }
    }

    public Map<String, String> properties() {
        return this.properties(null);
    }

    public Map<String, String> properties(String file) {
        Map<String, String> props = new HashMap<String, String>();
        if (this.isNotInitialized()) {
            return props;
        }
        try {
            props = CmsJspTagProperty.propertiesTagAction(file, (ServletRequest)this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return props;
    }

    public String property(String name) {
        return this.property(name, null, null, false);
    }

    public String property(String name, String file) {
        return this.property(name, file, null, false);
    }

    public String property(String name, String file, String defaultValue) {
        return this.property(name, file, defaultValue, false);
    }

    public String property(String name, String file, String defaultValue, boolean escapeHtml) {
        if (this.isNotInitialized()) {
            return this.getMessage(NOT_INITIALIZED);
        }
        try {
            if (file == null) {
                file = this.getController().getCmsObject().getRequestContext().getUri();
            }
            return CmsJspTagProperty.propertyTagAction(name, file, defaultValue, escapeHtml, (ServletRequest)this.getRequest());
        }
        catch (CmsSecurityException e) {
            if (defaultValue == null) {
                this.handleException(e);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        if (defaultValue == null) {
            CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_FILE_PROP_MISSING_2", name, file);
            return this.getMessage(msgContainer);
        }
        return defaultValue;
    }

    public boolean template(String element) {
        return this.template(element, null, false);
    }

    public boolean template(String elementlist, boolean checkall) {
        return this.template(null, elementlist, checkall);
    }

    public boolean template(String element, String elementlist, boolean checkall) {
        if (this.isNotInitialized()) {
            return true;
        }
        try {
            return CmsJspTagTemplate.templateTagAction(element, elementlist, checkall, false, (ServletRequest)this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
            return true;
        }
    }

    public String toAbsolute(String target) {
        if (this.isNotInitialized()) {
            return this.getMessage(NOT_INITIALIZED);
        }
        return CmsLinkManager.getAbsoluteUri(target, this.getController().getCurrentRequest().getElementUri());
    }

    public String user(String property) {
        if (this.isNotInitialized()) {
            return this.getMessage(NOT_INITIALIZED);
        }
        try {
            return CmsJspTagUser.userTagAction(property, (ServletRequest)this.getRequest());
        }
        catch (Throwable t) {
            this.handleException(t);
            CmsMessageContainer msgContainer = Messages.get().container("GUI_ERR_USER_PROP_READ_1", property);
            return this.getMessage(msgContainer);
        }
    }
}

