/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsJspTagContainer
extends TagSupport {
    public static final String CLASS_CONTAINER_ELEMENT_END_MARKER = "cms_ade_element_end";
    public static final String CLASS_CONTAINER_ELEMENT_START_MARKER = "cms_ade_element_start";
    public static final String CLASS_ELEMENT_ERROR = "cms_ade_element_error";
    public static final String CLASS_GROUP_CONTAINER_ELEMENT_MARKER = "cms_ade_groupcontainer";
    public static final String DEFAULT_MAX_ELEMENTS = "100";
    public static final String KEY_CONTAINER_DATA = "org_opencms_ade_containerpage_containers";
    private static final String CREATE_NO_TAG = "none";
    private static final String DEFAULT_TAG_NAME = "div";
    private static final Log LOG = CmsLog.getLog(CmsJspTagContainer.class);
    private static final long serialVersionUID = -1228397990961282556L;
    private boolean m_detailView;
    private String m_maxElements;
    private String m_name;
    private String m_tag;
    private String m_tagClass;
    private String m_type;
    private String m_width;

    protected static String getContainerDataTag(CmsContainerBean container, String widthStr, boolean isDetailView) throws JSONException {
        JSONObject jsonContainer = new JSONObject();
        jsonContainer.put("name", container.getName());
        jsonContainer.put("type", container.getType());
        jsonContainer.put("maxElem", container.getMaxElements());
        jsonContainer.put("isDetailView", isDetailView);
        int width = -1;
        try {
            if (widthStr != null) {
                width = Integer.parseInt(widthStr);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        jsonContainer.put("width", width);
        JSONArray jsonElements = new JSONArray();
        for (CmsContainerElementBean element : container.getElements()) {
            jsonElements.put(element.editorHash());
        }
        jsonContainer.put("elements", jsonElements);
        return new StringBuffer("<script type=\"text/javascript\">if (").append(KEY_CONTAINER_DATA).append("!=null) {").append(KEY_CONTAINER_DATA).append(".push(").append(jsonContainer.toString()).append("); } </script>").toString();
    }

    protected static String getTagClose(String tagName) {
        return "</" + tagName + ">";
    }

    protected static String getTagOpen(String tagName, String containerName, String tagClass) {
        String classAttr = CmsStringUtil.isEmptyOrWhitespaceOnly(tagClass) ? "" : "class=\"" + tagClass + "\" ";
        return "<" + tagName + " id=\"" + containerName + "\" " + classAttr + ">";
    }

    public int doStartTag() throws JspException {
        block28: {
            ServletRequest req = this.pageContext.getRequest();
            if (CmsFlexController.isCmsRequest(req)) {
                try {
                    String tagName;
                    CmsFlexController controller = CmsFlexController.getController(req);
                    CmsObject cms = controller.getCmsObject();
                    String requestUri = cms.getRequestContext().getUri();
                    Locale locale = cms.getRequestContext().getLocale();
                    CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
                    CmsContainerPageBean containerPage = standardContext.getPage();
                    if (containerPage == null) {
                        CmsResource pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(req));
                        if (pageResource == null) {
                            pageResource = cms.readResource(requestUri);
                        }
                        CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, pageResource, req);
                        containerPage = xmlContainerPage.getContainerPage(cms, locale);
                        standardContext.setPage(containerPage);
                    }
                    boolean createTag = false;
                    String string = tagName = CmsStringUtil.isEmptyOrWhitespaceOnly(this.getTag()) ? DEFAULT_TAG_NAME : this.getTag();
                    if (!CREATE_NO_TAG.equals(this.getTag())) {
                        createTag = true;
                        this.pageContext.getOut().print(CmsJspTagContainer.getTagOpen(tagName, this.getName(), this.getTagClass()));
                    }
                    int maxElements = this.getMaxElements(requestUri);
                    CmsContainerBean container = null;
                    if (containerPage != null) {
                        container = containerPage.getContainers().get(this.getName());
                    }
                    boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
                    boolean isUsedAsDetailView = false;
                    CmsResource detailContent = standardContext.getDetailContent();
                    if (this.m_detailView && detailContent != null) {
                        isUsedAsDetailView = true;
                    }
                    if (container == null) {
                        if (!isUsedAsDetailView) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_CONTAINER_NOT_FOUND_3", requestUri, locale, this.getName()));
                            }
                            if (!isOnline) {
                                try {
                                    this.pageContext.getOut().print(CmsJspTagContainer.getContainerDataTag(new CmsContainerBean(this.getName(), this.getType(), maxElements, null), this.getWidth(), isUsedAsDetailView));
                                }
                                catch (JSONException e) {
                                    throw new JspException((Throwable)e);
                                }
                            }
                            if (createTag) {
                                this.pageContext.getOut().print(CmsJspTagContainer.getTagClose(tagName));
                            }
                        } else {
                            container = new CmsContainerBean(this.getName(), this.getType(), maxElements, Collections.<CmsContainerElementBean>emptyList());
                        }
                    }
                    if (container == null) break block28;
                    standardContext.setContainer(container);
                    if (!this.getType().equals(container.getType())) {
                        throw new CmsIllegalStateException(Messages.get().container("LOG_WRONG_CONTAINER_TYPE_4", new Object[]{requestUri, locale, this.getName(), this.getType()}));
                    }
                    container.setMaxElements(maxElements);
                    container.setWidth(this.getWidth());
                    ArrayList<CmsContainerElementBean> allElements = new ArrayList<CmsContainerElementBean>();
                    CmsContainerElementBean detailElement = null;
                    if (isUsedAsDetailView) {
                        detailElement = this.generateDetailViewElement(cms, detailContent);
                    }
                    if (detailElement != null) {
                        allElements.add(detailElement);
                    } else {
                        allElements.addAll(container.getElements());
                    }
                    if (!isOnline) {
                        try {
                            CmsContainerBean cntBean = new CmsContainerBean(this.getName(), this.getType(), maxElements, allElements);
                            this.pageContext.getOut().print(CmsJspTagContainer.getContainerDataTag(cntBean, this.getWidth(), isUsedAsDetailView));
                        }
                        catch (JSONException e) {
                            throw new JspException((Throwable)e);
                        }
                    }
                    for (int i = 0; i < maxElements && i < allElements.size(); ++i) {
                        try {
                            this.renderContainerElement(cms, standardContext, (CmsContainerElementBean)allElements.get(i), locale);
                            continue;
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) continue;
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    if (createTag) {
                        this.pageContext.getOut().print(CmsJspTagContainer.getTagClose(tagName));
                    }
                }
                catch (Exception ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "container"), (Throwable)ex);
                    }
                    throw new JspException((Throwable)ex);
                }
            }
        }
        return 0;
    }

    public String getDetailview() {
        return String.valueOf(this.m_detailView);
    }

    public String getMaxElements() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_maxElements) ? DEFAULT_MAX_ELEMENTS : this.m_maxElements;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getTagClass() {
        return this.m_tagClass;
    }

    public String getType() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type) ? this.getName() : this.m_type;
    }

    public String getWidth() {
        return this.m_width;
    }

    public void release() {
        super.release();
        this.m_type = null;
        this.m_name = null;
        this.m_maxElements = null;
        this.m_tag = null;
        this.m_tagClass = null;
        this.m_detailView = false;
    }

    public void setDetailview(String detailView) {
        this.m_detailView = Boolean.parseBoolean(detailView);
    }

    public void setMaxElements(String maxElements) {
        this.m_maxElements = maxElements;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setTag(String tag) {
        this.m_tag = tag;
    }

    public void setTagClass(String tagClass) {
        this.m_tagClass = tagClass;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setWidth(String width) {
        this.m_width = width;
    }

    protected String getElementWrapperTagEnd(boolean isGroupcontainer) {
        if (isGroupcontainer) {
            return "</div>";
        }
        return "<div class=\"cms_ade_element_end\" style=\"display:none\"></div>";
    }

    protected String getElementWrapperTagStart(CmsObject cms, CmsContainerElementBean elementBean, boolean isGroupcontainer) throws CmsException {
        StringBuffer result = new StringBuffer("<div class='");
        if (isGroupcontainer) {
            result.append(CLASS_GROUP_CONTAINER_ELEMENT_MARKER);
        } else {
            result.append(CLASS_CONTAINER_ELEMENT_START_MARKER);
        }
        result.append("'");
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String noEditReason = "";
        elementBean.initResource(cms);
        noEditReason = CmsResourceTypeXmlContent.isXmlContent(elementBean.getResource()) ? new CmsResourceUtil(cms, elementBean.getResource()).getNoEditReason(wpLocale, true) : Messages.get().getBundle().key("GUI_ELEMENT_RESOURCE_CAN_NOT_BE_EDITED_0");
        result.append(" clientId='").append(elementBean.editorHash()).append("'");
        result.append(" alt='").append(elementBean.getSitePath()).append("'");
        String typeName = OpenCms.getResourceManager().getResourceType(elementBean.getResource().getTypeId()).getTypeName();
        if (elementBean.isCreateNew()) {
            result.append(" newType='").append(typeName).append("'");
            CmsResourceTypeConfig typeConfig = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri()).getResourceType(typeName);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(noEditReason) && (typeConfig == null || !typeConfig.checkCreatable(cms))) {
                String niceName = CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName);
                noEditReason = Messages.get().getBundle().key("GUI_CONTAINERPAGE_TYPE_NOT_CREATABLE_1", niceName);
            }
        }
        result.append(" hasprops='").append(this.hasProperties(cms, elementBean.getResource())).append("'");
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
        boolean viewPermission = cms.hasPermissions(elementBean.getResource(), CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.IGNORE_EXPIRATION) && settings.getAccess().getPermissions(cms, elementBean.getResource()).requiresViewPermission();
        result.append(" hasviewpermission='").append(viewPermission).append("'");
        result.append(" releasedandnotexpired='").append(elementBean.isReleasedAndNotExpired()).append("'");
        result.append(" rel='").append(CmsStringUtil.escapeHtml(noEditReason));
        if (isGroupcontainer) {
            result.append("'>");
        } else {
            result.append("' style='display:none;'></div>");
        }
        return result.toString();
    }

    protected void printElementWrapperTagEnd(boolean isOnline, boolean isGroupcontainer) throws IOException {
        if (!isOnline) {
            this.pageContext.getOut().print(this.getElementWrapperTagEnd(isGroupcontainer));
        }
    }

    protected void printElementWrapperTagStart(boolean isOnline, CmsObject cms, CmsContainerElementBean elementBean, boolean isGroupContainer) throws IOException, CmsException {
        if (!isOnline) {
            this.pageContext.getOut().print(this.getElementWrapperTagStart(cms, elementBean, isGroupContainer));
        }
    }

    private CmsContainerElementBean generateDetailViewElement(CmsObject cms, CmsResource detailContent) {
        CmsADEConfigData config;
        CmsFormatterConfiguration formatters;
        CmsFormatterBean formatter;
        CmsContainerElementBean element = null;
        if (detailContent != null && (formatter = (formatters = (config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri())).getFormatters(cms, detailContent)).getFormatter(this.getType(), this.getContainerWidth())) != null) {
            element = new CmsContainerElementBean(detailContent.getStructureId(), formatter.getJspStructureId(), null, false);
        }
        return element;
    }

    private int getContainerWidth() {
        int containerWidth = -1;
        try {
            containerWidth = Integer.parseInt(this.m_width);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return containerWidth;
    }

    private int getMaxElements(String requestUri) {
        String containerName = this.getName();
        String containerMaxElements = this.getMaxElements();
        int maxElements = -1;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(containerMaxElements)) {
            try {
                maxElements = Integer.parseInt(containerMaxElements);
            }
            catch (NumberFormatException e) {
                throw new CmsIllegalStateException(Messages.get().container("LOG_WRONG_CONTAINER_MAXELEMENTS_3", new Object[]{requestUri, containerName, containerMaxElements}), (Throwable)e);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MAXELEMENTS_NOT_SET_2", new Object[]{containerName, requestUri}));
        }
        return maxElements;
    }

    private CmsADESessionCache getSessionCache(CmsObject cms) {
        CmsADESessionCache sessionCache = (CmsADESessionCache)((HttpServletRequest)this.pageContext.getRequest()).getSession().getAttribute("__OCMS_ADE_CACHE__");
        if (sessionCache == null) {
            sessionCache = new CmsADESessionCache(cms);
            ((HttpServletRequest)this.pageContext.getRequest()).getSession().setAttribute("__OCMS_ADE_CACHE__", (Object)sessionCache);
        }
        return sessionCache;
    }

    private boolean hasProperties(CmsObject cms, CmsResource resource) throws CmsException {
        if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
            return false;
        }
        Map<String, CmsXmlContentProperty> propConfig = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource).getSettings(cms, resource);
        return !propConfig.isEmpty();
    }

    private void printElementErrorTag(boolean isOnline, String elementSitePath, String formatterSitePath, Exception exception) throws IOException {
        if (!isOnline) {
            String stacktrace = CmsException.getStackTraceAsString(exception);
            stacktrace = CmsStringUtil.isEmptyOrWhitespaceOnly(stacktrace) ? null : CmsEncoder.escapeXml(stacktrace);
            StringBuffer errorBox = new StringBuffer(256);
            errorBox.append("<div style=\"display:block; padding: 5px; border: red solid 2px; color: black; background: white;\" class=\"");
            errorBox.append(CLASS_ELEMENT_ERROR);
            errorBox.append("\">");
            errorBox.append(Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", elementSitePath, formatterSitePath));
            errorBox.append("<br />");
            errorBox.append(exception.getLocalizedMessage());
            if (stacktrace != null) {
                errorBox.append("<span onclick=\"__openStacktraceDialog(event);\" style=\"border: 1px solid black; cursor: pointer;\">");
                errorBox.append(Messages.get().getBundle().key("GUI_LABEL_STACKTRACE_0"));
                errorBox.append("<span title=\"");
                errorBox.append(Messages.get().getBundle().key("GUI_LABEL_STACKTRACE_0"));
                errorBox.append("\" class=\"hiddenStacktrace\" style=\"display:none;\"><pre><b>");
                errorBox.append(exception.getLocalizedMessage());
                errorBox.append("</b>\n\n");
                errorBox.append(stacktrace);
                errorBox.append("</pre></span></span>");
            }
            errorBox.append("</div>");
            this.pageContext.getOut().print(errorBox.toString());
        }
    }

    private void renderContainerElement(CmsObject cms, CmsJspStandardContextBean standardContext, CmsContainerElementBean element, Locale locale) throws CmsException, CmsXmlException, CmsLoaderException, IOException {
        ServletRequest req = this.pageContext.getRequest();
        ServletResponse res = this.pageContext.getResponse();
        String containerType = this.getType();
        int containerWidth = this.getContainerWidth();
        boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
        element.initResource(cms);
        this.getSessionCache(cms).setCacheContainerElement(element.editorHash(), element);
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        if (element.isGroupContainer(cms)) {
            CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, element.getResource(), req);
            CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(cms, cms.getRequestContext().getLocale());
            if (!groupContainer.getTypes().contains(containerType)) {
                throw new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", element.getResource().getRootPath(), OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName(), containerType));
            }
            this.printElementWrapperTagStart(isOnline, cms, element, true);
            for (CmsContainerElementBean subelement : groupContainer.getElements()) {
                try {
                    subelement.initResource(cms);
                    this.getSessionCache(cms).setCacheContainerElement(subelement.editorHash(), subelement);
                    CmsFormatterConfiguration subelementFormatters = adeConfig.getFormatters(cms, subelement.getResource());
                    CmsFormatterBean subelementFormatter = subelementFormatters.getFormatter(containerType, containerWidth);
                    if (subelementFormatter == null) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", subelement.getSitePath(), OpenCms.getResourceManager().getResourceType(subelement.getResource()).getTypeName(), containerType)));
                        continue;
                    }
                    this.printElementWrapperTagStart(isOnline, cms, subelement, false);
                    standardContext.setElement(subelement);
                    try {
                        CmsJspTagInclude.includeTagAction(this.pageContext, subelementFormatter.getJspRootPath(), null, locale, false, isOnline, null, CmsRequestUtil.getAtrributeMap(req), req, res);
                    }
                    catch (Exception e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", subelement.getSitePath(), subelementFormatter), (Throwable)e);
                        }
                        this.printElementErrorTag(isOnline, subelement.getSitePath(), subelementFormatter.getJspRootPath(), e);
                    }
                    this.printElementWrapperTagEnd(isOnline, false);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e);
                }
            }
            this.printElementWrapperTagEnd(isOnline, true);
        } else {
            String formatter = null;
            try {
                formatter = cms.getSitePath(cms.readResource(element.getFormatterId()));
            }
            catch (CmsException e) {
                CmsFormatterConfiguration elementFormatters = adeConfig.getFormatters(cms, element.getResource());
                CmsFormatterBean elementFormatterBean = elementFormatters.getFormatter(containerType, containerWidth);
                if (elementFormatterBean == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)new CmsIllegalStateException(Messages.get().container("ERR_XSD_NO_TEMPLATE_FORMATTER_3", element.getSitePath(), OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName(), containerType)));
                    }
                    return;
                }
                formatter = elementFormatterBean.getJspRootPath();
            }
            this.printElementWrapperTagStart(isOnline, cms, element, false);
            standardContext.setElement(element);
            try {
                CmsJspTagInclude.includeTagAction(this.pageContext, formatter, null, locale, false, isOnline, null, CmsRequestUtil.getAtrributeMap(req), req, res);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_CONTAINER_PAGE_ELEMENT_RENDER_ERROR_2", element.getSitePath(), formatter), (Throwable)e);
                }
                this.printElementErrorTag(isOnline, element.getSitePath(), formatter, e);
            }
            this.printElementWrapperTagEnd(isOnline, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsonContainer {
        elements,
        isDetailView,
        maxElem,
        name,
        type,
        width;

    }
}

