/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspTagProperty
extends TagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagProperty.class);
    private static final long serialVersionUID = -4040833541258687977L;
    private String m_defaultValue;
    private boolean m_escapeHtml;
    private String m_propertyFile;
    private String m_propertyName;

    public static Map<String, String> propertiesTagAction(String action, ServletRequest req) throws CmsException {
        CmsFlexController controller = CmsFlexController.getController(req);
        FileUse useAction = FileUse.URI;
        if (action != null) {
            useAction = FileUse.parse(action);
        }
        String vfsUri = null;
        boolean search = false;
        if (useAction != null) {
            switch (useAction) {
                case URI: 
                case PARENT: {
                    vfsUri = controller.getCmsObject().getRequestContext().getUri();
                    break;
                }
                case SEARCH: 
                case SEARCH_URI: 
                case SEARCH_PARENT: {
                    vfsUri = controller.getCmsObject().getRequestContext().getUri();
                    search = true;
                    break;
                }
                case ELEMENT_URI: 
                case THIS: {
                    vfsUri = controller.getCurrentRequest().getElementUri();
                    break;
                }
                case SEARCH_ELEMENT_URI: 
                case SEARCH_THIS: {
                    vfsUri = controller.getCurrentRequest().getElementUri();
                    search = true;
                    break;
                }
            }
        } else {
            vfsUri = CmsLinkManager.getAbsoluteUri(action, controller.getCurrentRequest().getElementUri());
            search = false;
        }
        Map<String, String> value = new HashMap<String, String>();
        if (vfsUri != null) {
            value = CmsProperty.toMap(controller.getCmsObject().readPropertyObjects(vfsUri, search));
        }
        return value;
    }

    public static String propertyTagAction(String property, String action, String defaultValue, boolean escape, ServletRequest req) throws CmsException {
        String value = CmsJspTagProperty.propertiesTagAction(action, req).get(property);
        if (value == null) {
            value = defaultValue;
        }
        if (escape) {
            value = CmsEncoder.escapeHtml(value);
        }
        return value;
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String prop = CmsJspTagProperty.propertyTagAction(this.getName(), this.getFile(), this.m_defaultValue, this.m_escapeHtml, req);
                if (prop == null) {
                    prop = "";
                }
                this.pageContext.getOut().print(prop);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "property"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getDefault() {
        return this.m_defaultValue != null ? this.m_defaultValue : "";
    }

    public String getEscapeHtml() {
        return "" + this.m_escapeHtml;
    }

    public String getFile() {
        return this.m_propertyFile != null ? this.m_propertyFile : "parent";
    }

    public String getName() {
        return this.m_propertyName != null ? this.m_propertyName : "";
    }

    public void release() {
        super.release();
        this.m_propertyFile = null;
        this.m_propertyName = null;
        this.m_defaultValue = null;
        this.m_escapeHtml = false;
    }

    public void setDefault(String def) {
        if (def != null) {
            this.m_defaultValue = def;
        }
    }

    public void setEscapeHtml(String value) {
        if (value != null) {
            this.m_escapeHtml = Boolean.valueOf(value.trim());
        }
    }

    public void setFile(String file) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(file)) {
            this.m_propertyFile = file;
        }
    }

    public void setName(String name) {
        if (name != null) {
            this.m_propertyName = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileUse {
        ELEMENT_URI("element.uri"),
        PARENT("parent"),
        SEARCH("search"),
        SEARCH_ELEMENT_URI("search.element.uri"),
        SEARCH_PARENT("search-parent"),
        SEARCH_THIS("search-this"),
        SEARCH_URI("search.uri"),
        THIS("this"),
        URI("uri");

        private String m_name;

        private FileUse(String name) {
            this.m_name = name;
        }

        public static FileUse parse(String name) {
            for (FileUse fileUse : FileUse.values()) {
                if (!fileUse.getName().equals(name)) continue;
                return fileUse;
            }
            return null;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

