/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsSubscriptionReadMode;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspTagUserTracking
extends TagSupport {
    public static final String SESSION_PREFIX_SUBSCRIBED = "__ocmssubscribed_";
    public static final String SESSION_PREFIX_VISITED = "__ocmsvisited_";
    private static final Log LOG = CmsLog.getLog(CmsJspTagUserTracking.class);
    private static final long serialVersionUID = 4253583631739670341L;
    private static final String[] TAG_ACTIONS = new String[]{"visit", "subscribe", "unsubscribe", "checkvisited", "checksubscribed"};
    private static final List<String> TRACK_ACTIONS_LIST = Arrays.asList(TAG_ACTIONS);
    private String m_action;
    private boolean m_currentuser;
    private String m_file;
    private String m_group;
    private boolean m_includegroups;
    private boolean m_online;
    private boolean m_subfolder;
    private String m_user;

    public static String userTrackingTagAction(String action, String fileName, boolean subFolder, boolean currentUser, String userName, boolean includeGroups, String groupName, HttpServletRequest req) throws JspException {
        String result = "";
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        CmsObject cms = controller.getCmsObject();
        CmsUser user = null;
        CmsGroup group = null;
        int actionIndex = TRACK_ACTIONS_LIST.indexOf(action);
        try {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(groupName)) {
                group = cms.readGroup(groupName);
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userName)) {
                user = cms.readUser(userName);
            } else if (currentUser) {
                user = cms.getRequestContext().getCurrentUser();
            }
            if (group == null && user == null && actionIndex != 4) {
                user = cms.getRequestContext().getCurrentUser();
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(fileName)) {
                fileName = cms.getRequestContext().getUri();
            }
            switch (actionIndex) {
                case 1: {
                    if (group != null) {
                        OpenCms.getSubscriptionManager().subscribeResourceFor(cms, (CmsPrincipal)group, fileName);
                    }
                    if (user != null) {
                        OpenCms.getSubscriptionManager().subscribeResourceFor(cms, (CmsPrincipal)user, fileName);
                    }
                    CmsJspTagUserTracking.removeSessionAttributes(new String[]{SESSION_PREFIX_SUBSCRIBED}, req);
                    break;
                }
                case 2: {
                    if (group != null) {
                        OpenCms.getSubscriptionManager().unsubscribeResourceFor(cms, (CmsPrincipal)group, fileName);
                    }
                    if (user != null) {
                        OpenCms.getSubscriptionManager().unsubscribeResourceFor(cms, (CmsPrincipal)user, fileName);
                    }
                    CmsJspTagUserTracking.removeSessionAttributes(new String[]{SESSION_PREFIX_SUBSCRIBED}, req);
                    break;
                }
                case 3: {
                    result = String.valueOf(CmsJspTagUserTracking.isResourceVisited(cms, fileName, subFolder, user, req));
                    break;
                }
                case 4: {
                    ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>();
                    if (group == null && includeGroups) {
                        if (user != null) {
                            groups.addAll(cms.getGroupsOfUser(user.getName(), false));
                        } else {
                            groups.addAll(cms.getGroupsOfUser(cms.getRequestContext().getCurrentUser().getName(), false));
                        }
                    } else if (group != null) {
                        groups.add(group);
                    }
                    result = String.valueOf(CmsJspTagUserTracking.isResourceSubscribed(cms, fileName, subFolder, user, groups, req));
                    break;
                }
                default: {
                    OpenCms.getSubscriptionManager().markResourceAsVisitedBy(cms, fileName, user);
                    CmsJspTagUserTracking.removeSessionAttributes(new String[]{SESSION_PREFIX_SUBSCRIBED, SESSION_PREFIX_VISITED}, req);
                    break;
                }
            }
        }
        catch (CmsException e) {
            Throwable t = controller.setThrowable(e, cms.getRequestContext().getUri());
            throw new JspException(t);
        }
        return result;
    }

    protected static String generateSessionKey(String prefix, String fileName, boolean subFolder, CmsUser user, List<CmsGroup> groups) {
        StringBuffer result = new StringBuffer(256);
        result.append(prefix);
        result.append(CmsResource.getFolderPath(fileName).hashCode()).append("_");
        result.append(subFolder);
        if (user != null) {
            result.append("_").append(user.getName().hashCode());
        }
        if (groups != null && !groups.isEmpty()) {
            StringBuffer groupNames = new StringBuffer(128);
            Iterator<CmsGroup> i = groups.iterator();
            while (i.hasNext()) {
                groupNames.append(i.next().getName());
            }
            result.append("_").append(groupNames.toString().hashCode());
        }
        return result.toString();
    }

    protected static boolean isResourceSubscribed(CmsObject cms, String fileName, boolean subFolder, CmsUser user, List<CmsGroup> groups, HttpServletRequest req) throws CmsException {
        String sessionKey;
        CmsResource checkResource = cms.readResource(fileName);
        HttpSession session = req.getSession(true);
        List<CmsResource> subscribedResources = (List<CmsResource>)session.getAttribute(sessionKey = CmsJspTagUserTracking.generateSessionKey(SESSION_PREFIX_SUBSCRIBED, fileName, subFolder, user, groups));
        if (subscribedResources == null) {
            CmsSubscriptionFilter filter = new CmsSubscriptionFilter();
            filter.setParentPath(CmsResource.getFolderPath(checkResource.getRootPath()));
            filter.setIncludeSubfolders(subFolder);
            filter.setUser(user);
            filter.setGroups(groups);
            filter.setMode(CmsSubscriptionReadMode.ALL);
            subscribedResources = OpenCms.getSubscriptionManager().readSubscribedResources(cms, filter);
            session.setAttribute(sessionKey, subscribedResources);
        }
        return subscribedResources.contains(checkResource);
    }

    protected static boolean isResourceVisited(CmsObject cms, String fileName, boolean subFolder, CmsUser user, HttpServletRequest req) throws CmsException {
        CmsResource checkResource = cms.readResource(fileName);
        HttpSession session = req.getSession(true);
        String sessionKey = CmsJspTagUserTracking.generateSessionKey(SESSION_PREFIX_VISITED, fileName, subFolder, user, null);
        List<CmsResource> visitedResources = (List<CmsResource>)req.getSession(true).getAttribute(sessionKey);
        if (visitedResources == null) {
            CmsVisitedByFilter filter = new CmsVisitedByFilter();
            filter.setUser(user);
            filter.setParentPath(CmsResource.getFolderPath(checkResource.getRootPath()));
            filter.setIncludeSubfolders(subFolder);
            visitedResources = OpenCms.getSubscriptionManager().readResourcesVisitedBy(cms, filter);
            session.setAttribute(sessionKey, visitedResources);
        }
        return visitedResources.contains(checkResource);
    }

    protected static void removeSessionAttributes(String[] prefixes, HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        Enumeration en = session.getAttributeNames();
        while (en.hasMoreElements()) {
            String attrKey = (String)en.nextElement();
            for (int i = 0; i < prefixes.length; ++i) {
                if (!attrKey.startsWith(prefixes[i])) continue;
                session.removeAttribute(attrKey);
            }
        }
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            CmsObject cms = CmsFlexController.getCmsObject(req);
            if (this.m_online && !cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                return 0;
            }
            try {
                String result = CmsJspTagUserTracking.userTrackingTagAction(this.m_action, this.m_file, this.m_subfolder, this.m_currentuser, this.m_user, this.m_includegroups, this.m_group, (HttpServletRequest)req);
                this.pageContext.getOut().print(result);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "usertracking"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getAction() {
        return this.m_action != null ? this.m_action : "";
    }

    public String getCurrentuser() {
        return String.valueOf(this.m_currentuser);
    }

    public String getFile() {
        return this.m_file != null ? this.m_file : "";
    }

    public String getGroup() {
        return this.m_group != null ? this.m_group : "";
    }

    public String getIncludegroups() {
        return String.valueOf(this.m_includegroups);
    }

    public String getOnline() {
        return String.valueOf(this.m_online);
    }

    public String getSubfolder() {
        return String.valueOf(this.m_subfolder);
    }

    public String getUser() {
        return this.m_user != null ? this.m_user : "";
    }

    public void release() {
        super.release();
        this.m_action = null;
        this.m_file = null;
        this.m_group = null;
        this.m_includegroups = false;
        this.m_online = false;
        this.m_subfolder = false;
        this.m_user = null;
    }

    public void setAction(String action) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(action)) {
            this.m_action = action;
        }
    }

    public void setCurrentuser(String currentUser) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(currentUser)) {
            this.m_currentuser = Boolean.valueOf(currentUser);
        }
    }

    public void setFile(String file) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(file)) {
            this.m_file = file;
        }
    }

    public void setGroup(String group) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(group)) {
            this.m_group = group;
        }
    }

    public void setIncludegroups(String includeGroups) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(includeGroups)) {
            this.m_includegroups = Boolean.valueOf(includeGroups);
        }
    }

    public void setOnline(String online) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(online)) {
            this.m_online = Boolean.valueOf(online);
        }
    }

    public void setSubfolder(String subfolder) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(subfolder)) {
            this.m_subfolder = Boolean.valueOf(subfolder);
        }
    }

    public void setUser(String user) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(user)) {
            this.m_user = user;
        }
    }
}

