/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.jsp.CmsJspTagNavigation;
import org.opencms.main.CmsException;
import org.opencms.util.CmsCollectionsGenericWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsJspNavigationBean {
    protected CmsJspNavBuilder m_builder;
    protected CmsObject m_cms;
    protected CmsJspNavElement m_current;
    protected int m_endLevel;
    protected Map<String, Boolean> m_isActive;
    protected Map<String, Boolean> m_isParent;
    protected List<CmsJspNavElement> m_items;
    protected String m_param;
    protected String m_resource;
    protected int m_startLevel;
    protected CmsJspTagNavigation.Type m_type;

    public CmsJspNavigationBean(CmsObject cms, CmsJspTagNavigation.Type type, int startLevel, int endLevel, String resource, String param) {
        this.m_cms = cms;
        this.m_builder = new CmsJspNavBuilder(this.m_cms);
        this.m_type = type;
        this.m_startLevel = startLevel;
        this.m_endLevel = endLevel;
        this.m_resource = resource;
        this.m_param = param;
    }

    public CmsJspNavElement getCurrent() {
        if (this.m_current == null) {
            this.m_current = this.m_builder.getNavigationForResource();
        }
        return this.m_current;
    }

    public Map<String, Boolean> getIsActive() {
        if (this.m_isActive == null) {
            this.m_isActive = CmsCollectionsGenericWrapper.createLazyMap(new CmsIsActiveTransformer());
        }
        return this.m_isActive;
    }

    public Map<String, Boolean> getIsParent() {
        if (this.m_isParent == null) {
            this.m_isParent = CmsCollectionsGenericWrapper.createLazyMap(new CmsIsParentTransformer());
        }
        return this.m_isParent;
    }

    public List<CmsJspNavElement> getItems() {
        if (this.m_items == null) {
            switch (this.m_type) {
                case forFolder: {
                    if (this.m_startLevel == Integer.MIN_VALUE) {
                        if (this.m_resource == null) {
                            this.m_items = this.m_builder.getNavigationForFolder();
                            break;
                        }
                        this.m_items = this.m_builder.getNavigationForFolder(this.m_resource);
                        break;
                    }
                    if (this.m_resource == null) {
                        this.m_items = this.m_builder.getNavigationForFolder(this.m_startLevel);
                        break;
                    }
                    this.m_items = this.m_builder.getNavigationForFolder(this.m_resource, this.m_startLevel);
                    break;
                }
                case forSite: {
                    if (this.m_resource == null) {
                        this.m_items = this.m_builder.getSiteNavigation();
                        break;
                    }
                    this.m_items = this.m_builder.getSiteNavigation(this.m_resource, this.m_endLevel);
                    break;
                }
                case breadCrumb: {
                    if (this.m_resource != null) {
                        this.m_items = this.m_builder.getNavigationBreadCrumb(this.m_resource, this.m_startLevel, this.m_endLevel, Boolean.valueOf(this.m_param));
                        break;
                    }
                    if (this.m_startLevel == Integer.MIN_VALUE) {
                        this.m_items = this.m_builder.getNavigationBreadCrumb();
                        break;
                    }
                    if (this.m_endLevel == Integer.MIN_VALUE) {
                        this.m_items = this.m_builder.getNavigationBreadCrumb(this.m_startLevel, this.m_endLevel);
                        break;
                    }
                    this.m_items = this.m_builder.getNavigationBreadCrumb(this.m_startLevel, Boolean.valueOf(this.m_param));
                    break;
                }
                case treeForFolder: {
                    if (this.m_resource == null) {
                        this.m_items = this.m_builder.getNavigationTreeForFolder(this.m_startLevel, this.m_endLevel);
                        break;
                    }
                    this.m_items = this.m_builder.getNavigationTreeForFolder(this.m_resource, this.m_startLevel, this.m_endLevel);
                    break;
                }
                default: {
                    ArrayList<CmsJspNavElement> items = new ArrayList<CmsJspNavElement>(1);
                    if (this.m_resource == null) {
                        items.add(this.m_builder.getNavigationForResource());
                    } else {
                        items.add(this.m_builder.getNavigationForResource(this.m_resource));
                    }
                    this.m_items = items;
                }
            }
        }
        return this.m_items;
    }

    public class CmsIsParentTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspNavigationBean.this.m_cms.getRequestContext().getUri().startsWith((String)input);
        }
    }

    public class CmsIsActiveTransformer
    implements Transformer {
        public Object transform(Object input) {
            String resourceName = (String)input;
            Boolean result = Boolean.FALSE;
            if (CmsResource.isFolder(resourceName)) {
                try {
                    CmsResource defaultFile = CmsJspNavigationBean.this.m_cms.readDefaultFile(resourceName);
                    if (defaultFile != null && CmsJspNavigationBean.this.m_cms.getRequestContext().getSitePath(defaultFile).equals(CmsJspNavigationBean.this.m_cms.getRequestContext().getUri())) {
                        result = Boolean.TRUE;
                    }
                }
                catch (CmsException e) {}
            } else {
                result = CmsJspNavigationBean.this.m_cms.getRequestContext().getUri().equals(resourceName);
            }
            return result;
        }
    }
}

