/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.lock;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opencms.file.CmsUser;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsLockFilter
implements Cloneable {
    public static final CmsLockFilter FILTER_ALL = new CmsLockFilter(true).filterIncludeChildren();
    public static final CmsLockFilter FILTER_INHERITED = new CmsLockFilter(true);
    public static final CmsLockFilter FILTER_NON_INHERITED = new CmsLockFilter(false);
    private CmsUUID m_notOwnedByUserId;
    private boolean m_includeChildren;
    private CmsUUID m_ownedByUserId;
    private boolean m_includeParents;
    private CmsUUID m_projectId;
    private boolean m_sharedExclusive;
    private Set<CmsLockType> m_types = new HashSet<CmsLockType>();
    private CmsUser m_notLockableByUser;
    private CmsUser m_lockableByUser;

    private CmsLockFilter(boolean inherited) {
        this.m_includeChildren = !inherited;
        this.m_includeParents = inherited;
    }

    public Object clone() {
        CmsLockFilter filter = new CmsLockFilter(false);
        filter.m_includeChildren = this.m_includeChildren;
        filter.m_includeParents = this.m_includeParents;
        filter.m_types = new HashSet<CmsLockType>(this.m_types);
        filter.m_ownedByUserId = this.m_ownedByUserId;
        filter.m_notOwnedByUserId = this.m_notOwnedByUserId;
        filter.m_projectId = this.m_projectId;
        filter.m_notLockableByUser = this.m_notLockableByUser;
        filter.m_lockableByUser = this.m_lockableByUser;
        return filter;
    }

    public CmsLockFilter filterNotOwnedByUserId(CmsUUID userId) {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_notOwnedByUserId = userId;
        return filter;
    }

    public CmsLockFilter filterNotLockableByUser(CmsUser user) {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_notLockableByUser = user;
        return filter;
    }

    public CmsLockFilter filterLockableByUser(CmsUser user) {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_lockableByUser = user;
        return filter;
    }

    public CmsLockFilter filterIncludeChildren() {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_includeChildren = true;
        return filter;
    }

    public CmsLockFilter filterOwnedByUserId(CmsUUID userId) {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_ownedByUserId = userId;
        return filter;
    }

    public CmsLockFilter filterIncludeParents() {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_includeParents = true;
        return filter;
    }

    public CmsLockFilter filterProject(CmsUUID projectId) {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_projectId = projectId;
        return filter;
    }

    public CmsLockFilter filterSharedExclusive() {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_sharedExclusive = true;
        return filter;
    }

    public CmsLockFilter filterType(CmsLockType type) {
        CmsLockFilter filter = (CmsLockFilter)this.clone();
        filter.m_types.add(type);
        return filter;
    }

    public CmsUUID getOwnedByUserId() {
        return this.m_ownedByUserId;
    }

    public CmsUUID getNotOwnedByUserId() {
        return this.m_notOwnedByUserId;
    }

    public CmsUser getLockableByUserId() {
        return this.m_lockableByUser;
    }

    public CmsUser getNotLockableByUserId() {
        return this.m_notLockableByUser;
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public Set<CmsLockType> getTypes() {
        return Collections.unmodifiableSet(this.m_types);
    }

    public boolean isIncludeChildren() {
        return this.m_includeChildren;
    }

    public boolean isIncludeParent() {
        return this.m_includeParents;
    }

    public boolean isSharedExclusive() {
        return this.m_sharedExclusive;
    }

    public boolean match(String rootPath, CmsLock lock) {
        boolean match = false;
        if (this.m_includeChildren) {
            match = lock.getResourceName().startsWith(rootPath);
        }
        if (!match && this.m_includeParents && lock.getResourceName().endsWith("/")) {
            match = rootPath.startsWith(lock.getResourceName());
        }
        if (match && this.m_projectId != null && !this.m_projectId.isNullUUID() && lock.getProjectId() != null) {
            match = lock.getProjectId().equals(this.m_projectId);
        }
        if (match && this.m_ownedByUserId != null && !this.m_ownedByUserId.isNullUUID()) {
            match = lock.getUserId().equals(this.m_ownedByUserId);
        }
        if (match && this.m_notOwnedByUserId != null && !this.m_notOwnedByUserId.isNullUUID()) {
            boolean bl = match = !lock.getUserId().equals(this.m_notOwnedByUserId);
        }
        if (match && this.m_lockableByUser != null) {
            match = lock.isLockableBy(this.m_lockableByUser);
        }
        if (match && this.m_notLockableByUser != null) {
            boolean bl = match = !lock.isLockableBy(this.m_notLockableByUser);
        }
        if (match && !this.m_types.isEmpty()) {
            match = this.m_types.contains(lock.getType());
            boolean bl = match = match || this.m_includeParents && lock.isInherited();
        }
        if (!match && !lock.getRelatedLock().isNullLock()) {
            match = this.match(rootPath, lock.getRelatedLock());
        }
        return match;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(128);
        str.append("[");
        str.append("children").append("=").append(this.m_includeChildren).append(", ");
        str.append("parents").append("=").append(this.m_includeParents).append(", ");
        str.append("types").append("=").append(this.m_types).append(", ");
        str.append("includedUser").append("=").append(this.m_ownedByUserId).append(", ");
        str.append("excludedUser").append("=").append(this.m_notOwnedByUserId).append(", ");
        str.append("project").append("=").append(this.m_projectId).append(", ");
        str.append("lockableBy").append("=").append(this.m_lockableByUser).append(", ");
        str.append("notLockableBy").append("=").append(this.m_notLockableByUser).append(", ");
        str.append("includeShared").append("=").append(this.m_sharedExclusive);
        str.append("]");
        return str.toString();
    }
}

