/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsHtmlMail
extends HtmlEmail {
    private static final Log LOG = CmsLog.getLog(CmsHtmlMail.class);

    public CmsHtmlMail() {
        CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
        this.setHostName(host.getHostname());
        this.setSmtpPort(host.getPort());
        String userName = host.getUsername();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userName)) {
            this.setAuthentication(userName, host.getPassword());
        }
        try {
            this.setFrom(OpenCms.getSystemInfo().getMailSettings().getMailFromDefault());
        }
        catch (EmailException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_SENDER_ADDRESS_0"), (Throwable)e);
        }
    }
}

