/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDefaultSessionStorageProvider
implements I_CmsSessionStorageProvider {
    private FastHashMap m_sessions;

    @Override
    public CmsSessionInfo get(CmsUUID sessionId) {
        return (CmsSessionInfo)this.m_sessions.get((Object)sessionId);
    }

    @Override
    public List<CmsSessionInfo> getAll() {
        return this.getAllOfUser(null);
    }

    @Override
    public List<CmsSessionInfo> getAllOfUser(CmsUUID userId) {
        try {
            return this.getAllSelected(CmsCollectionsGenericWrapper.map(this.m_sessions), userId);
        }
        catch (ConcurrentModificationException e) {
            return this.getAllSelected(CmsCollectionsGenericWrapper.map(this.m_sessions.clone()), userId);
        }
    }

    @Override
    public int getSize() {
        return this.m_sessions.size();
    }

    @Override
    public void initialize() {
        this.m_sessions = new FastHashMap();
        this.m_sessions.setFast(true);
    }

    @Override
    public CmsSessionInfo put(CmsSessionInfo sessionInfo) {
        return (CmsSessionInfo)this.m_sessions.put((Object)sessionInfo.getSessionId(), (Object)sessionInfo);
    }

    @Override
    public CmsSessionInfo remove(CmsUUID sessionId) {
        return (CmsSessionInfo)this.m_sessions.remove((Object)sessionId);
    }

    @Override
    public void shutdown() {
        this.m_sessions.clear();
        this.m_sessions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validate() {
        try {
            try {
                this.m_sessions.setFast(false);
                Iterator sessions = CmsCollectionsGenericWrapper.map(this.m_sessions).entrySet().iterator();
                while (sessions.hasNext()) {
                    Map.Entry entry = sessions.next();
                    CmsUUID sessionId = (CmsUUID)entry.getKey();
                    CmsSessionInfo sessionInfo = (CmsSessionInfo)entry.getValue();
                    if (sessionInfo == null || this.m_sessions.get((Object)sessionId) == null || !sessionInfo.isExpired()) continue;
                    try {
                        sessions.remove();
                    }
                    catch (ConcurrentModificationException ex) {}
                }
                Object var7_7 = null;
                if (this.m_sessions == null) return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Object var7_8 = null;
                if (this.m_sessions == null) return;
                this.m_sessions.setFast(true);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.m_sessions == null) throw throwable;
            this.m_sessions.setFast(true);
            throw throwable;
        }
        this.m_sessions.setFast(true);
    }

    private List<CmsSessionInfo> getAllSelected(Map<CmsUUID, CmsSessionInfo> allSessions, CmsUUID userId) {
        ArrayList<CmsSessionInfo> userSessions = new ArrayList<CmsSessionInfo>();
        for (Map.Entry<CmsUUID, CmsSessionInfo> entry : allSessions.entrySet()) {
            CmsSessionInfo sessionInfo = entry.getValue();
            if (sessionInfo == null || userId != null && !userId.equals(sessionInfo.getUserId())) continue;
            userSessions.add(sessionInfo);
        }
        return userSessions;
    }
}

