/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsEventManager {
    protected static final I_CmsEventListener[] EVENT_LIST = new I_CmsEventListener[0];
    private static final Log LOG = CmsLog.getLog(CmsEventManager.class);
    private Map<Integer, List<I_CmsEventListener>> m_eventListeners = new HashMap<Integer, List<I_CmsEventListener>>();

    public void addCmsEventListener(I_CmsEventListener listener) {
        this.addCmsEventListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCmsEventListener(I_CmsEventListener listener, int[] eventTypes) {
        Map<Integer, List<I_CmsEventListener>> map = this.m_eventListeners;
        synchronized (map) {
            if (eventTypes == null) {
                eventTypes = new int[]{I_CmsEventListener.LISTENERS_FOR_ALL_EVENTS};
            }
            for (int i = 0; i < eventTypes.length; ++i) {
                Integer eventType = new Integer(eventTypes[i]);
                List<I_CmsEventListener> listeners = this.m_eventListeners.get(eventType);
                if (listeners == null) {
                    listeners = new ArrayList<I_CmsEventListener>();
                    this.m_eventListeners.put(eventType, listeners);
                }
                if (listeners.contains(listener)) continue;
                listeners.add(listener);
            }
        }
    }

    public void fireEvent(CmsEvent event) {
        this.fireEventHandler(this.m_eventListeners.get(event.getTypeInteger()), event);
        this.fireEventHandler(this.m_eventListeners.get(I_CmsEventListener.LISTENERS_FOR_ALL_EVENTS), event);
    }

    public void fireEvent(int type) {
        this.fireEvent(type, new HashMap<String, Object>());
    }

    public void fireEvent(int type, Map<String, Object> data) {
        this.fireEvent(new CmsEvent(type, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCmsEventListener(I_CmsEventListener listener) {
        Map<Integer, List<I_CmsEventListener>> map = this.m_eventListeners;
        synchronized (map) {
            Iterator<Integer> it = this.m_eventListeners.keySet().iterator();
            while (it.hasNext()) {
                List<I_CmsEventListener> listeners = this.m_eventListeners.get(it.next());
                listeners.remove(listener);
            }
        }
    }

    protected Map<Integer, List<I_CmsEventListener>> getEventListeners() {
        return this.m_eventListeners;
    }

    protected void initialize(CmsEventManager base) {
        this.m_eventListeners = new HashMap<Integer, List<I_CmsEventListener>>(base.getEventListeners());
    }

    protected void fireEventHandler(List<I_CmsEventListener> listeners, CmsEvent event) {
        if (!LOG.isDebugEnabled()) {
            if (listeners != null && listeners.size() > 0) {
                I_CmsEventListener[] list = listeners.toArray(EVENT_LIST);
                for (int i = 0; i < list.length; ++i) {
                    list[i].cmsEvent(event);
                }
            }
        } else {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_1", event.toString()));
            if (listeners != null && listeners.size() > 0) {
                I_CmsEventListener[] list = listeners.toArray(EVENT_LIST);
                if (event.getData() != null) {
                    for (String key : event.getData().keySet()) {
                        Object value = event.getData().get(key);
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_VALUE_3", key, value, event.toString()));
                    }
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_NO_EVENT_VALUE_1", event.toString()));
                }
                for (int j = 0; j < list.length; ++j) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_LISTENERS_3", list[j], new Integer(j), event.toString()));
                }
                for (int i = 0; i < list.length; ++i) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_START_LISTENER_3", list[i], new Integer(i), event.toString()));
                    list[i].cmsEvent(event);
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_END_LISTENER_3", list[i], new Integer(i), event.toString()));
                }
            } else {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_NO_LISTENER_1", event.toString()));
            }
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_EVENT_COMPLETE_1", event.toString()));
        }
    }
}

