/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.Messages;

public class CmsPermalinkResourceHandler
implements I_CmsResourceInit {
    public static final String PERMALINK_HANDLER = "/permalink/";
    private static final Log LOG = CmsLog.getLog(CmsPermalinkResourceHandler.class);

    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        String uri;
        if (resource == null && (uri = cms.getRequestContext().getUri()).startsWith(PERMALINK_HANDLER)) {
            String id = uri.substring(PERMALINK_HANDLER.length());
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                try {
                    cms.getRequestContext().setSiteRoot("/");
                    int pos = id.indexOf(46);
                    if (pos > -1) {
                        id = id.substring(0, id.indexOf(46));
                    }
                    resource = cms.readDefaultFile(id);
                }
                catch (Throwable e) {
                    CmsMessageContainer msg = Messages.get().container("ERR_PERMALINK_1", id);
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)msg.key(), e);
                    }
                    throw new CmsResourceInitException(msg, e);
                }
                Object var11_10 = null;
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
                if (resource != null) {
                    cms.getRequestContext().setUri(cms.getSitePath(resource));
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
                if (resource != null) {
                    cms.getRequestContext().setUri(cms.getSitePath(resource));
                }
                throw throwable;
            }
        }
        return resource;
    }
}

