/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.Messages;
import org.opencms.util.A_CmsModeStringEnumeration;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsServletContainerSettings {
    public static final CmsServletContainerCfgMode CFG_MODE_AUTO = CmsServletContainerCfgMode.MODE_AUTO;
    public static final CmsServletContainerCfgMode CFG_MODE_MANUAL = CmsServletContainerCfgMode.MODE_MANUAL;
    public static final CmsServletContainerCfgMode CFG_MODE_NONE = CmsServletContainerCfgMode.MODE_NONE;
    private static final Log LOG = CmsLog.getLog(CmsServletContainerSettings.class);
    private static boolean m_servletThrowsException = true;
    private static final String REQUEST_ERROR_PAGE_ATTRIBUTE_WEBLOGIC = "weblogic.servlet.errorPage";
    private static final String SERVLET_CONTAINER_GLASSFISH = "GlassFish";
    private static final String SERVLET_CONTAINER_RESIN = "Resin";
    private static final String SERVLET_CONTAINER_WEBLOGIC = "WebLogic Server";
    private static final String SERVLET_CONTAINER_WEBSPHERE = "IBM WebSphere Application Server";
    private String m_contextPath;
    private String m_defaultWebApplicationName;
    private CmsServletContainerCfgMode m_mode = CFG_MODE_NONE;
    private String m_openCmsContext;
    private boolean m_preventResponseFlush;
    private boolean m_releaseTagsAfterEnd = true;
    private String m_requestErrorPageAttribute;
    private String m_servletContainerName;
    private String m_servletPath;
    private String m_webApplicationName;
    private String m_webApplicationRfsPath;
    private String m_webInfRfsPath;

    public CmsServletContainerSettings(ServletContext context) {
        if (context != null) {
            String webInfRfsPath = context.getInitParameter("OpenCmsHome");
            if (CmsStringUtil.isEmpty(webInfRfsPath) && CmsStringUtil.isEmpty(webInfRfsPath = CmsFileUtil.searchWebInfFolder(context.getRealPath("/")))) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_FOLDER_0"));
            }
            String defaultWebApplication = context.getInitParameter("DefaultWebApplication");
            String servletMapping = context.getInitParameter("OpenCmsServlet");
            if (servletMapping == null) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_SERVLET_0"));
            }
            String servletContainerName = context.getServerInfo();
            String webApplicationContext = context.getInitParameter("WebApplicationContext");
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(webApplicationContext)) {
                try {
                    URL contextRelativeUrl = context.getResource("/");
                    webApplicationContext = contextRelativeUrl.getPath();
                    String[] pathTokens = CmsStringUtil.splitAsArray(webApplicationContext, '/');
                    webApplicationContext = pathTokens.length == 1 ? "" : pathTokens[pathTokens.length - 1];
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_CONTEXTNAME_0"), (Throwable)e);
                }
            }
            this.init(webInfRfsPath, defaultWebApplication, servletMapping, servletContainerName, webApplicationContext);
            this.initContainerSpecifics(context);
        }
    }

    protected CmsServletContainerSettings(String webInfRfsPath, String defaultWebApplication, String servletMapping, String servletContainerName, String webApplicationContext) {
        this.init(webInfRfsPath, defaultWebApplication, servletMapping, servletContainerName, webApplicationContext);
    }

    public static boolean isServletThrowsException() {
        return m_servletThrowsException;
    }

    public String getContextPath() {
        return this.m_contextPath;
    }

    public String getDefaultWebApplicationName() {
        return this.m_defaultWebApplicationName;
    }

    public CmsServletContainerCfgMode getMode() {
        return this.m_mode;
    }

    public String getOpenCmsContext() {
        return this.m_openCmsContext;
    }

    public String getRequestErrorPageAttribute() {
        return this.m_requestErrorPageAttribute;
    }

    public String getServletContainerName() {
        return this.m_servletContainerName;
    }

    public String getServletPath() {
        return this.m_servletPath;
    }

    public String getWebApplicationName() {
        return this.m_webApplicationName;
    }

    public String getWebApplicationRfsPath() {
        return this.m_webApplicationRfsPath;
    }

    public String getWebInfRfsPath() {
        return this.m_webInfRfsPath;
    }

    public boolean isPreventResponseFlush() {
        return this.m_preventResponseFlush;
    }

    public boolean isReleaseTagsAfterEnd() {
        return this.m_releaseTagsAfterEnd;
    }

    public void setMode(String configValue) {
        this.m_mode = CmsServletContainerCfgMode.valueOf(configValue);
    }

    public void setPreventResponseFlush(boolean preventResponseFlush) {
        this.m_preventResponseFlush = preventResponseFlush;
    }

    public void setReleaseTagsAfterEnd(boolean releaseTagsAfterEnd) {
        this.m_releaseTagsAfterEnd = releaseTagsAfterEnd;
    }

    public void setRequestErrorPageAttribute(String requestErrorPageAttribute) {
        this.m_requestErrorPageAttribute = requestErrorPageAttribute;
    }

    public void setServletThrowsException(boolean servletThrowsException) {
        m_servletThrowsException = servletThrowsException;
    }

    private void init(String webInfRfsPath, String defaultWebApplication, String servletMapping, String servletContainerName, String webApplicationContext) {
        if (!(webInfRfsPath = webInfRfsPath.replace('\\', '/')).endsWith("/")) {
            webInfRfsPath = webInfRfsPath + "/";
        }
        this.m_webInfRfsPath = CmsFileUtil.normalizePath(webInfRfsPath);
        if (defaultWebApplication == null) {
            defaultWebApplication = "";
        }
        if (defaultWebApplication.endsWith("/")) {
            defaultWebApplication = defaultWebApplication.substring(0, defaultWebApplication.length() - 1);
        }
        if (defaultWebApplication.startsWith("/")) {
            defaultWebApplication = defaultWebApplication.substring(1);
        }
        this.m_defaultWebApplicationName = defaultWebApplication;
        if (!servletMapping.startsWith("/")) {
            servletMapping = "/" + servletMapping;
        }
        if (servletMapping.endsWith("/*")) {
            servletMapping = servletMapping.substring(0, servletMapping.length() - 2);
        }
        this.m_servletPath = servletMapping;
        if (servletContainerName == null) {
            this.m_servletContainerName = "";
        }
        this.m_servletContainerName = servletContainerName;
        File path = new File(this.m_webInfRfsPath);
        this.m_webApplicationName = path.getParentFile().getName();
        String contextPath = webApplicationContext;
        if (contextPath == null && (contextPath = this.m_webApplicationName).endsWith(".war")) {
            contextPath = contextPath.substring(0, contextPath.length() - 4);
        }
        this.m_contextPath = contextPath.equals(this.getDefaultWebApplicationName()) || "".equals(contextPath) ? "" : "/" + contextPath;
        this.m_openCmsContext = this.m_contextPath + this.m_servletPath;
        this.m_webApplicationRfsPath = path.getParentFile().getAbsolutePath();
        if (!this.m_webApplicationRfsPath.endsWith(File.separator)) {
            this.m_webApplicationRfsPath = this.m_webApplicationRfsPath + File.separator;
        }
        this.m_releaseTagsAfterEnd = false;
        this.m_requestErrorPageAttribute = null;
        m_servletThrowsException = true;
        this.m_preventResponseFlush = false;
    }

    private void initContainerSpecifics(ServletContext context) {
        boolean bl = this.m_releaseTagsAfterEnd = this.m_servletContainerName.indexOf(SERVLET_CONTAINER_RESIN) <= -1;
        if (this.m_servletContainerName.indexOf(SERVLET_CONTAINER_WEBLOGIC) > -1) {
            this.m_requestErrorPageAttribute = REQUEST_ERROR_PAGE_ATTRIBUTE_WEBLOGIC;
        }
        m_servletThrowsException = true;
        m_servletThrowsException &= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_RESIN) < 0;
        m_servletThrowsException &= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_WEBLOGIC) < 0;
        m_servletThrowsException &= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_GLASSFISH) < 0;
        this.m_preventResponseFlush = false;
        this.m_preventResponseFlush |= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_WEBSPHERE) > -1;
        this.m_preventResponseFlush |= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_RESIN) > -1;
    }

    public static final class CmsServletContainerCfgMode
    extends A_CmsModeStringEnumeration {
        protected static final CmsServletContainerCfgMode MODE_AUTO = new CmsServletContainerCfgMode("auto");
        protected static final CmsServletContainerCfgMode MODE_MANUAL = new CmsServletContainerCfgMode("manual");
        protected static final CmsServletContainerCfgMode MODE_NONE = new CmsServletContainerCfgMode("none");
        private static final long serialVersionUID = -8191582624108081577L;

        private CmsServletContainerCfgMode(String mode) {
            super(mode);
        }

        public static CmsServletContainerCfgMode valueOf(String mode) {
            if (mode == null) {
                return null;
            }
            if (mode.equalsIgnoreCase(MODE_NONE.getMode())) {
                return MODE_NONE;
            }
            if (mode.equalsIgnoreCase(MODE_MANUAL.getMode())) {
                return MODE_MANUAL;
            }
            if (mode.equalsIgnoreCase(MODE_AUTO.getMode())) {
                return MODE_AUTO;
            }
            return null;
        }

        public boolean isAuto() {
            return this == MODE_AUTO;
        }

        public boolean isManual() {
            return this == MODE_MANUAL;
        }

        public boolean isNone() {
            return this == MODE_NONE;
        }
    }
}

